/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.polaris.ratelimit.client.pojo;

import com.tencent.polaris.api.config.Configuration;
import com.tencent.polaris.api.pojo.ServiceEventKey;
import com.tencent.polaris.api.pojo.ServiceEventKeysProvider;
import com.tencent.polaris.api.pojo.ServiceKey;
import com.tencent.polaris.api.pojo.ServiceRule;
import com.tencent.polaris.api.utils.CollectionUtils;
import com.tencent.polaris.client.flow.BaseFlow;
import com.tencent.polaris.client.flow.DefaultFlowControlParam;
import com.tencent.polaris.client.flow.FlowControlParam;
import com.tencent.polaris.ratelimit.api.rpc.Argument;
import com.tencent.polaris.ratelimit.api.rpc.QuotaRequest;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class CommonQuotaRequest
implements ServiceEventKeysProvider {
    private final ServiceEventKey svcEventKey;
    private final String method;
    private final Map<Integer, Map<String, String>> arguments;
    private final int count;
    private ServiceRule rateLimitRule;
    private final FlowControlParam flowControlParam;

    public CommonQuotaRequest(QuotaRequest quotaRequest, Configuration configuration) {
        this.svcEventKey = new ServiceEventKey(new ServiceKey(quotaRequest.getNamespace(), quotaRequest.getService()), ServiceEventKey.EventType.RATE_LIMITING);
        this.arguments = this.parseArguments(quotaRequest.getArguments());
        this.method = quotaRequest.getMethod();
        this.count = quotaRequest.getCount();
        this.flowControlParam = new DefaultFlowControlParam();
        BaseFlow.buildFlowControlParam(quotaRequest, configuration, this.flowControlParam);
    }

    private Map<Integer, Map<String, String>> parseArguments(Collection<Argument> arguments) {
        HashMap<Integer, Map<String, String>> argumentMap = new HashMap<Integer, Map<String, String>>();
        if (CollectionUtils.isEmpty(arguments)) {
            return argumentMap;
        }
        for (Argument argument : arguments) {
            Map stringMatchArgumentMap = argumentMap.computeIfAbsent(argument.getType().ordinal(), k -> new HashMap());
            stringMatchArgumentMap.put(argument.getKey(), argument.getValue());
        }
        return argumentMap;
    }

    public void setRateLimitRule(ServiceRule rateLimitRule) {
        this.rateLimitRule = rateLimitRule;
    }

    @Override
    public boolean isUseCache() {
        return false;
    }

    @Override
    public Set<ServiceEventKey> getSvcEventKeys() {
        return null;
    }

    @Override
    public ServiceEventKey getSvcEventKey() {
        return this.svcEventKey;
    }

    public String getMethod() {
        return this.method;
    }

    public Map<Integer, Map<String, String>> getArguments() {
        return this.arguments;
    }

    public ServiceRule getRateLimitRule() {
        return this.rateLimitRule;
    }

    public FlowControlParam getFlowControlParam() {
        return this.flowControlParam;
    }

    public int getCount() {
        return this.count;
    }
}

