/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.polaris.plugins.stat.prometheus.handler;

import com.tencent.polaris.api.config.verify.Verifier;
import com.tencent.polaris.api.utils.StringUtils;
import com.tencent.polaris.logging.LoggerFactory;
import org.slf4j.Logger;
import shade.polaris.com.fasterxml.jackson.annotation.JsonProperty;

public class PrometheusHandlerConfig
implements Verifier {
    private static final Logger LOGGER = LoggerFactory.getLogger(PrometheusHandlerConfig.class);
    @JsonProperty
    private String host;
    @JsonProperty
    private Integer port = 28080;
    @JsonProperty
    private String path = "/metrics";
    @JsonProperty
    private String pushgatewayAddress;

    @Override
    public void verify() {
        if (StringUtils.isNotBlank(this.pushgatewayAddress)) {
            LOGGER.warn("Prometheus pushgateway stat reporter plugin name has been changed to prometheus-pushgateway.");
        }
    }

    @Override
    public void setDefault(Object defaultObject) {
        if (null != defaultObject) {
            PrometheusHandlerConfig config = (PrometheusHandlerConfig)defaultObject;
            if (StringUtils.isBlank(this.host)) {
                this.setHost(config.getHost());
            }
            if (this.port == null) {
                this.setPort(config.getPort());
            }
            if (StringUtils.isBlank(this.path)) {
                this.setPath(config.getPath());
            }
        }
    }

    public String getHost() {
        return this.host;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public Integer getPort() {
        return this.port;
    }

    public void setPort(Integer port) {
        this.port = port;
    }

    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public String getPushgatewayAddress() {
        return this.pushgatewayAddress;
    }

    public void setPushgatewayAddress(String pushgatewayAddress) {
        this.pushgatewayAddress = pushgatewayAddress;
    }
}

