/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.polaris.plugins.router.healthy;

import com.tencent.polaris.api.config.plugin.PluginConfigProvider;
import com.tencent.polaris.api.config.verify.Verifier;
import com.tencent.polaris.api.exception.PolarisException;
import com.tencent.polaris.api.plugin.PluginType;
import com.tencent.polaris.api.plugin.common.InitContext;
import com.tencent.polaris.api.plugin.common.PluginTypes;
import com.tencent.polaris.api.plugin.route.RouteInfo;
import com.tencent.polaris.api.plugin.route.RouteResult;
import com.tencent.polaris.api.plugin.route.ServiceRouter;
import com.tencent.polaris.api.pojo.Instance;
import com.tencent.polaris.api.pojo.ServiceInstances;
import com.tencent.polaris.api.pojo.ServiceMetadata;
import com.tencent.polaris.client.util.Utils;
import com.tencent.polaris.plugins.router.common.AbstractServiceRouter;
import com.tencent.polaris.plugins.router.healthy.RecoverRouterConfig;
import java.util.List;
import java.util.stream.Collectors;

public class RecoverRouter
extends AbstractServiceRouter
implements PluginConfigProvider {
    private RecoverRouterConfig recoverRouterConfig;

    @Override
    public RouteResult router(RouteInfo routeInfo, ServiceInstances instances) throws PolarisException {
        List<Instance> healthyInstance = this.isExcludeCircuitBreakInstances(routeInfo) ? instances.getInstances().stream().filter(instance -> Utils.isHealthyInstance(instance, routeInfo.getStatusDimensions())).collect(Collectors.toList()) : instances.getInstances().stream().filter(Instance::isHealthy).collect(Collectors.toList());
        int healthyInstanceCount = healthyInstance.size();
        if (healthyInstanceCount == 0) {
            return new RouteResult(instances.getInstances(), RouteResult.State.Next);
        }
        return new RouteResult(healthyInstance, RouteResult.State.Next);
    }

    private boolean isExcludeCircuitBreakInstances(RouteInfo routeInfo) {
        if (routeInfo.isIncludeCircuitBreakInstances()) {
            return false;
        }
        return this.recoverRouterConfig.isExcludeCircuitBreakInstances();
    }

    @Override
    public PluginType getType() {
        return PluginTypes.SERVICE_ROUTER.getBaseType();
    }

    @Override
    public void init(InitContext ctx) throws PolarisException {
        this.recoverRouterConfig = ctx.getConfig().getConsumer().getServiceRouter().getPluginConfig(this.getName(), RecoverRouterConfig.class);
    }

    @Override
    public Class<? extends Verifier> getPluginConfigClazz() {
        return RecoverRouterConfig.class;
    }

    @Override
    public String getName() {
        return "recoverRouter";
    }

    @Override
    public ServiceRouter.Aspect getAspect() {
        return ServiceRouter.Aspect.AFTER;
    }

    @Override
    public boolean enable(RouteInfo routeInfo, ServiceMetadata dstSvcInfo) {
        return true;
    }
}

