/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.polaris.plugins.ratelimiter.unirate;

import com.tencent.polaris.api.config.Configuration;
import com.tencent.polaris.api.exception.PolarisException;
import com.tencent.polaris.api.plugin.ratelimiter.AmountInfo;
import com.tencent.polaris.api.plugin.ratelimiter.InitCriteria;
import com.tencent.polaris.api.plugin.ratelimiter.LocalQuotaInfo;
import com.tencent.polaris.api.plugin.ratelimiter.QuotaBucket;
import com.tencent.polaris.api.plugin.ratelimiter.QuotaResult;
import com.tencent.polaris.api.plugin.ratelimiter.RemoteQuotaInfo;
import com.tencent.polaris.client.pb.RateLimitProto;
import com.tencent.polaris.logging.LoggerFactory;
import com.tencent.polaris.plugins.ratelimiter.unirate.LeakyBucket;
import java.util.Map;
import org.slf4j.Logger;
import shade.polaris.com.google.protobuf.util.Durations;

public class RemoteAwareLeakyBucket
implements QuotaBucket {
    private static final Logger LOG = LoggerFactory.getLogger(RemoteAwareLeakyBucket.class);
    private final LeakyBucket leakyBucket = new LeakyBucket();

    public RemoteAwareLeakyBucket(InitCriteria initCriteria, Configuration configuration) {
        RateLimitProto.Rule rule = initCriteria.getRule();
        this.leakyBucket.setRule(rule);
        boolean instCount = true;
        boolean effective = false;
        double effectiveRate = 0.0;
        this.leakyBucket.setMaxQueuingDuration(configuration.getProvider().getRateLimit().getMaxQueuingTime());
        long maxDuration = 0L;
        for (RateLimitProto.Amount amount : rule.getAmountsList()) {
            int maxAmount = amount.getMaxAmount().getValue();
            if (maxAmount == 0) {
                this.leakyBucket.setRejectAll(true);
                return;
            }
            long duration = Durations.toMillis(amount.getValidDuration());
            if (!effective) {
                this.leakyBucket.setEffectiveAmount(maxAmount);
                this.leakyBucket.setEffectiveDuration(duration);
                maxDuration = duration;
                effective = true;
                effectiveRate = (double)this.leakyBucket.getEffectiveDuration().longValue() / (double)this.leakyBucket.getEffectiveAmount().intValue();
                continue;
            }
            double newRate = (double)duration / (double)maxAmount;
            if (newRate > effectiveRate) {
                this.leakyBucket.setEffectiveAmount(maxAmount);
                this.leakyBucket.setEffectiveDuration(duration);
                effectiveRate = newRate;
            }
            if (duration <= maxDuration) continue;
            maxDuration = duration;
        }
        effectiveRate = (double)this.leakyBucket.getEffectiveDuration().longValue() / (double)this.leakyBucket.getEffectiveAmount().intValue();
        this.leakyBucket.setTotalRate(effectiveRate);
        this.leakyBucket.setEffectiveRate(Math.round(effectiveRate));
        LOG.debug("Create a leaky bucket with effective rate with {}", (Object)this.leakyBucket.getEffectiveRate());
    }

    @Override
    public QuotaResult allocateQuota(long curTimeMs, int count) throws PolarisException {
        return this.leakyBucket.getQuota();
    }

    @Override
    public void release() {
    }

    @Override
    public void onRemoteUpdate(RemoteQuotaInfo remoteQuotaInfo) {
    }

    @Override
    public Map<Integer, LocalQuotaInfo> fetchLocalUsage(long curTimeMs) {
        return null;
    }

    @Override
    public Map<Integer, AmountInfo> getAmountInfo() {
        return null;
    }
}

