/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.polaris.plugins.loadbalancer.ringhash;

import com.tencent.polaris.plugins.loadbalancer.ringhash.HashStrategy;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;

public class MurmurHash
implements HashStrategy {
    @Override
    public int getHashCode(String origin) {
        ByteBuffer buf = ByteBuffer.wrap(origin.getBytes());
        int seed = 305441741;
        buf.order(ByteOrder.LITTLE_ENDIAN);
        long m3 = -4132994306676758123L;
        int r = 47;
        long h2 = (long)seed ^ (long)buf.remaining() * m3;
        while (buf.remaining() >= 8) {
            long k = buf.getLong();
            k *= m3;
            k ^= k >>> r;
            h2 ^= (k *= m3);
            h2 *= m3;
        }
        if (buf.remaining() > 0) {
            ByteBuffer finish = ByteBuffer.allocate(8).order(ByteOrder.LITTLE_ENDIAN);
            finish.put(buf).rewind();
            h2 ^= finish.getLong();
            h2 *= m3;
        }
        h2 ^= h2 >>> r;
        h2 *= m3;
        h2 ^= h2 >>> r;
        ByteOrder byteOrder = buf.order();
        buf.order(byteOrder);
        return (int)(h2 & 0xFFFFFFFFL);
    }
}

