/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.polaris.plugins.connector.grpc;

import com.tencent.polaris.api.exception.ErrorCode;
import com.tencent.polaris.api.exception.PolarisException;
import com.tencent.polaris.api.pojo.ServiceEventKey;
import com.tencent.polaris.api.utils.MapUtils;
import com.tencent.polaris.client.pb.RequestProto;
import com.tencent.polaris.client.pb.ResponseProto;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;
import shade.polaris.io.grpc.Metadata;
import shade.polaris.io.grpc.stub.AbstractStub;
import shade.polaris.io.grpc.stub.MetadataUtils;

public class GrpcUtil {
    public static final String OP_KEY_REGISTER_INSTANCE = "RegisterInstance";
    public static final String OP_KEY_DEREGISTER_INSTANCE = "DeregisterInstance";
    public static final String OP_KEY_INSTANCE_HEARTBEAT = "InstanceHeartbeat";
    public static final String OP_KEY_DISCOVER = "Discover";
    public static final String OP_KEY_REPORT_CLIENT = "ReportClient";
    private static final Metadata.Key<String> KEY_REQUEST_ID = Metadata.Key.of("request-id", Metadata.ASCII_STRING_MARSHALLER);
    private static final String REQ_ID_PREFIX_REGISTERINSTANCE = "1";
    private static final String REQ_ID_PREFIX_DEREGISTERINSTANCE = "2";
    private static final String REQ_ID_PREFIX_HEARTBEAT = "3";
    private static final String REQ_ID_PREFIX_GETINSTANCES = "4";
    private static final AtomicLong SEED_INSTANCE_REQ_ID = new AtomicLong();
    private static final AtomicLong SEED_REGISTER_REQ_ID = new AtomicLong();
    private static final AtomicLong SEED_DEREGISTER_REQ_ID = new AtomicLong();
    private static final AtomicLong SEED_HEARTBEAT_REQ_ID = new AtomicLong();

    public static String nextGetInstanceReqId() {
        return String.format("%s%d", REQ_ID_PREFIX_GETINSTANCES, SEED_INSTANCE_REQ_ID.incrementAndGet());
    }

    public static String nextInstanceRegisterReqId() {
        return String.format("%s%d", REQ_ID_PREFIX_REGISTERINSTANCE, SEED_REGISTER_REQ_ID.incrementAndGet());
    }

    public static String nextInstanceDeRegisterReqId() {
        return String.format("%s%d", REQ_ID_PREFIX_DEREGISTERINSTANCE, SEED_DEREGISTER_REQ_ID.incrementAndGet());
    }

    public static String nextHeartbeatReqId() {
        return String.format("%s%d", REQ_ID_PREFIX_HEARTBEAT, SEED_HEARTBEAT_REQ_ID.incrementAndGet());
    }

    public static <T extends AbstractStub<T>> void attachRequestHeader(T stub, String nextID) {
        Metadata extraHeaders = new Metadata();
        extraHeaders.put(KEY_REQUEST_ID, nextID);
        MetadataUtils.attachHeaders(stub, extraHeaders);
    }

    public static <T extends AbstractStub<T>> void attachRequestHeader(T stub, Map<String, String> customHeader) {
        if (MapUtils.isEmpty(customHeader)) {
            return;
        }
        Metadata customMetadata = new Metadata();
        for (Map.Entry<String, String> header : customHeader.entrySet()) {
            customMetadata.put(Metadata.Key.of(header.getKey(), Metadata.ASCII_STRING_MARSHALLER), header.getValue());
        }
        MetadataUtils.attachHeaders(stub, customMetadata);
    }

    public static void checkResponse(ResponseProto.Response response) throws PolarisException {
        if (!response.hasCode()) {
            return;
        }
        int respCode = response.getCode().getValue();
        if (respCode == 200000 || respCode == 400201) {
            return;
        }
        String info = response.getInfo().getValue();
        PolarisException exception = new PolarisException(ErrorCode.SERVER_USER_ERROR, String.format("server error %d: %s", respCode, info));
        exception.setServerErrCode(respCode);
        throw exception;
    }

    public static RequestProto.DiscoverRequest.DiscoverRequestType buildDiscoverRequestType(ServiceEventKey.EventType type) {
        switch (type) {
            case INSTANCE: {
                return RequestProto.DiscoverRequest.DiscoverRequestType.INSTANCE;
            }
            case ROUTING: {
                return RequestProto.DiscoverRequest.DiscoverRequestType.ROUTING;
            }
            case RATE_LIMITING: {
                return RequestProto.DiscoverRequest.DiscoverRequestType.RATE_LIMIT;
            }
            case CIRCUIT_BREAKING: {
                return RequestProto.DiscoverRequest.DiscoverRequestType.CIRCUIT_BREAKER;
            }
            case SERVICE: {
                return RequestProto.DiscoverRequest.DiscoverRequestType.SERVICES;
            }
        }
        return RequestProto.DiscoverRequest.DiscoverRequestType.UNKNOWN;
    }

    public static ServiceEventKey.EventType buildEventType(ResponseProto.DiscoverResponse.DiscoverResponseType responseType) {
        switch (responseType) {
            case INSTANCE: {
                return ServiceEventKey.EventType.INSTANCE;
            }
            case ROUTING: {
                return ServiceEventKey.EventType.ROUTING;
            }
            case RATE_LIMIT: {
                return ServiceEventKey.EventType.RATE_LIMITING;
            }
            case CIRCUIT_BREAKER: {
                return ServiceEventKey.EventType.CIRCUIT_BREAKING;
            }
            case SERVICES: {
                return ServiceEventKey.EventType.SERVICE;
            }
        }
        return ServiceEventKey.EventType.UNKNOWN;
    }
}

