/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.polaris.factory.config.plugin;

import com.tencent.polaris.api.config.plugin.PluginConfig;
import com.tencent.polaris.api.config.plugin.PluginConfigProvider;
import com.tencent.polaris.api.config.verify.Verifier;
import com.tencent.polaris.api.exception.ErrorCode;
import com.tencent.polaris.api.exception.PolarisException;
import com.tencent.polaris.api.utils.MapUtils;
import com.tencent.polaris.factory.util.ConfigUtils;
import java.util.HashMap;
import java.util.Map;
import java.util.ServiceLoader;
import shade.polaris.com.fasterxml.jackson.annotation.JsonProperty;
import shade.polaris.com.fasterxml.jackson.databind.DeserializationFeature;
import shade.polaris.com.fasterxml.jackson.databind.ObjectMapper;
import shade.polaris.com.fasterxml.jackson.databind.SerializationFeature;

public class PluginConfigImpl
implements PluginConfig {
    @JsonProperty
    private final Map<String, Map<?, ?>> plugin = new HashMap();
    private final Object lock = new Object();
    private static final Map<String, Class<? extends Verifier>> pluginConfigClazz = new HashMap<String, Class<? extends Verifier>>();
    private final ObjectMapper mapper = new ObjectMapper();

    public PluginConfigImpl() {
        this.mapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        this.mapper.configure(SerializationFeature.FAIL_ON_EMPTY_BEANS, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T extends Verifier> T getPluginConfig(String pluginName, Class<T> clazz) throws PolarisException {
        Object object = this.lock;
        synchronized (object) {
            Verifier result;
            Map<?, ?> properties = this.plugin.get(pluginName);
            if (null == properties) {
                Verifier config = PluginConfigImpl.getConfigByName(clazz);
                properties = this.mutableSetPluginConfig(pluginName, config);
            }
            try {
                result = (Verifier)this.mapper.convertValue(properties, clazz);
            }
            catch (IllegalArgumentException e) {
                throw new PolarisException(ErrorCode.INVALID_CONFIG, String.format("fail to deserialize properties %s to clazz %s for plugin %s", properties, clazz.getCanonicalName(), pluginName), e);
            }
            return (T)result;
        }
    }

    public void setDefaultPluginConfig(PluginConfig pluginConfig) {
        if (null == pluginConfig) {
            return;
        }
        Map<String, Verifier> pluginConfigs = pluginConfig.getPluginConfigs();
        if (MapUtils.isEmpty(pluginConfigs)) {
            return;
        }
        for (Map.Entry<String, Verifier> entry : pluginConfigs.entrySet()) {
            String pluginName = entry.getKey();
            Verifier defaultObject = entry.getValue();
            Class<?> pluginConfigClazz = defaultObject.getClass();
            Object existConfig = this.getPluginConfig(pluginName, pluginConfigClazz);
            existConfig.setDefault(defaultObject);
            this.setPluginConfig(pluginName, (Verifier)existConfig);
        }
    }

    public void verifyPluginConfig() {
        Map<String, Verifier> pluginConfigs = this.getPluginConfigs();
        if (MapUtils.isEmpty(pluginConfigs)) {
            return;
        }
        for (Verifier verifier : pluginConfigs.values()) {
            verifier.verify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<String, Verifier> getPluginConfigs() throws PolarisException {
        Object object = this.lock;
        synchronized (object) {
            HashMap<String, Verifier> values = new HashMap<String, Verifier>();
            if (this.plugin.size() == 0) {
                return values;
            }
            for (Map.Entry<String, Map<?, ?>> entry : this.plugin.entrySet()) {
                String pluginName;
                Class<? extends Verifier> clazz;
                Map<?, ?> properties = entry.getValue();
                if (MapUtils.isEmpty(properties) || null == (clazz = pluginConfigClazz.get(pluginName = entry.getKey()))) continue;
                try {
                    Verifier result = this.mapper.convertValue(properties, clazz);
                    values.put(pluginName, result);
                }
                catch (IllegalArgumentException e) {
                    throw new PolarisException(ErrorCode.INVALID_CONFIG, String.format("fail to deserialize properties %s to clazz %s for plugin %s", properties, clazz.getCanonicalName(), pluginName), e);
                }
            }
            return values;
        }
    }

    private Map<?, ?> mutableSetPluginConfig(String pluginName, Verifier config) throws PolarisException {
        Map<?, ?> configMap;
        try {
            configMap = ConfigUtils.objectToMap(config);
        }
        catch (Exception e) {
            throw new PolarisException(ErrorCode.INVALID_CONFIG, String.format("fail to marshal plugin config for %s", pluginName), e);
        }
        this.plugin.put(pluginName, configMap);
        return configMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setPluginConfig(String pluginName, Verifier config) throws PolarisException {
        Object object = this.lock;
        synchronized (object) {
            if (null == config) {
                throw new PolarisException(ErrorCode.INVALID_CONFIG, String.format("config is null, plugin name %s", pluginName));
            }
            this.mutableSetPluginConfig(pluginName, config);
        }
    }

    private static Verifier getConfigByName(Class<? extends Verifier> pluginConfigClazz) {
        try {
            return pluginConfigClazz.newInstance();
        }
        catch (Exception e) {
            throw new RuntimeException(pluginConfigClazz.getCanonicalName() + " create config failed.", e);
        }
    }

    static {
        ServiceLoader<PluginConfigProvider> providers = ServiceLoader.load(PluginConfigProvider.class);
        for (PluginConfigProvider provider : providers) {
            pluginConfigClazz.put(provider.getName(), provider.getPluginConfigClazz());
        }
    }
}

