/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.polaris.factory;

import com.tencent.polaris.api.config.Configuration;
import com.tencent.polaris.api.exception.ErrorCode;
import com.tencent.polaris.api.exception.PolarisException;
import com.tencent.polaris.factory.config.ConfigurationImpl;
import com.tencent.polaris.factory.config.global.GlobalConfigImpl;
import com.tencent.polaris.factory.config.global.ServerConnectorConfigImpl;
import com.tencent.polaris.factory.replace.SystemPropertyPlaceholderResolver;
import com.tencent.polaris.factory.util.PropertyPlaceholderHelper;
import com.tencent.polaris.logging.LoggerFactory;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import shade.polaris.com.fasterxml.jackson.core.JsonParser;
import shade.polaris.com.fasterxml.jackson.databind.DeserializationFeature;
import shade.polaris.com.fasterxml.jackson.databind.JsonNode;
import shade.polaris.com.fasterxml.jackson.databind.ObjectMapper;
import shade.polaris.com.fasterxml.jackson.databind.node.TreeTraversingParser;
import shade.polaris.com.fasterxml.jackson.dataformat.yaml.YAMLFactory;
import shade.polaris.com.fasterxml.jackson.dataformat.yaml.YAMLParser;

public class ConfigAPIFactory {
    private static final Logger LOG = LoggerFactory.getLogger(ConfigAPIFactory.class);
    public static final String DEFAULT_PLACEHOLDER_PREFIX = "${";
    public static final String DEFAULT_PLACEHOLDER_SUFFIX = "}";
    public static final String DEFAULT_VALUE_SEPARATOR = ":";
    public static final String DEFAULT_CONFIG_PATH = "polaris.yml";

    public static Configuration loadConfig(InputStream configStream) throws PolarisException {
        String configText;
        try {
            configText = ConfigAPIFactory.replaceConfigText(configStream);
        }
        catch (Throwable e) {
            throw new PolarisException(ErrorCode.INVALID_CONFIG, "fail to preprocess config", e);
        }
        YAMLFactory yamlFactory = new YAMLFactory();
        ObjectMapper mapper = new ObjectMapper();
        try {
            YAMLParser yamlParser = yamlFactory.createParser(configText);
            JsonNode node = (JsonNode)mapper.readTree(yamlParser);
            TreeTraversingParser treeTraversingParser = new TreeTraversingParser(node);
            mapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
            return mapper.readValue((JsonParser)treeTraversingParser, ConfigurationImpl.class);
        }
        catch (Exception e) {
            throw new PolarisException(ErrorCode.INVALID_CONFIG, "fail to load config from stream", e);
        }
    }

    private static String replaceConfigText(InputStream configStream) {
        String result = new BufferedReader(new InputStreamReader(configStream)).lines().collect(Collectors.joining("\n"));
        PropertyPlaceholderHelper propertyPlaceholderHelper = new PropertyPlaceholderHelper(DEFAULT_PLACEHOLDER_PREFIX, DEFAULT_PLACEHOLDER_SUFFIX, DEFAULT_VALUE_SEPARATOR, false);
        return propertyPlaceholderHelper.replacePlaceholders(result, new SystemPropertyPlaceholderResolver());
    }

    public static Configuration defaultConfig() throws PolarisException {
        return ConfigAPIFactory.defaultConfig("");
    }

    public static Configuration defaultConfig(String defaultConfigName) throws PolarisException {
        ConfigurationImpl configuration;
        InputStream inputStream = Thread.currentThread().getContextClassLoader().getResourceAsStream(DEFAULT_CONFIG_PATH);
        if (null != inputStream) {
            LOG.info("[Configuration]success to load config stream from {}", (Object)DEFAULT_CONFIG_PATH);
            configuration = (ConfigurationImpl)ConfigAPIFactory.loadConfig(inputStream);
        } else {
            configuration = new ConfigurationImpl(defaultConfigName);
        }
        configuration.setDefault();
        return configuration;
    }

    public static Configuration createConfigurationByAddress(List<String> addressList) {
        ConfigurationImpl configuration = (ConfigurationImpl)ConfigAPIFactory.defaultConfig();
        GlobalConfigImpl globalConfig = configuration.getGlobal();
        ServerConnectorConfigImpl serverConnector = globalConfig.getServerConnector();
        serverConnector.setAddresses(addressList);
        return configuration;
    }

    public static Configuration createConfigurationByAddress(String ... addresses) {
        return ConfigAPIFactory.createConfigurationByAddress(Arrays.asList(addresses));
    }
}

