/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.polaris.discovery.client.api;

import com.tencent.polaris.api.core.ProviderAPI;
import com.tencent.polaris.api.exception.ErrorCode;
import com.tencent.polaris.api.exception.PolarisException;
import com.tencent.polaris.api.exception.RetriableException;
import com.tencent.polaris.api.plugin.route.LocationLevel;
import com.tencent.polaris.api.plugin.server.CommonProviderRequest;
import com.tencent.polaris.api.plugin.server.CommonProviderResponse;
import com.tencent.polaris.api.plugin.server.ServerConnector;
import com.tencent.polaris.api.pojo.RetStatus;
import com.tencent.polaris.api.rpc.InstanceDeregisterRequest;
import com.tencent.polaris.api.rpc.InstanceHeartbeatRequest;
import com.tencent.polaris.api.rpc.InstanceRegisterRequest;
import com.tencent.polaris.api.rpc.InstanceRegisterResponse;
import com.tencent.polaris.api.rpc.ServiceCallResult;
import com.tencent.polaris.api.utils.StringUtils;
import com.tencent.polaris.client.api.BaseEngine;
import com.tencent.polaris.client.api.SDKContext;
import com.tencent.polaris.client.util.Utils;
import com.tencent.polaris.discovery.client.flow.RegisterFlow;
import com.tencent.polaris.discovery.client.flow.RegisterStateManager;
import com.tencent.polaris.discovery.client.util.Validator;
import com.tencent.polaris.logging.LoggerFactory;
import java.util.Map;
import org.slf4j.Logger;

public class DefaultProviderAPI
extends BaseEngine
implements ProviderAPI {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultProviderAPI.class);
    private static final int DEFAULT_INSTANCE_TTL = 5;
    private final RegisterFlow registerFlow;
    private ServerConnector serverConnector;

    public DefaultProviderAPI(SDKContext sdkContext) {
        super(sdkContext);
        this.registerFlow = new RegisterFlow(sdkContext);
    }

    @Override
    protected void subInit() {
        this.serverConnector = this.sdkContext.getExtensions().getServerConnector();
    }

    private ErrorCode exceptionToErrorCode(Exception exception) {
        if (exception instanceof PolarisException) {
            return ((PolarisException)exception).getCode();
        }
        return ErrorCode.INTERNAL_ERROR;
    }

    @Override
    public InstanceRegisterResponse registerInstance(InstanceRegisterRequest req) throws PolarisException {
        if (req.getTtl() == null) {
            req.setTtl(5);
        }
        return this.registerFlow.registerInstance(req, this::doRegister, this::heartbeat);
    }

    @Override
    protected void doDestroy() {
        RegisterStateManager.destroy(this.sdkContext);
        super.doDestroy();
    }

    @Override
    public InstanceRegisterResponse register(InstanceRegisterRequest req) throws PolarisException {
        return this.doRegister(req, null);
    }

    private InstanceRegisterResponse doRegister(InstanceRegisterRequest req, Map<String, String> customHeader) {
        this.checkAvailable("ProviderAPI");
        Validator.validateInstanceRegisterRequest(req);
        this.enrichInstanceLocation(req);
        long retryInterval = this.sdkContext.getConfig().getGlobal().getAPI().getRetryInterval();
        long timeout = this.getTimeout(req);
        while (timeout > 0L) {
            long start = System.currentTimeMillis();
            ServiceCallResult serviceCallResult = new ServiceCallResult();
            CommonProviderRequest request = req.getRequest();
            try {
                CommonProviderResponse response = this.serverConnector.registerInstance(request, customHeader);
                LOG.info("register {}/{} instance {} succ", new Object[]{req.getNamespace(), req.getService(), response.getInstanceID()});
                serviceCallResult.setRetStatus(RetStatus.RetSuccess);
                serviceCallResult.setRetCode(ErrorCode.Success.getCode());
                InstanceRegisterResponse instanceRegisterResponse = new InstanceRegisterResponse(response.getInstanceID(), response.isExists());
                return instanceRegisterResponse;
            }
            catch (PolarisException e) {
                serviceCallResult.setRetStatus(RetStatus.RetFail);
                serviceCallResult.setRetCode(this.exceptionToErrorCode(e).getCode());
                if (e instanceof RetriableException) {
                    LOG.warn("instance register request error, retrying.", (Throwable)e);
                    Utils.sleepUninterrupted(retryInterval);
                    continue;
                }
                throw e;
            }
            finally {
                long delay = System.currentTimeMillis() - start;
                serviceCallResult.setDelay(delay);
                this.reportServerCall(serviceCallResult, request.getTargetServer(), "register");
                timeout -= delay;
            }
        }
        throw new PolarisException(ErrorCode.API_TIMEOUT, "instance register request timeout.");
    }

    @Override
    public void deRegister(InstanceDeregisterRequest req) throws PolarisException {
        this.checkAvailable("ProviderAPI");
        Validator.validateInstanceDeregisterRequest(req);
        RegisterStateManager.removeRegisterState(this.sdkContext, req);
        long retryInterval = this.sdkContext.getConfig().getGlobal().getAPI().getRetryInterval();
        long timeout = this.getTimeout(req);
        while (timeout > 0L) {
            long start = System.currentTimeMillis();
            ServiceCallResult serviceCallResult = new ServiceCallResult();
            CommonProviderRequest request = req.getRequest();
            try {
                this.serverConnector.deregisterInstance(request);
                serviceCallResult.setRetStatus(RetStatus.RetSuccess);
                serviceCallResult.setRetCode(ErrorCode.Success.getCode());
                LOG.info("deregister instance {} succ", (Object)req);
                return;
            }
            catch (PolarisException e) {
                serviceCallResult.setRetStatus(RetStatus.RetFail);
                serviceCallResult.setRetCode(this.exceptionToErrorCode(e).getCode());
                if (e instanceof RetriableException) {
                    LOG.warn("instance deregister request error, retrying.", (Throwable)e);
                    Utils.sleepUninterrupted(retryInterval);
                    continue;
                }
                throw e;
            }
            finally {
                long delay = System.currentTimeMillis() - start;
                serviceCallResult.setDelay(delay);
                this.reportServerCall(serviceCallResult, request.getTargetServer(), "deRegister");
                timeout -= delay;
            }
        }
        throw new PolarisException(ErrorCode.API_TIMEOUT, "instance deregister request timeout.");
    }

    @Override
    public void heartbeat(InstanceHeartbeatRequest req) throws PolarisException {
        this.checkAvailable("ProviderAPI");
        Validator.validateHeartbeatRequest(req);
        long timeout = this.getTimeout(req);
        long retryInterval = this.sdkContext.getConfig().getGlobal().getAPI().getRetryInterval();
        while (timeout > 0L) {
            long start = System.currentTimeMillis();
            ServiceCallResult serviceCallResult = new ServiceCallResult();
            CommonProviderRequest request = req.getRequest();
            try {
                this.serverConnector.heartbeat(request);
                serviceCallResult.setRetStatus(RetStatus.RetSuccess);
                serviceCallResult.setRetCode(ErrorCode.Success.getCode());
                return;
            }
            catch (PolarisException e) {
                serviceCallResult.setRetStatus(RetStatus.RetFail);
                serviceCallResult.setRetCode(this.exceptionToErrorCode(e).getCode());
                if (e instanceof RetriableException) {
                    LOG.warn("heartbeat request error, retrying.", (Throwable)e);
                    Utils.sleepUninterrupted(retryInterval);
                    continue;
                }
                throw e;
            }
            finally {
                long delay = System.currentTimeMillis() - start;
                serviceCallResult.setDelay(delay);
                this.reportServerCall(serviceCallResult, request.getTargetServer(), "heartbeat");
                timeout -= delay;
            }
        }
        throw new PolarisException(ErrorCode.API_TIMEOUT, "heartbeat request timeout.");
    }

    private void enrichInstanceLocation(InstanceRegisterRequest request) {
        if (!StringUtils.isAllEmpty(request.getRegion(), request.getZone(), request.getCampus())) {
            return;
        }
        request.setRegion((String)this.sdkContext.getValueContext().getValue(LocationLevel.region.name()));
        request.setZone((String)this.sdkContext.getValueContext().getValue(LocationLevel.zone.name()));
        request.setCampus((String)this.sdkContext.getValueContext().getValue(LocationLevel.campus.name()));
    }
}

