/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.polaris.circuitbreak.client.task;

import com.tencent.polaris.api.plugin.circuitbreaker.CircuitBreakResult;
import com.tencent.polaris.api.plugin.circuitbreaker.CircuitBreaker;
import com.tencent.polaris.api.plugin.compose.Extensions;
import com.tencent.polaris.api.plugin.registry.InstanceProperty;
import com.tencent.polaris.api.plugin.registry.ResourceFilter;
import com.tencent.polaris.api.plugin.registry.ServiceUpdateRequest;
import com.tencent.polaris.api.pojo.CircuitBreakerStatus;
import com.tencent.polaris.api.pojo.Instance;
import com.tencent.polaris.api.pojo.ServiceEventKey;
import com.tencent.polaris.api.pojo.ServiceKey;
import com.tencent.polaris.api.utils.CollectionUtils;
import com.tencent.polaris.api.utils.MapUtils;
import com.tencent.polaris.api.utils.StringUtils;
import com.tencent.polaris.client.pojo.ServiceInstancesByProto;
import com.tencent.polaris.logging.LoggerFactory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;

public class InstancesCircuitBreakTask
implements Runnable,
Comparable<InstancesCircuitBreakTask> {
    private static final Logger LOG = LoggerFactory.getLogger(InstancesCircuitBreakTask.class);
    private final ServiceKey serviceKey;
    private final String cbName;
    private final Collection<Instance> instances;
    private final String instId;
    private final Extensions extensions;
    private final TaskPriority priority;

    @Override
    public int compareTo(InstancesCircuitBreakTask o) {
        return this.priority.ordinal() - o.priority.ordinal();
    }

    public InstancesCircuitBreakTask(ServiceKey serviceKey, String cbName, Collection<Instance> instances, String instId, Extensions extensions, TaskPriority priority) {
        this.serviceKey = serviceKey;
        this.cbName = cbName;
        this.instId = instId;
        this.instances = instances;
        this.extensions = extensions;
        this.priority = priority;
    }

    private Instance getInstance() {
        ServiceEventKey serviceEventKey = new ServiceEventKey(this.serviceKey, ServiceEventKey.EventType.INSTANCE);
        ResourceFilter resourceFilter = new ResourceFilter(serviceEventKey, true, true);
        ServiceInstancesByProto instances = (ServiceInstancesByProto)this.extensions.getLocalRegistry().getInstances(resourceFilter);
        if (!instances.isInitialized()) {
            return null;
        }
        return instances.getInstance(this.instId);
    }

    @Override
    public void run() {
        Object instance;
        HashMap<String, CircuitBreakResult> allResults = new HashMap<String, CircuitBreakResult>();
        HashSet<CircuitBreakResult.ResultKey> statusChangedInstances = new HashSet<CircuitBreakResult.ResultKey>();
        Collection<Instance> targetInstances = this.instances;
        if (StringUtils.isNotEmpty(this.instId) && null != (instance = this.getInstance())) {
            targetInstances = new ArrayList<Instance>();
            targetInstances.add((Instance)instance);
        }
        if (CollectionUtils.isEmpty(targetInstances)) {
            return;
        }
        for (CircuitBreaker circuitBreaker : this.extensions.getCircuitBreakers()) {
            CircuitBreakResult circuitBreakResult;
            if (StringUtils.isNotBlank(this.cbName) && !this.cbName.equals(circuitBreaker.getName()) || null == (circuitBreakResult = circuitBreaker.checkInstance(targetInstances)) || circuitBreakResult.isEmptyResult()) continue;
            this.cleanInstanceSet(circuitBreakResult.getInstancesToOpen(), statusChangedInstances);
            this.cleanInstanceSet(circuitBreakResult.getInstancesToHalfOpen(), statusChangedInstances);
            this.cleanInstanceSet(circuitBreakResult.getInstancesToClose(), statusChangedInstances);
            allResults.put(circuitBreaker.getName(), circuitBreakResult);
        }
        ServiceUpdateRequest updateRequest = this.buildServiceUpdateRequest(this.serviceKey, allResults);
        if (CollectionUtils.isEmpty(updateRequest.getProperties())) {
            return;
        }
        LOG.info("update cache for circuitbreaker, value is {}", (Object)updateRequest);
        this.extensions.getLocalRegistry().updateInstances(updateRequest);
    }

    private void cleanInstanceSet(Map<CircuitBreakResult.ResultKey, Instance> instanceSet, Set<CircuitBreakResult.ResultKey> allInstances) {
        HashSet<CircuitBreakResult.ResultKey> instIdsToRemove = new HashSet<CircuitBreakResult.ResultKey>();
        for (Map.Entry<CircuitBreakResult.ResultKey, Instance> entry : instanceSet.entrySet()) {
            CircuitBreakResult.ResultKey resultKey = entry.getKey();
            if (allInstances.contains(resultKey)) {
                instIdsToRemove.add(resultKey);
                continue;
            }
            allInstances.add(resultKey);
        }
        instIdsToRemove.forEach(instanceSet::remove);
    }

    private void buildInstanceProperty(long now, Map<CircuitBreakResult.ResultKey, Instance> results, int maxRequestAfterHalfOpen, Map<String, InstanceProperty> instanceProperties, String cbName, CircuitBreakerStatus.Status status) {
        if (MapUtils.isEmpty(results)) {
            return;
        }
        for (Map.Entry<CircuitBreakResult.ResultKey, Instance> entry : results.entrySet()) {
            CircuitBreakResult.ResultKey resultKey = entry.getKey();
            Instance instance = entry.getValue();
            String instId = resultKey.getInstId();
            InstanceProperty instanceProperty = instanceProperties.get(instId);
            if (null == instanceProperty) {
                HashMap<String, Object> properties = new HashMap<String, Object>();
                properties.put("circuitBreakerStatus", new HashMap());
                instanceProperty = new InstanceProperty(instance, properties);
                instanceProperties.put(instId, instanceProperty);
            }
            Map statusMap = (Map)instanceProperty.getProperties().get("circuitBreakerStatus");
            statusMap.put(resultKey.getStatusDimension(), new CircuitBreakerStatus(cbName, status, now));
        }
    }

    private ServiceUpdateRequest buildServiceUpdateRequest(ServiceKey serviceKey, Map<String, CircuitBreakResult> allResults) {
        HashMap properties = new HashMap();
        allResults.forEach((cbName, result) -> {
            this.buildInstanceProperty(result.getCreateTimeMs(), result.getInstancesToOpen(), result.getMaxRequestCountAfterHalfOpen(), properties, (String)cbName, CircuitBreakerStatus.Status.OPEN);
            this.buildInstanceProperty(result.getCreateTimeMs(), result.getInstancesToHalfOpen(), result.getMaxRequestCountAfterHalfOpen(), properties, (String)cbName, CircuitBreakerStatus.Status.HALF_OPEN);
            this.buildInstanceProperty(result.getCreateTimeMs(), result.getInstancesToClose(), result.getMaxRequestCountAfterHalfOpen(), properties, (String)cbName, CircuitBreakerStatus.Status.CLOSE);
        });
        return new ServiceUpdateRequest(serviceKey, properties.values());
    }

    public static enum TaskPriority {
        HIGH,
        LOW;

    }
}

