/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.polaris.circuitbreak.client.api;

import com.tencent.polaris.api.config.consumer.CircuitBreakerConfig;
import com.tencent.polaris.api.config.consumer.OutlierDetectionConfig;
import com.tencent.polaris.api.plugin.circuitbreaker.CircuitBreaker;
import com.tencent.polaris.api.plugin.compose.Extensions;
import com.tencent.polaris.api.plugin.registry.ResourceFilter;
import com.tencent.polaris.api.pojo.InstanceGauge;
import com.tencent.polaris.api.pojo.ServiceEventKey;
import com.tencent.polaris.api.pojo.ServiceInstances;
import com.tencent.polaris.api.pojo.ServiceKey;
import com.tencent.polaris.api.utils.CollectionUtils;
import com.tencent.polaris.api.utils.StringUtils;
import com.tencent.polaris.circuitbreak.client.task.InstancesCircuitBreakTask;
import com.tencent.polaris.circuitbreak.client.task.InstancesDetectTask;
import com.tencent.polaris.circuitbreak.client.task.PriorityTaskScheduler;
import com.tencent.polaris.client.api.SDKContext;
import com.tencent.polaris.client.api.ServiceCallResultListener;
import java.util.Set;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;

public class ServiceCallResultChecker
implements ServiceCallResultListener {
    private PriorityTaskScheduler priorityTaskScheduler;
    private ScheduledExecutorService cbTaskExecutors;
    private ScheduledExecutorService detectTaskExecutors;
    private Extensions extensions;
    private InstancesDetectTask detectTask;
    private final AtomicInteger state = new AtomicInteger(0);

    @Override
    public synchronized void init(SDKContext sdkContext) {
        OutlierDetectionConfig outlierDetection;
        long checkPeriodMs;
        if (!this.state.compareAndSet(0, 1)) {
            return;
        }
        this.extensions = sdkContext.getExtensions();
        CircuitBreakerConfig cbConfig = sdkContext.getConfig().getConsumer().getCircuitBreaker();
        if (cbConfig.isEnable()) {
            this.priorityTaskScheduler = new PriorityTaskScheduler();
            this.cbTaskExecutors = Executors.newSingleThreadScheduledExecutor();
            CheckServicesCircuitBreak checker = new CheckServicesCircuitBreak(sdkContext.getExtensions(), this.priorityTaskScheduler);
            checkPeriodMs = cbConfig.getCheckPeriod();
            this.cbTaskExecutors.scheduleAtFixedRate(checker, checkPeriodMs, checkPeriodMs / 2L, TimeUnit.MILLISECONDS);
        }
        if ((outlierDetection = sdkContext.getConfig().getConsumer().getOutlierDetection()).getWhen() != OutlierDetectionConfig.When.never) {
            this.detectTaskExecutors = Executors.newSingleThreadScheduledExecutor();
            checkPeriodMs = outlierDetection.getCheckPeriod();
            this.detectTask = new InstancesDetectTask(this.extensions, outlierDetection.getWhen());
            this.detectTaskExecutors.scheduleAtFixedRate(this.detectTask, checkPeriodMs, checkPeriodMs, TimeUnit.MILLISECONDS);
        }
    }

    @Override
    public void onServiceCallResult(InstanceGauge result) {
        if (null == this.priorityTaskScheduler) {
            return;
        }
        if (CollectionUtils.isEmpty(this.extensions.getCircuitBreakers())) {
            return;
        }
        InstancesCircuitBreakTask rtTask = null;
        for (CircuitBreaker circuitBreaker : this.extensions.getCircuitBreakers()) {
            String cbName = circuitBreaker.getName();
            boolean rtLimit = circuitBreaker.stat(result);
            String instId = result.getInstanceId();
            if (!rtLimit || !StringUtils.isNotEmpty(instId)) continue;
            ServiceKey svcKey = new ServiceKey(result.getNamespace(), result.getService());
            rtTask = new InstancesCircuitBreakTask(svcKey, cbName, null, instId, this.extensions, InstancesCircuitBreakTask.TaskPriority.HIGH);
            break;
        }
        if (null == rtTask) {
            return;
        }
        this.priorityTaskScheduler.addCircuitBreakTask(rtTask);
    }

    @Override
    public synchronized void destroy() {
        if (!this.state.compareAndSet(1, 0)) {
            return;
        }
        if (null != this.priorityTaskScheduler) {
            this.priorityTaskScheduler.destroy();
        }
        if (null != this.cbTaskExecutors) {
            this.cbTaskExecutors.shutdown();
        }
        if (null != this.detectTask) {
            this.detectTask.destroy();
        }
        if (null != this.detectTaskExecutors) {
            this.detectTaskExecutors.shutdown();
        }
    }

    private static class CheckServicesCircuitBreak
    implements Runnable {
        private final Extensions extensions;
        private final PriorityTaskScheduler priorityTaskScheduler;

        public CheckServicesCircuitBreak(Extensions extensions, PriorityTaskScheduler priorityTaskScheduler) {
            this.extensions = extensions;
            this.priorityTaskScheduler = priorityTaskScheduler;
        }

        @Override
        public void run() {
            Set<ServiceKey> services = this.extensions.getLocalRegistry().getServices();
            for (ServiceKey service : services) {
                ServiceEventKey svcEventKey = new ServiceEventKey(service, ServiceEventKey.EventType.INSTANCE);
                ServiceInstances svcInstances = this.extensions.getLocalRegistry().getInstances(new ResourceFilter(svcEventKey, true, true));
                if (!svcInstances.isInitialized() || svcInstances.getInstances().isEmpty()) continue;
                this.priorityTaskScheduler.addCircuitBreakTask(new InstancesCircuitBreakTask(service, "", svcInstances.getInstances(), "", this.extensions, InstancesCircuitBreakTask.TaskPriority.LOW));
            }
        }
    }
}

