/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.polaris.api.rpc;

import com.tencent.polaris.api.pojo.RouteArgument;
import com.tencent.polaris.api.pojo.ServiceInfo;
import com.tencent.polaris.api.pojo.SourceService;
import com.tencent.polaris.api.rpc.MetadataFailoverType;
import com.tencent.polaris.api.rpc.RequestBaseEntity;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;

public class GetInstancesRequest
extends RequestBaseEntity {
    private Map<String, String> metadata;
    private SourceService sourceService;
    private boolean includeCircuitBreak;
    private boolean includeUnhealthy;
    private String canary;
    private String method;
    private MetadataFailoverType metadataFailoverType;

    public boolean isIncludeCircuitBreak() {
        return this.includeCircuitBreak;
    }

    public void setIncludeCircuitBreak(boolean includeCircuitBreak) {
        this.includeCircuitBreak = includeCircuitBreak;
    }

    public Map<String, String> getMetadata() {
        return this.metadata;
    }

    public void setMetadata(Map<String, String> metadata) {
        this.metadata = metadata;
    }

    public boolean isIncludeUnhealthy() {
        return this.includeUnhealthy;
    }

    public void setIncludeUnhealthy(boolean includeUnhealthy) {
        this.includeUnhealthy = includeUnhealthy;
    }

    public SourceService getServiceInfo() {
        return this.sourceService;
    }

    public void setServiceInfo(ServiceInfo serviceInfo) {
        if (serviceInfo instanceof SourceService) {
            this.sourceService = (SourceService)serviceInfo;
        } else {
            SourceService sourceService = new SourceService();
            sourceService.setNamespace(serviceInfo.getNamespace());
            sourceService.setService(serviceInfo.getService());
            HashSet<RouteArgument> argumentSet = new HashSet<RouteArgument>();
            Optional.ofNullable(serviceInfo.getMetadata()).orElse(Collections.emptyMap()).forEach((key, value) -> argumentSet.add(RouteArgument.fromLabel(key, value)));
            sourceService.setArguments(argumentSet);
            this.sourceService = sourceService;
        }
    }

    public String getCanary() {
        return this.canary;
    }

    public void setCanary(String canary) {
        this.canary = canary;
    }

    public String getMethod() {
        return this.method;
    }

    public void setMethod(String method) {
        this.method = method;
    }

    public MetadataFailoverType getMetadataFailoverType() {
        return this.metadataFailoverType;
    }

    public void setMetadataFailoverType(MetadataFailoverType metadataFailoverType) {
        this.metadataFailoverType = metadataFailoverType;
    }

    @Override
    public String toString() {
        return "GetInstancesRequest{metadata=" + this.metadata + ", sourceService=" + this.sourceService + ", includeCircuitBreak=" + this.includeCircuitBreak + ", includeUnhealthy=" + this.includeUnhealthy + ", canary='" + this.canary + '\'' + ", method='" + this.method + '\'' + ", metadataFailoverType=" + (Object)((Object)this.metadataFailoverType) + "} " + super.toString();
    }
}

