/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.polaris.api.pojo;

import com.tencent.polaris.api.pojo.Instance;
import com.tencent.polaris.api.pojo.ServiceInstances;
import com.tencent.polaris.api.pojo.ServiceKey;
import com.tencent.polaris.api.utils.CollectionUtils;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class DefaultServiceInstances
implements ServiceInstances {
    private final ServiceKey serviceKey;
    private final List<Instance> instances;
    private final int totalWeight;
    private final int hashCode;
    private final String revision;

    public DefaultServiceInstances(ServiceKey serviceKey, List<Instance> instances) {
        this.serviceKey = serviceKey;
        this.instances = Collections.unmodifiableList(instances);
        this.totalWeight = this.getTotalWeight(instances);
        this.hashCode = Objects.hash(serviceKey, instances);
        this.revision = Integer.toHexString(this.hashCode);
    }

    private int getTotalWeight(List<Instance> instances) {
        int totalWeight = 0;
        if (CollectionUtils.isNotEmpty(instances)) {
            for (Instance instance : instances) {
                totalWeight += instance.getWeight();
            }
        }
        return totalWeight;
    }

    @Override
    public ServiceKey getServiceKey() {
        return this.serviceKey;
    }

    @Override
    public int getTotalWeight() {
        return this.totalWeight;
    }

    @Override
    public List<Instance> getInstances() {
        return this.instances;
    }

    @Override
    public boolean isInitialized() {
        return true;
    }

    @Override
    public String getRevision() {
        return this.revision;
    }

    @Override
    public Map<String, String> getMetadata() {
        return null;
    }

    @Override
    public String getService() {
        return this.serviceKey.getService();
    }

    @Override
    public String getNamespace() {
        return this.serviceKey.getNamespace();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DefaultServiceInstances that = (DefaultServiceInstances)o;
        return Objects.equals(this.serviceKey, that.serviceKey) && Objects.equals(this.instances, that.instances);
    }

    public int hashCode() {
        return this.hashCode;
    }
}

