/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.polaris.api.plugin.route;

import com.tencent.polaris.api.plugin.route.RouteResult;
import com.tencent.polaris.api.pojo.RouteArgument;
import com.tencent.polaris.api.pojo.ServiceMetadata;
import com.tencent.polaris.api.pojo.ServiceRule;
import com.tencent.polaris.api.pojo.SourceService;
import com.tencent.polaris.api.pojo.StatusDimension;
import com.tencent.polaris.api.rpc.MetadataFailoverType;
import com.tencent.polaris.api.rpc.RuleBasedRouterFailoverType;
import com.tencent.polaris.api.utils.StringUtils;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

public class RouteInfo {
    private final SourceService sourceService;
    private final ServiceMetadata destService;
    private ServiceRule sourceRouteRule;
    private ServiceRule destRouteRule;
    private String canary;
    private final Map<StatusDimension.Level, StatusDimension> statusDimensions;
    private final Map<String, Boolean> chainEnable = new HashMap<String, Boolean>();
    private boolean includeUnhealthyInstances;
    private boolean includeCircuitBreakInstances;
    private MetadataFailoverType metadataFailoverType;
    private RuleBasedRouterFailoverType ruleBasedRouterFailoverType;
    private Map<String, Map<String, String>> routerMetadata = new HashMap<String, Map<String, String>>();
    private RouteResult.NextRouterInfo nextRouterInfo;

    public RouteInfo(SourceService sourceService, ServiceRule sourceRouteRule, ServiceMetadata destService, ServiceRule destRouteRule, String method) {
        this.sourceService = sourceService;
        if (Objects.nonNull(sourceService)) {
            this.routerMetadata.computeIfAbsent("ruleRouter", k -> new HashMap());
            this.routerMetadata.get("ruleRouter").putAll(sourceService.getLabels());
        }
        this.sourceRouteRule = sourceRouteRule;
        this.destService = destService;
        this.destRouteRule = destRouteRule;
        HashMap<StatusDimension.Level, StatusDimension> dimensionMap = new HashMap<StatusDimension.Level, StatusDimension>();
        dimensionMap.put(StatusDimension.Level.SERVICE, StatusDimension.EMPTY_DIMENSION);
        if (StringUtils.isNotBlank(method)) {
            dimensionMap.put(StatusDimension.Level.ALL_CALLER, new StatusDimension(method, null));
        }
        if (Objects.nonNull(sourceService)) {
            dimensionMap.put(StatusDimension.Level.ALL_METHOD, new StatusDimension("", sourceService));
        }
        if (StringUtils.isNotBlank(method) && null != sourceService) {
            dimensionMap.put(StatusDimension.Level.CALLER_METHOD, new StatusDimension(method, sourceService));
        }
        this.statusDimensions = Collections.unmodifiableMap(dimensionMap);
    }

    public RouteInfo(SourceService sourceService, ServiceMetadata destService, String method) {
        this(sourceService, null, destService, null, method);
    }

    public MetadataFailoverType getMetadataFailoverType() {
        return this.metadataFailoverType;
    }

    public void setMetadataFailoverType(MetadataFailoverType metadataFailoverType) {
        this.metadataFailoverType = metadataFailoverType;
    }

    public RuleBasedRouterFailoverType getRuleBasedRouterFailoverType() {
        return this.ruleBasedRouterFailoverType;
    }

    public void setRuleBasedRouterFailoverType(RuleBasedRouterFailoverType ruleBasedRouterFailoverType) {
        this.ruleBasedRouterFailoverType = ruleBasedRouterFailoverType;
    }

    public Map<StatusDimension.Level, StatusDimension> getStatusDimensions() {
        return this.statusDimensions;
    }

    public void setSourceRouteRule(ServiceRule sourceRouteRule) {
        this.sourceRouteRule = sourceRouteRule;
    }

    public void setDestRouteRule(ServiceRule destRouteRule) {
        this.destRouteRule = destRouteRule;
    }

    public RouteResult.NextRouterInfo getNextRouterInfo() {
        return this.nextRouterInfo;
    }

    public void setNextRouterInfo(RouteResult.NextRouterInfo nextRouterInfo) {
        this.nextRouterInfo = nextRouterInfo;
    }

    public String getCanary() {
        return this.canary;
    }

    public void setCanary(String canary) {
        this.canary = canary;
    }

    public Boolean routerIsEnabled(String routerType) {
        return this.chainEnable.get(routerType);
    }

    public void enableRouter(String routerType) {
        this.chainEnable.put(routerType, true);
    }

    public void disableRouter(String routerType) {
        this.chainEnable.put(routerType, false);
    }

    public SourceService getSourceService() {
        return this.sourceService;
    }

    public ServiceRule getSourceRouteRule() {
        return this.sourceRouteRule;
    }

    public ServiceMetadata getDestService() {
        return this.destService;
    }

    public ServiceRule getDestRouteRule() {
        return this.destRouteRule;
    }

    public boolean isIncludeUnhealthyInstances() {
        return this.includeUnhealthyInstances;
    }

    public void setIncludeUnhealthyInstances(boolean includeUnhealthyInstances) {
        this.includeUnhealthyInstances = includeUnhealthyInstances;
    }

    public boolean isIncludeCircuitBreakInstances() {
        return this.includeCircuitBreakInstances;
    }

    public void setIncludeCircuitBreakInstances(boolean includeCircuitBreakInstances) {
        this.includeCircuitBreakInstances = includeCircuitBreakInstances;
    }

    public Map<String, String> getRouterMetadata(String routerType) {
        if (this.routerMetadata == null) {
            return Collections.emptyMap();
        }
        Map<String, String> metadata = this.routerMetadata.get(routerType);
        if (metadata == null || metadata.size() == 0) {
            return Collections.emptyMap();
        }
        return Collections.unmodifiableMap(metadata);
    }

    public void setRouterArguments(Map<String, Set<RouteArgument>> routerArguments) {
        Map<String, Map<String, String>> routerMetadata = this.routerMetadata;
        routerArguments.forEach((s2, arguments) -> {
            routerMetadata.computeIfAbsent((String)s2, key -> new HashMap());
            Map labels = (Map)routerMetadata.get(s2);
            arguments.forEach(routeArgument -> routeArgument.toLabel(labels));
        });
    }
}

