/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.matrix.util;

import com.tencent.matrix.util.MatrixLog;
import java.lang.reflect.Field;

public class ReflectFiled<Type> {
    private static final String TAG = "ReflectFiled";
    private Class<?> mClazz;
    private String mFieldName;
    private boolean mInit;
    private Field mField;

    public ReflectFiled(Class<?> clazz, String fieldName) {
        if (clazz == null || fieldName == null || fieldName.length() == 0) {
            throw new IllegalArgumentException("Both of invoker and fieldName can not be null or nil.");
        }
        this.mClazz = clazz;
        this.mFieldName = fieldName;
    }

    private synchronized void prepare() {
        if (this.mInit) {
            return;
        }
        for (Class<?> clazz = this.mClazz; clazz != null; clazz = clazz.getSuperclass()) {
            try {
                Field f = clazz.getDeclaredField(this.mFieldName);
                f.setAccessible(true);
                this.mField = f;
                break;
            }
            catch (Exception exception) {
                continue;
            }
        }
        this.mInit = true;
    }

    public synchronized Type get() throws NoSuchFieldException, IllegalAccessException, IllegalArgumentException {
        return this.get(false);
    }

    public synchronized Type get(boolean ignoreFieldNoExist) throws NoSuchFieldException, IllegalAccessException, IllegalArgumentException {
        this.prepare();
        if (this.mField == null) {
            if (!ignoreFieldNoExist) {
                throw new NoSuchFieldException();
            }
            MatrixLog.w(TAG, String.format("Field %s is no exists.", this.mFieldName), new Object[0]);
            return null;
        }
        Object fieldVal = null;
        try {
            fieldVal = this.mField.get(null);
        }
        catch (ClassCastException e) {
            throw new IllegalArgumentException("unable to cast object");
        }
        return (Type)fieldVal;
    }

    public synchronized Type get(boolean ignoreFieldNoExist, Object instance) throws NoSuchFieldException, IllegalAccessException, IllegalArgumentException {
        this.prepare();
        if (this.mField == null) {
            if (!ignoreFieldNoExist) {
                throw new NoSuchFieldException();
            }
            MatrixLog.w(TAG, String.format("Field %s is no exists.", this.mFieldName), new Object[0]);
            return null;
        }
        Object fieldVal = null;
        try {
            fieldVal = this.mField.get(instance);
        }
        catch (ClassCastException e) {
            throw new IllegalArgumentException("unable to cast object");
        }
        return (Type)fieldVal;
    }

    public synchronized Type get(Object instance) throws NoSuchFieldException, IllegalAccessException {
        return this.get(false, instance);
    }

    public synchronized Type getWithoutThrow(Object instance) {
        Type fieldVal = null;
        try {
            fieldVal = this.get(true, instance);
        }
        catch (NoSuchFieldException e) {
            MatrixLog.i(TAG, "getWithoutThrow, exception occur :%s", e);
        }
        catch (IllegalAccessException e) {
            MatrixLog.i(TAG, "getWithoutThrow, exception occur :%s", e);
        }
        catch (IllegalArgumentException e) {
            MatrixLog.i(TAG, "getWithoutThrow, exception occur :%s", e);
        }
        return fieldVal;
    }

    public synchronized Type getWithoutThrow() {
        Type fieldVal = null;
        try {
            fieldVal = this.get(true);
        }
        catch (NoSuchFieldException e) {
            MatrixLog.i(TAG, "getWithoutThrow, exception occur :%s", e);
        }
        catch (IllegalAccessException e) {
            MatrixLog.i(TAG, "getWithoutThrow, exception occur :%s", e);
        }
        catch (IllegalArgumentException e) {
            MatrixLog.i(TAG, "getWithoutThrow, exception occur :%s", e);
        }
        return fieldVal;
    }

    public synchronized boolean set(Object instance, Type val) throws NoSuchFieldException, IllegalAccessException, IllegalArgumentException {
        return this.set(instance, val, false);
    }

    public synchronized boolean set(Object instance, Type val, boolean ignoreFieldNoExist) throws NoSuchFieldException, IllegalAccessException, IllegalArgumentException {
        this.prepare();
        if (this.mField == null) {
            if (!ignoreFieldNoExist) {
                throw new NoSuchFieldException("Method " + this.mFieldName + " is not exists.");
            }
            MatrixLog.w(TAG, String.format("Field %s is no exists.", this.mFieldName), new Object[0]);
            return false;
        }
        this.mField.set(instance, val);
        return true;
    }

    public synchronized boolean setWithoutThrow(Object instance, Type val) {
        boolean result = false;
        try {
            result = this.set(instance, val, true);
        }
        catch (NoSuchFieldException e) {
            MatrixLog.i(TAG, "setWithoutThrow, exception occur :%s", e);
        }
        catch (IllegalAccessException e) {
            MatrixLog.i(TAG, "setWithoutThrow, exception occur :%s", e);
        }
        catch (IllegalArgumentException e) {
            MatrixLog.i(TAG, "setWithoutThrow, exception occur :%s", e);
        }
        return result;
    }

    public synchronized boolean set(Type val) throws NoSuchFieldException, IllegalAccessException {
        return this.set(null, val, false);
    }

    public synchronized boolean setWithoutThrow(Type val) {
        boolean result = false;
        try {
            result = this.set(null, val, true);
        }
        catch (NoSuchFieldException e) {
            MatrixLog.i(TAG, "setWithoutThrow, exception occur :%s", e);
        }
        catch (IllegalAccessException e) {
            MatrixLog.i(TAG, "setWithoutThrow, exception occur :%s", e);
        }
        catch (IllegalArgumentException e) {
            MatrixLog.i(TAG, "setWithoutThrow, exception occur :%s", e);
        }
        return result;
    }
}

