/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.matrix.report;

import android.content.Context;
import android.content.SharedPreferences;
import com.tencent.matrix.report.IssuePublisher;
import com.tencent.matrix.util.MatrixLog;
import com.tencent.matrix.util.MatrixUtil;
import java.util.HashMap;
import java.util.HashSet;

public class FilePublisher
extends IssuePublisher {
    private static final String TAG = "Matrix.FilePublisher";
    private final long mExpiredTime;
    private final SharedPreferences.Editor mEditor;
    private final HashMap<String, Long> mPublishedMap;
    private final Context mContext;

    public FilePublisher(Context context, long expire, String tag, IssuePublisher.OnIssueDetectListener issueDetectListener) {
        super(issueDetectListener);
        this.mContext = context;
        this.mExpiredTime = expire;
        String spName = "Matrix_" + tag + MatrixUtil.getProcessName(context);
        SharedPreferences sharedPreferences = context.getSharedPreferences(spName, 0);
        this.mPublishedMap = new HashMap();
        long current = System.currentTimeMillis();
        this.mEditor = sharedPreferences.edit();
        HashSet spKeys = null;
        if (null != sharedPreferences.getAll()) {
            spKeys = new HashSet(sharedPreferences.getAll().keySet());
        }
        if (null != spKeys) {
            for (String key : spKeys) {
                try {
                    long start = sharedPreferences.getLong(key, 0L);
                    long costTime = current - start;
                    if (start <= 0L || costTime > this.mExpiredTime) {
                        this.mEditor.remove(key);
                        continue;
                    }
                    this.mPublishedMap.put(key, start);
                }
                catch (ClassCastException e) {
                    MatrixLog.printErrStackTrace(TAG, e, "might be polluted - sp: %s, key: %s, value : %s", spName, key, sharedPreferences.getAll().get(key));
                }
            }
        }
        if (null != this.mEditor) {
            this.mEditor.apply();
        }
    }

    public void markPublished(String key, boolean persist) {
        SharedPreferences.Editor e;
        if (key == null) {
            return;
        }
        if (this.mPublishedMap.containsKey(key)) {
            return;
        }
        long now = System.currentTimeMillis();
        this.mPublishedMap.put(key, now);
        if (persist && null != (e = this.mEditor.putLong(key, now))) {
            e.apply();
        }
    }

    @Override
    public void markPublished(String key) {
        this.markPublished(key, true);
    }

    @Override
    public void unMarkPublished(String key) {
        if (key == null) {
            return;
        }
        if (!this.mPublishedMap.containsKey(key)) {
            return;
        }
        this.mPublishedMap.remove(key);
        SharedPreferences.Editor e = this.mEditor.remove(key);
        if (null != e) {
            e.apply();
        }
    }

    @Override
    public boolean isPublished(String key) {
        if (!this.mPublishedMap.containsKey(key)) {
            return false;
        }
        long start = this.mPublishedMap.get(key);
        if (start <= 0L || System.currentTimeMillis() - start > this.mExpiredTime) {
            SharedPreferences.Editor e = this.mEditor.remove(key);
            if (null != e) {
                e.apply();
            }
            this.mPublishedMap.remove(key);
            return false;
        }
        return true;
    }

    public Context getContext() {
        return this.mContext;
    }
}

