/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 *
 * Copyright (c) 1997-2010 Oracle and/or its affiliates. All rights reserved.
 *
 * The contents of this file are subject to the terms of either the GNU
 * General Public License Version 2 only ("GPL") or the Common Development
 * and Distribution License("CDDL") (collectively, the "License").  You
 * may not use this file except in compliance with the License.  You can
 * obtain a copy of the License at
 * https://glassfish.dev.java.net/public/CDDL+GPL_1_1.html
 * or packager/legal/LICENSE.txt.  See the License for the specific
 * language governing permissions and limitations under the License.
 *
 * When distributing the software, include this License Header Notice in each
 * file and include the License file at packager/legal/LICENSE.txt.
 *
 * GPL Classpath Exception:
 * Oracle designates this particular file as subject to the "Classpath"
 * exception as provided by Oracle in the GPL Version 2 section of the License
 * file that accompanied this code.
 *
 * Modifications:
 * If applicable, add the following below the License Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyright [year] [name of copyright owner]"
 *
 * Contributor(s):
 * If you wish your version of this file to be governed by only the CDDL or
 * only the GPL Version 2, indicate your decision by adding "[Contributor]
 * elects to include this software in this distribution under the [CDDL or GPL
 * Version 2] license."  If you don't indicate a single choice of license, a
 * recipient has the option to distribute your version of this file under
 * either the CDDL, the GPL Version 2 or to extend the choice of license to
 * its licensees as provided above.  However, if you add GPL Version 2 code
 * and therefore, elected the GPL Version 2 license, then the option applies
 * only if the new code is made subject to such option by the copyright
 * holder.
 *
 *
 * This file incorporates work covered by the following copyright and
 * permission notice:
 *
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

// FileURL.java - Construct a file: scheme URL


package com.sun.org.apache.xml.internal.resolver.helpers;

import java.net.URL;
import java.net.MalformedURLException;
import java.io.File;

/**
 * Static method for dealing with file: URLs.
 *
 * <p>This class defines a static method that can be used to construct
 * an appropriate file: URL from parts. It's defined here so that it
 * can be reused throught the resolver.</p>
 *
 * <p>(Yes, I'd rather have called this class FileUR<b>I</b>, but
 * given that a jave.net.URL is returned, it seemed...even more
 * confusing.)</p>
 *
 * @author Norman Walsh
 * <a href="mailto:Norman.Walsh@Sun.COM">Norman.Walsh@Sun.COM</a>
 *
 * @version 1.0
 */
public abstract class FileURL {
  protected FileURL() { }

  /**
   * Construct a file: URL for a path name.
   *
   * <p>URLs in the file: scheme can be constructed for paths on
   * the local file system. Several possibilities need to be considered:
   * </p>
   *
   * <ul>
   * <li>If the path does not begin with a slash, then it is assumed
   * to reside in the users current working directory
   * (System.getProperty("user.dir")).</li>
   * <li>On Windows machines, the current working directory uses
   * backslashes (\\, instead of /).</li>
   * <li>If the current working directory is "/", don't add an extra
   * slash before the base name.</li>
   * </ul>
   *
   * <p>This method is declared static so that other classes
   * can use it directly.</p>
   *
   * @param pathname The path name component for which to construct a URL.
   *
   * @return The appropriate file: URL.
   *
   * @throws MalformedURLException if the pathname can't be turned into
   *         a proper URL.
   */
  public static URL makeURL(String pathname) throws MalformedURLException {
    /*if (pathname.startsWith("/")) {
      return new URL("file://" + pathname);
    }
     
    String userdir = System.getProperty("user.dir");
    userdir.replace('\\', '/');
     
    if (userdir.endsWith("/")) {
      return new URL("file:///" + userdir + pathname);
    } else {
      return new URL("file:///" + userdir + "/" + pathname);
    }
     */
      File file = new File(pathname);
      return file.toURI().toURL();
  }
}
