/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 *
 * Copyright (c) 1997-2010 Oracle and/or its affiliates. All rights reserved.
 *
 * The contents of this file are subject to the terms of either the GNU
 * General Public License Version 2 only ("GPL") or the Common Development
 * and Distribution License("CDDL") (collectively, the "License").  You
 * may not use this file except in compliance with the License.  You can
 * obtain a copy of the License at
 * https://glassfish.dev.java.net/public/CDDL+GPL_1_1.html
 * or packager/legal/LICENSE.txt.  See the License for the specific
 * language governing permissions and limitations under the License.
 *
 * When distributing the software, include this License Header Notice in each
 * file and include the License file at packager/legal/LICENSE.txt.
 *
 * GPL Classpath Exception:
 * Oracle designates this particular file as subject to the "Classpath"
 * exception as provided by Oracle in the GPL Version 2 section of the License
 * file that accompanied this code.
 *
 * Modifications:
 * If applicable, add the following below the License Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyright [year] [name of copyright owner]"
 *
 * Contributor(s):
 * If you wish your version of this file to be governed by only the CDDL or
 * only the GPL Version 2, indicate your decision by adding "[Contributor]
 * elects to include this software in this distribution under the [CDDL or GPL
 * Version 2] license."  If you don't indicate a single choice of license, a
 * recipient has the option to distribute your version of this file under
 * either the CDDL, the GPL Version 2 or to extend the choice of license to
 * its licensees as provided above.  However, if you add GPL Version 2 code
 * and therefore, elected the GPL Version 2 license, then the option applies
 * only if the new code is made subject to such option by the copyright
 * holder.
 *
 *
 * This file incorporates work covered by the following copyright and
 * permission notice:
 *
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/*
 * $Id: SlotAllocator.java,v 1.10 2010-11-01 04:34:20 joehw Exp $
 */
package com.sun.org.apache.xalan.internal.xsltc.compiler.util;

import com.sun.org.apache.bcel.internal.generic.LocalVariableGen;
import com.sun.org.apache.bcel.internal.generic.Type;

/**
 * @author Jacek Ambroziak
 */
final class SlotAllocator {

    private int   _firstAvailableSlot;
    private int   _size = 8;
    private int   _free = 0;
    private int[] _slotsTaken = new int[_size];
    
    public void initialize(LocalVariableGen[] vars) {
	final int length = vars.length;
	int slot = 0, size, index;

	for (int i = 0; i < length; i++) {
	    size  = vars[i].getType().getSize();
	    index = vars[i].getIndex();
	    slot  = Math.max(slot, index + size);
	}
	_firstAvailableSlot = slot;
    }

    public int allocateSlot(Type type) {
	final int size = type.getSize();
	final int limit = _free;
	int slot = _firstAvailableSlot, where = 0;

	if (_free + size > _size) {
	    final int[] array = new int[_size *= 2];
	    for (int j = 0; j < limit; j++)
		array[j] = _slotsTaken[j];
	    _slotsTaken = array;
	}

	while (where < limit) {
	    if (slot + size <= _slotsTaken[where]) {
		// insert
		for (int j = limit - 1; j >= where; j--)
		    _slotsTaken[j + size] = _slotsTaken[j];
		break;
	    }
	    else {
		slot = _slotsTaken[where++] + 1;
	    }
	}
	
	for (int j = 0; j < size; j++)
	    _slotsTaken[where + j] = slot + j;
	
	_free += size;
	return slot;
    }

    public void releaseSlot(LocalVariableGen lvg) {
	final int size = lvg.getType().getSize();
	final int slot = lvg.getIndex();
	final int limit = _free;
	
	for (int i = 0; i < limit; i++) {
	    if (_slotsTaken[i] == slot) {
		int j = i + size;
		while (j < limit) {
		    _slotsTaken[i++] = _slotsTaken[j++];
		}
		_free -= size;
		return;
	    }
	}
	String state = "Variable slot allocation error"+
	               "(size="+size+", slot="+slot+", limit="+limit+")";
	ErrorMsg err = new ErrorMsg(ErrorMsg.INTERNAL_ERR, state);
	throw new Error(err.toString());
    }
}
