/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 *
 * Copyright (c) 1997-2010 Oracle and/or its affiliates. All rights reserved.
 *
 * The contents of this file are subject to the terms of either the GNU
 * General Public License Version 2 only ("GPL") or the Common Development
 * and Distribution License("CDDL") (collectively, the "License").  You
 * may not use this file except in compliance with the License.  You can
 * obtain a copy of the License at
 * https://glassfish.dev.java.net/public/CDDL+GPL_1_1.html
 * or packager/legal/LICENSE.txt.  See the License for the specific
 * language governing permissions and limitations under the License.
 *
 * When distributing the software, include this License Header Notice in each
 * file and include the License file at packager/legal/LICENSE.txt.
 *
 * GPL Classpath Exception:
 * Oracle designates this particular file as subject to the "Classpath"
 * exception as provided by Oracle in the GPL Version 2 section of the License
 * file that accompanied this code.
 *
 * Modifications:
 * If applicable, add the following below the License Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyright [year] [name of copyright owner]"
 *
 * Contributor(s):
 * If you wish your version of this file to be governed by only the CDDL or
 * only the GPL Version 2, indicate your decision by adding "[Contributor]
 * elects to include this software in this distribution under the [CDDL or GPL
 * Version 2] license."  If you don't indicate a single choice of license, a
 * recipient has the option to distribute your version of this file under
 * either the CDDL, the GPL Version 2 or to extend the choice of license to
 * its licensees as provided above.  However, if you add GPL Version 2 code
 * and therefore, elected the GPL Version 2 license, then the option applies
 * only if the new code is made subject to such option by the copyright
 * holder.
 *
 *
 * This file incorporates work covered by the following copyright and
 * permission notice:
 *
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/*
 * $Id: DOM.java,v 1.10 2010-11-01 04:34:13 joehw Exp $
 */
package com.sun.org.apache.xalan.internal.xsltc;

import com.sun.org.apache.xalan.internal.xsltc.runtime.Hashtable;
import com.sun.org.apache.xml.internal.dtm.DTMAxisIterator;

import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

import com.sun.org.apache.xml.internal.serializer.SerializationHandler;

/**
 * @author Jacek Ambroziak
 * @author Santiago Pericas-Geertsen
 */
public interface DOM {
    public final static int  FIRST_TYPE             = 0;

    public final static int  NO_TYPE                = -1;
    
    // 0 is reserved for NodeIterator.END
    public final static int NULL     = 0;

    // used by some node iterators to know which node to return
    public final static int RETURN_CURRENT = 0;
    public final static int RETURN_PARENT  = 1;
    
    // Constants used by getResultTreeFrag to indicate the types of the RTFs.
    public final static int SIMPLE_RTF   = 0;
    public final static int ADAPTIVE_RTF = 1;
    public final static int TREE_RTF     = 2;
    
    /** returns singleton iterator containg the document root */
    public DTMAxisIterator getIterator();
    public String getStringValue();
	
    public DTMAxisIterator getChildren(final int node);
    public DTMAxisIterator getTypedChildren(final int type);
    public DTMAxisIterator getAxisIterator(final int axis);
    public DTMAxisIterator getTypedAxisIterator(final int axis, final int type);
    public DTMAxisIterator getNthDescendant(int node, int n, boolean includeself);
    public DTMAxisIterator getNamespaceAxisIterator(final int axis, final int ns);
    public DTMAxisIterator getNodeValueIterator(DTMAxisIterator iter, int returnType,
					     String value, boolean op);
    public DTMAxisIterator orderNodes(DTMAxisIterator source, int node);
    public String getNodeName(final int node);
    public String getNodeNameX(final int node);
    public String getNamespaceName(final int node);
    public int getExpandedTypeID(final int node);
    public int getNamespaceType(final int node);
    public int getParent(final int node);
    public int getAttributeNode(final int gType, final int element);
    public String getStringValueX(final int node);
    public void copy(final int node, SerializationHandler handler)
	throws TransletException;
    public void copy(DTMAxisIterator nodes, SerializationHandler handler)
	throws TransletException;
    public String shallowCopy(final int node, SerializationHandler handler)
	throws TransletException;
    public boolean lessThan(final int node1, final int node2);
    public void characters(final int textNode, SerializationHandler handler)
	throws TransletException;
    public Node makeNode(int index);
    public Node makeNode(DTMAxisIterator iter);
    public NodeList makeNodeList(int index);
    public NodeList makeNodeList(DTMAxisIterator iter);
    public String getLanguage(int node);
    public int getSize();
    public String getDocumentURI(int node);
    public void setFilter(StripFilter filter);
    public void setupMapping(String[] names, String[] urisArray, int[] typesArray, String[] namespaces);
    public boolean isElement(final int node);
    public boolean isAttribute(final int node);
    public String lookupNamespace(int node, String prefix)
	throws TransletException;
    public int getNodeIdent(final int nodehandle);
    public int getNodeHandle(final int nodeId);
    public DOM getResultTreeFrag(int initialSize, int rtfType);
    public DOM getResultTreeFrag(int initialSize, int rtfType, boolean addToDTMManager);
    public SerializationHandler getOutputDomBuilder();
    public int getNSType(int node);
    public int getDocument();
    public String getUnparsedEntityURI(String name);
    public Hashtable getElementsWithIDs();
}
