/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 * 
 * Copyright 1997-2007 Sun Microsystems, Inc. All rights reserved.
 * 
 * The contents of this file are subject to the terms of either the GNU
 * General Public License Version 2 only ("GPL") or the Common Development
 * and Distribution License("CDDL") (collectively, the "License").  You
 * may not use this file except in compliance with the License. You can obtain
 * a copy of the License at https://glassfish.dev.java.net/public/CDDL+GPL.html
 * or glassfish/bootstrap/legal/LICENSE.txt.  See the License for the specific
 * language governing permissions and limitations under the License.
 * 
 * When distributing the software, include this License Header Notice in each
 * file and include the License file at glassfish/bootstrap/legal/LICENSE.txt.
 * Sun designates this particular file as subject to the "Classpath" exception
 * as provided by Sun in the GPL Version 2 section of the License file that
 * accompanied this code.  If applicable, add the following below the License
 * Header, with the fields enclosed by brackets [] replaced by your own
 * identifying information: "Portions Copyrighted [year]
 * [name of copyright owner]"
 * 
 * Contributor(s):
 * 
 * If you wish your version of this file to be governed by only the CDDL or
 * only the GPL Version 2, indicate your decision by adding "[Contributor]
 * elects to include this software in this distribution under the [CDDL or GPL
 * Version 2] license."  If you don't indicate a single choice of license, a
 * recipient has the option to distribute your version of this file under
 * either the CDDL, the GPL Version 2 or to extend the choice of license to
 * its licensees as provided above.  However, if you add GPL Version 2 code
 * and therefore, elected the GPL Version 2 license, then the option applies
 * only if the new code is made subject to such option by the copyright
 * holder.
 */

package com.sun.java_cup.internal;

/** This abstract class serves as the base class for grammar symbols (i.e.,
 * both terminals and non-terminals).  Each symbol has a name string, and
 * a string giving the type of object that the symbol will be represented by
 * on the runtime parse stack.  In addition, each symbol maintains a use count
 * in order to detect symbols that are declared but never used, and an index
 * number that indicates where it appears in parse tables (index numbers are
 * unique within terminals or non terminals, but not across both).
 *
 * @see     com.sun.java_cup.internal.terminal
 * @see     com.sun.java_cup.internal.non_terminal
 * @version last updated: 7/3/96
 * @author  Frank Flannery
 */
public abstract class symbol {
   /*-----------------------------------------------------------*/
   /*--- Constructor(s) ----------------------------------------*/
   /*-----------------------------------------------------------*/

   /** Full constructor.
    * @param nm the name of the symbol.
    * @param tp a string with the type name.
    */
   public symbol(String nm, String tp)
     {
       /* sanity check */
       if (nm == null) nm = "";

       /* apply default if no type given */
       if (tp == null) tp = "Object";

       _name = nm;
       _stack_type = tp;
     }

  /*. . . . . . . . . . . . . . . . . . . . . . . . . . . . . .*/

   /** Constructor with default type. 
    * @param nm the name of the symbol.
    */
   public symbol(String nm)
     {
       this(nm, null);
     }

   /*-----------------------------------------------------------*/
   /*--- (Access to) Instance Variables ------------------------*/
   /*-----------------------------------------------------------*/

   /** String for the human readable name of the symbol. */
   protected String _name; 
 
   /** String for the human readable name of the symbol. */
   public String name() {return _name;}

  /*. . . . . . . . . . . . . . . . . . . . . . . . . . . . . .*/

   /** String for the type of object used for the symbol on the parse stack. */
   protected String _stack_type;

   /** String for the type of object used for the symbol on the parse stack. */
   public String stack_type() {return _stack_type;}

  /*. . . . . . . . . . . . . . . . . . . . . . . . . . . . . .*/

   /** Count of how many times the symbol appears in productions. */
   protected int _use_count = 0;

   /** Count of how many times the symbol appears in productions. */
   public int use_count() {return _use_count;}

   /** Increment the use count. */ 
   public void note_use() {_use_count++;}
 
  /*. . . . . . . . . . . . . . . . . . . . . . . . . . . . . .*/
 
  /** Index of this symbol (terminal or non terminal) in the parse tables.
   *  Note: indexes are unique among terminals and unique among non terminals,
   *  however, a terminal may have the same index as a non-terminal, etc. 
   */
   protected int _index;
 
  /** Index of this symbol (terminal or non terminal) in the parse tables.
   *  Note: indexes are unique among terminals and unique among non terminals,
   *  however, a terminal may have the same index as a non-terminal, etc. 
   */
   public int index() {return _index;}

  /*. . . . . . . . . . . . . . . . . . . . . . . . . . . . . .*/

  /** Indicate if this is a non-terminal.  Here in the base class we
   *  don't know, so this is abstract.  
   */
  public abstract boolean is_non_term();

  /*. . . . . . . . . . . . . . . . . . . . . . . . . . . . . .*/

  /** Convert to a string. */
  public String toString()
    {
      return name();
    }

  /*-----------------------------------------------------------*/

}
