/*
 * Decompiled with CFR 0.152.
 */
package com.sun.grizzly.tcp.http11.filters;

import com.sun.grizzly.tcp.OutputBuffer;
import com.sun.grizzly.tcp.Response;
import com.sun.grizzly.tcp.http11.OutputFilter;
import com.sun.grizzly.util.LoggerUtils;
import com.sun.grizzly.util.buf.ByteChunk;
import java.io.IOException;
import java.io.OutputStream;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.GZIPOutputStream;

public class GzipOutputFilter
implements OutputFilter {
    private static final Logger LOGGER = LoggerUtils.getLogger();
    protected static final String ENCODING_NAME = "gzip";
    protected static final ByteChunk ENCODING = new ByteChunk();
    private final ByteChunk alias;
    protected OutputBuffer buffer;
    protected GZIPOutputStream compressionStream = null;
    protected OutputStream fakeOutputStream = new FakeOutputStream();

    public GzipOutputFilter() {
        this.alias = ENCODING;
    }

    public GzipOutputFilter(String alias) {
        ByteChunk bc = new ByteChunk();
        bc.setBytes(alias.getBytes(), 0, alias.length());
        this.alias = bc;
    }

    public int doWrite(ByteChunk chunk, Response res) throws IOException {
        if (this.compressionStream == null) {
            this.compressionStream = new GZIPOutputStream(this.fakeOutputStream);
        }
        this.compressionStream.write(chunk.getBytes(), chunk.getStart(), chunk.getLength());
        return chunk.getLength();
    }

    public void setResponse(Response response) {
    }

    public void setBuffer(OutputBuffer buffer) {
        this.buffer = buffer;
    }

    public long end() throws IOException {
        if (this.compressionStream == null) {
            this.compressionStream = new GZIPOutputStream(this.fakeOutputStream);
        }
        this.compressionStream.finish();
        return ((OutputFilter)this.buffer).end();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void recycle() {
        try {
            if (this.compressionStream != null) {
                this.compressionStream.close();
            }
        }
        catch (IOException ex) {
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.log(Level.FINE, ex.toString(), ex);
            }
        }
        finally {
            this.compressionStream = null;
        }
    }

    public ByteChunk getEncodingName() {
        return this.alias;
    }

    static {
        ENCODING.setBytes(ENCODING_NAME.getBytes(), 0, ENCODING_NAME.length());
    }

    protected class FakeOutputStream
    extends OutputStream {
        protected ByteChunk outputChunk = new ByteChunk();
        protected byte[] singleByteBuffer = new byte[1];

        protected FakeOutputStream() {
        }

        public void write(int b) throws IOException {
            this.singleByteBuffer[0] = (byte)(b & 0xFF);
            this.outputChunk.setBytes(this.singleByteBuffer, 0, 1);
            GzipOutputFilter.this.buffer.doWrite(this.outputChunk, null);
        }

        public void write(byte[] b, int off, int len) throws IOException {
            this.outputChunk.setBytes(b, off, len);
            GzipOutputFilter.this.buffer.doWrite(this.outputChunk, null);
        }

        public void flush() throws IOException {
        }

        public void close() throws IOException {
        }
    }
}

