/*
 * Decompiled with CFR 0.152.
 */
package com.sun.faces.util;

import com.sun.faces.config.WebConfiguration;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.BitSet;
import java.util.HashSet;
import java.util.Set;

public class HtmlUtils {
    private static final Set<String> UTF_CHARSET;
    private static final char[] AMP_CHARS;
    private static final char[] QUOT_CHARS;
    private static final char[] GT_CHARS;
    private static final char[] LT_CHARS;
    private static final char[] EURO_CHARS;
    private static final char[] DEC_REF_START;
    private static final int MAX_BYTES_PER_CHAR = 10;
    private static final BitSet DONT_ENCODE_SET;
    private static char[][] sISO8859_1_Entities;
    private static char _LAST_EMPTY_ELEMENT_START;
    private static String[][] emptyElementArr;
    private static String[] aNames;
    private static String[] bNames;
    private static String[] cNames;
    private static String[] fNames;
    private static String[] hNames;
    private static String[] iNames;
    private static String[] lNames;
    private static String[] mNames;
    private static String[] pNames;

    public static void writeText(Writer writer, boolean bl, boolean bl2, char[] cArray, char[] cArray2) throws IOException {
        HtmlUtils.writeText(writer, bl, bl2, cArray, cArray2, 0, cArray2.length);
    }

    public static void writeText(Writer writer, boolean bl, boolean bl2, char[] cArray, char[] cArray2, int n, int n2) throws IOException {
        int n3 = cArray.length;
        int n4 = 0;
        int n5 = n + n2;
        for (int i = n; i < n5; ++i) {
            n4 = HtmlUtils.writeTextChar(writer, bl, bl2, cArray2[i], n4, cArray, n3);
        }
        HtmlUtils.flushBuffer(writer, cArray, n4);
    }

    public static void writeText(Writer writer, boolean bl, boolean bl2, char[] cArray, String string, char[] cArray2) throws IOException {
        int n = string.length();
        if (n >= 16) {
            string.getChars(0, n, cArray2, 0);
            HtmlUtils.writeText(writer, bl, bl2, cArray, cArray2, 0, n);
        } else {
            int n2 = cArray.length;
            int n3 = 0;
            for (int i = 0; i < n; ++i) {
                char c = string.charAt(i);
                n3 = HtmlUtils.writeTextChar(writer, bl, bl2, c, n3, cArray, n2);
            }
            HtmlUtils.flushBuffer(writer, cArray, n3);
        }
    }

    private static int writeTextChar(Writer writer, boolean bl, boolean bl2, char c, int n, char[] cArray, int n2) throws IOException {
        if (c <= '\u001f' && !HtmlUtils.isPrintableControlChar(c)) {
            return n;
        }
        int n3 = c < '\u00a0' ? (c >= '?' ? HtmlUtils.addToBuffer(writer, cArray, n, n2, c) : (c >= '\'' ? (c < '<' ? HtmlUtils.addToBuffer(writer, cArray, n, n2, c) : (c == '<' ? HtmlUtils.addToBuffer(writer, cArray, n, n2, LT_CHARS) : (c == '>' ? HtmlUtils.addToBuffer(writer, cArray, n, n2, GT_CHARS) : HtmlUtils.addToBuffer(writer, cArray, n, n2, c)))) : (c == '&' ? HtmlUtils.addToBuffer(writer, cArray, n, n2, AMP_CHARS) : (c == '\"' ? HtmlUtils.addToBuffer(writer, cArray, n, n2, "\"".toCharArray()) : HtmlUtils.addToBuffer(writer, cArray, n, n2, c))))) : (c <= '\u00ff' ? (bl2 ? HtmlUtils.addToBuffer(writer, cArray, n, n2, sISO8859_1_Entities[c - 160]) : HtmlUtils.addToBuffer(writer, cArray, n, n2, c)) : (bl ? HtmlUtils._writeDecRef(writer, cArray, n, n2, c) : HtmlUtils.addToBuffer(writer, cArray, n, n2, c)));
        return n3;
    }

    public static void writeAttribute(Writer writer, boolean bl, boolean bl2, char[] cArray, String string, char[] cArray2, boolean bl3) throws IOException {
        int n = string.length();
        if (n >= 16) {
            if (n > cArray2.length) {
                cArray2 = new char[n * 2];
            }
            string.getChars(0, n, cArray2, 0);
            HtmlUtils.writeAttribute(writer, bl, bl2, cArray, cArray2, 0, n, bl3);
        } else {
            int n2 = cArray.length;
            int n3 = 0;
            for (int i = 0; i < n; ++i) {
                char c = string.charAt(i);
                if (c <= '\u001f' && !HtmlUtils.isPrintableControlChar(c)) continue;
                if (c < '\u00a0') {
                    if (c >= '?') {
                        if (c == 's' && !bl3 && i + 6 < string.length() && 'c' == string.charAt(i + 1) && 'r' == string.charAt(i + 2) && 'i' == string.charAt(i + 3) && 'p' == string.charAt(i + 4) && 't' == string.charAt(i + 5) && ':' == string.charAt(i + 6)) {
                            return;
                        }
                        n3 = HtmlUtils.addToBuffer(writer, cArray, n3, n2, c);
                        continue;
                    }
                    if (c >= '\'') {
                        if (c < '<') {
                            n3 = HtmlUtils.addToBuffer(writer, cArray, n3, n2, c);
                            continue;
                        }
                        if (c == '<') {
                            n3 = HtmlUtils.addToBuffer(writer, cArray, n3, n2, LT_CHARS);
                            continue;
                        }
                        if (c == '>') {
                            n3 = HtmlUtils.addToBuffer(writer, cArray, n3, n2, GT_CHARS);
                            continue;
                        }
                        n3 = HtmlUtils.addToBuffer(writer, cArray, n3, n2, c);
                        continue;
                    }
                    if (c == '&') {
                        if (i + 1 < n && string.charAt(i + 1) == '{') {
                            n3 = HtmlUtils.addToBuffer(writer, cArray, n3, n2, c);
                            continue;
                        }
                        n3 = HtmlUtils.addToBuffer(writer, cArray, n3, n2, AMP_CHARS);
                        continue;
                    }
                    if (c == '\"') {
                        n3 = HtmlUtils.addToBuffer(writer, cArray, n3, n2, QUOT_CHARS);
                        continue;
                    }
                    n3 = HtmlUtils.addToBuffer(writer, cArray, n3, n2, c);
                    continue;
                }
                if (c <= '\u00ff') {
                    if (bl2) {
                        n3 = HtmlUtils.addToBuffer(writer, cArray, n3, n2, sISO8859_1_Entities[c - 160]);
                        continue;
                    }
                    n3 = HtmlUtils.addToBuffer(writer, cArray, n3, n2, c);
                    continue;
                }
                n3 = bl ? HtmlUtils._writeDecRef(writer, cArray, n3, n2, c) : HtmlUtils.addToBuffer(writer, cArray, n3, n2, c);
            }
            HtmlUtils.flushBuffer(writer, cArray, n3);
        }
    }

    public static void writeAttribute(Writer writer, boolean bl, boolean bl2, char[] cArray, char[] cArray2) throws IOException {
        HtmlUtils.writeAttribute(writer, bl, bl2, cArray, cArray2, 0, cArray2.length, WebConfiguration.BooleanWebContextInitParameter.EnableScriptInAttributeValue.getDefaultValue());
    }

    public static void writeAttribute(Writer writer, boolean bl, boolean bl2, char[] cArray, char[] cArray2, int n, int n2, boolean bl3) throws IOException {
        int n3 = cArray.length;
        int n4 = 0;
        int n5 = n + n2;
        for (int i = n; i < n5; ++i) {
            char c = cArray2[i];
            if (c <= '\u001f' && !HtmlUtils.isPrintableControlChar(c)) continue;
            if (c < '\u00a0') {
                if (c >= '?') {
                    if (c == 's' && !bl3 && i + 6 < cArray2.length && 'c' == cArray2[i + 1] && 'r' == cArray2[i + 2] && 'i' == cArray2[i + 3] && 'p' == cArray2[i + 4] && 't' == cArray2[i + 5] && ':' == cArray2[i + 6]) {
                        return;
                    }
                    n4 = HtmlUtils.addToBuffer(writer, cArray, n4, n3, c);
                    continue;
                }
                if (c >= '\'') {
                    if (c < '<') {
                        n4 = HtmlUtils.addToBuffer(writer, cArray, n4, n3, c);
                        continue;
                    }
                    if (c == '<') {
                        n4 = HtmlUtils.addToBuffer(writer, cArray, n4, n3, LT_CHARS);
                        continue;
                    }
                    if (c == '>') {
                        n4 = HtmlUtils.addToBuffer(writer, cArray, n4, n3, GT_CHARS);
                        continue;
                    }
                    n4 = HtmlUtils.addToBuffer(writer, cArray, n4, n3, c);
                    continue;
                }
                if (c == '&') {
                    if (i + 1 < n5 && cArray2[i + 1] == '{') {
                        n4 = HtmlUtils.addToBuffer(writer, cArray, n4, n3, c);
                        continue;
                    }
                    n4 = HtmlUtils.addToBuffer(writer, cArray, n4, n3, AMP_CHARS);
                    continue;
                }
                if (c == '\"') {
                    n4 = HtmlUtils.addToBuffer(writer, cArray, n4, n3, QUOT_CHARS);
                    continue;
                }
                n4 = HtmlUtils.addToBuffer(writer, cArray, n4, n3, c);
                continue;
            }
            if (c <= '\u00ff') {
                if (bl2) {
                    n4 = HtmlUtils.addToBuffer(writer, cArray, n4, n3, sISO8859_1_Entities[c - 160]);
                    continue;
                }
                n4 = HtmlUtils.addToBuffer(writer, cArray, n4, n3, c);
                continue;
            }
            n4 = bl ? HtmlUtils._writeDecRef(writer, cArray, n4, n3, c) : HtmlUtils.addToBuffer(writer, cArray, n4, n3, c);
        }
        HtmlUtils.flushBuffer(writer, cArray, n4);
    }

    private static boolean isPrintableControlChar(int n) {
        return n == 9 || n == 10 || n == 12 || n == 13;
    }

    private static int _writeDecRef(Writer writer, char[] cArray, int n, int n2, char n3) throws IOException {
        if (n3 == 8364) {
            n = HtmlUtils.addToBuffer(writer, cArray, n, n2, EURO_CHARS);
            return n;
        }
        n = HtmlUtils.addToBuffer(writer, cArray, n, n2, DEC_REF_START);
        int n4 = n3;
        if (n4 > 10000) {
            n = HtmlUtils.addToBuffer(writer, cArray, n, n2, (char)(48 + n4 / 10000));
            n = HtmlUtils.addToBuffer(writer, cArray, n, n2, (char)(48 + (n4 %= 10000) / 1000));
            n = HtmlUtils.addToBuffer(writer, cArray, n, n2, (char)(48 + (n4 %= 1000) / 100));
            n = HtmlUtils.addToBuffer(writer, cArray, n, n2, (char)(48 + (n4 %= 100) / 10));
            n = HtmlUtils.addToBuffer(writer, cArray, n, n2, (char)(48 + (n4 %= 10)));
        } else if (n4 > 1000) {
            n = HtmlUtils.addToBuffer(writer, cArray, n, n2, (char)(48 + n4 / 1000));
            n = HtmlUtils.addToBuffer(writer, cArray, n, n2, (char)(48 + (n4 %= 1000) / 100));
            n = HtmlUtils.addToBuffer(writer, cArray, n, n2, (char)(48 + (n4 %= 100) / 10));
            n = HtmlUtils.addToBuffer(writer, cArray, n, n2, (char)(48 + (n4 %= 10)));
        } else {
            n = HtmlUtils.addToBuffer(writer, cArray, n, n2, (char)(48 + n4 / 100));
            n = HtmlUtils.addToBuffer(writer, cArray, n, n2, (char)(48 + (n4 %= 100) / 10));
            n = HtmlUtils.addToBuffer(writer, cArray, n, n2, (char)(48 + (n4 %= 10)));
        }
        return HtmlUtils.addToBuffer(writer, cArray, n, n2, ';');
    }

    private static int addToBuffer(Writer writer, char[] cArray, int n, int n2, char c) throws IOException {
        if (n >= n2) {
            writer.write(cArray, 0, n);
            n = 0;
        }
        cArray[n] = c;
        return n + 1;
    }

    private static int addToBuffer(Writer writer, char[] cArray, int n, int n2, char[] cArray2) throws IOException {
        if (n >= n2 || cArray2.length + n >= n2) {
            writer.write(cArray, 0, n);
            n = 0;
        }
        System.arraycopy(cArray2, 0, cArray, n, cArray2.length);
        return n + cArray2.length;
    }

    private static int flushBuffer(Writer writer, char[] cArray, int n) throws IOException {
        if (n > 0) {
            writer.write(cArray, 0, n);
        }
        return 0;
    }

    private HtmlUtils() {
    }

    public static void writeURL(Writer writer, String string, char[] cArray, String string2) throws IOException, UnsupportedEncodingException {
        int n = string.length();
        if (n >= 16) {
            string.getChars(0, n, cArray, 0);
            HtmlUtils.writeURL(writer, cArray, 0, n, string2);
        } else {
            for (int i = 0; i < n; ++i) {
                char c = string.charAt(i);
                if (c < '!' || c > '~') {
                    if (c == ' ') {
                        writer.write(43);
                        continue;
                    }
                    HtmlUtils.writeURIDoubleHex(writer, c);
                    continue;
                }
                if (c == '\"') {
                    writer.write("%22");
                    continue;
                }
                if (c == '?') {
                    writer.write(63);
                    HtmlUtils.encodeURIString(writer, string, string2, i + 1);
                    return;
                }
                writer.write(c);
            }
        }
    }

    public static void writeURL(Writer writer, char[] cArray, int n, int n2, String string) throws IOException, UnsupportedEncodingException {
        int n3 = n + n2;
        for (int i = n; i < n3; ++i) {
            char c = cArray[i];
            if (c < '!' || c > '~') {
                if (c == ' ') {
                    writer.write(43);
                    continue;
                }
                HtmlUtils.writeURIDoubleHex(writer, c);
                continue;
            }
            if (c == '\"') {
                writer.write("%22");
                continue;
            }
            if (c == '?') {
                writer.write(63);
                HtmlUtils.encodeURIString(writer, cArray, string, i + 1, n3);
                return;
            }
            writer.write(c);
        }
    }

    public static void writeTextForXML(Writer writer, String string, char[] cArray) throws IOException {
        char[] cArray2 = new char[128];
        int n = string.toString().length();
        if (cArray2.length < n) {
            cArray2 = new char[n * 2];
        }
        HtmlUtils.writeText(writer, true, true, cArray, string, cArray2);
    }

    private static void encodeURIString(Writer writer, String string, String string2, int n) throws IOException {
        MyByteArrayOutputStream myByteArrayOutputStream = null;
        OutputStreamWriter outputStreamWriter = null;
        char[] cArray = null;
        int n2 = string.length();
        for (int i = n; i < n2; ++i) {
            char c = string.charAt(i);
            if (DONT_ENCODE_SET.get(c)) {
                if (c == '&') {
                    if (i + 1 < n2 && HtmlUtils.isAmpEscaped(string, i + 1)) {
                        writer.write(c);
                        continue;
                    }
                    writer.write(AMP_CHARS);
                    continue;
                }
                writer.write(c);
                continue;
            }
            if (myByteArrayOutputStream == null) {
                myByteArrayOutputStream = new MyByteArrayOutputStream(10);
                outputStreamWriter = string2 != null ? new OutputStreamWriter((OutputStream)myByteArrayOutputStream, string2) : new OutputStreamWriter(myByteArrayOutputStream);
                cArray = new char[1];
            }
            try {
                cArray[0] = c;
                outputStreamWriter.write(cArray, 0, 1);
                outputStreamWriter.flush();
            }
            catch (IOException iOException) {
                myByteArrayOutputStream.reset();
                continue;
            }
            byte[] byArray = myByteArrayOutputStream.getBuf();
            int n3 = myByteArrayOutputStream.size();
            for (int j = 0; j < n3; ++j) {
                HtmlUtils.writeURIDoubleHex(writer, byArray[j] + 256);
            }
            myByteArrayOutputStream.reset();
        }
    }

    private static void encodeURIString(Writer writer, char[] cArray, String string, int n, int n2) throws IOException {
        MyByteArrayOutputStream myByteArrayOutputStream = null;
        OutputStreamWriter outputStreamWriter = null;
        char[] cArray2 = null;
        for (int i = n; i < n2; ++i) {
            char c = cArray[i];
            if (DONT_ENCODE_SET.get(c)) {
                if (c == '&') {
                    if (i + 1 < n2 && HtmlUtils.isAmpEscaped(cArray, i + 1)) {
                        writer.write(c);
                        continue;
                    }
                    writer.write(AMP_CHARS);
                    continue;
                }
                writer.write(c);
                continue;
            }
            if (myByteArrayOutputStream == null) {
                myByteArrayOutputStream = new MyByteArrayOutputStream(10);
                outputStreamWriter = string != null ? new OutputStreamWriter((OutputStream)myByteArrayOutputStream, string) : new OutputStreamWriter(myByteArrayOutputStream);
                cArray2 = new char[1];
            }
            try {
                cArray2[0] = c;
                outputStreamWriter.write(cArray2, 0, 1);
                outputStreamWriter.flush();
            }
            catch (IOException iOException) {
                myByteArrayOutputStream.reset();
                continue;
            }
            byte[] byArray = myByteArrayOutputStream.getBuf();
            int n3 = myByteArrayOutputStream.size();
            for (int j = 0; j < n3; ++j) {
                HtmlUtils.writeURIDoubleHex(writer, byArray[j] + 256);
            }
            myByteArrayOutputStream.reset();
        }
    }

    private static boolean isAmpEscaped(String string, int n) {
        int n2 = 1;
        int n3 = n;
        while (n2 < AMP_CHARS.length) {
            if (string.charAt(n3) != AMP_CHARS[n2]) {
                return false;
            }
            ++n2;
            ++n3;
        }
        return true;
    }

    private static boolean isAmpEscaped(char[] cArray, int n) {
        int n2 = 1;
        int n3 = n;
        while (n2 < AMP_CHARS.length) {
            if (cArray[n3] != AMP_CHARS[n2]) {
                return false;
            }
            ++n2;
            ++n3;
        }
        return true;
    }

    private static void writeURIDoubleHex(Writer writer, int n) throws IOException {
        writer.write(37);
        writer.write(HtmlUtils.intToHex((n >> 4) % 16));
        writer.write(HtmlUtils.intToHex(n % 16));
    }

    private static char intToHex(int n) {
        if (n < 10) {
            return (char)(48 + n);
        }
        return (char)(65 + (n - 10));
    }

    public static boolean validateEncoding(String string) {
        return Charset.isSupported(string);
    }

    public static boolean isISO8859_1encoding(String string) {
        return "ISO-8859-1".equals(string);
    }

    public static boolean isUTFencoding(String string) {
        return UTF_CHARSET.contains(string);
    }

    public static boolean isEmptyElement(String string) {
        char c = string.charAt(0);
        if (c > _LAST_EMPTY_ELEMENT_START) {
            return false;
        }
        String[] stringArray = emptyElementArr[c];
        if (stringArray != null) {
            for (int i = stringArray.length - 1; i >= 0; --i) {
                if (!string.equalsIgnoreCase(stringArray[i])) continue;
                return true;
            }
        }
        return false;
    }

    static {
        int n;
        UTF_CHARSET = new HashSet<String>(Arrays.asList("UTF-8", "UTF-16", "UTF-16BE", "UTF-16LE", "UTF-32", "UTF-32BE", "UTF-32LE", "x-UTF-16LE-BOM", "X-UTF-32BE-BOM", "X-UTF-32LE-BOM", ""));
        AMP_CHARS = "&amp;".toCharArray();
        QUOT_CHARS = "&quot;".toCharArray();
        GT_CHARS = "&gt;".toCharArray();
        LT_CHARS = "&lt;".toCharArray();
        EURO_CHARS = "&euro;".toCharArray();
        DEC_REF_START = "&#".toCharArray();
        DONT_ENCODE_SET = new BitSet(256);
        for (n = 97; n <= 122; ++n) {
            DONT_ENCODE_SET.set(n);
        }
        for (n = 65; n <= 90; ++n) {
            DONT_ENCODE_SET.set(n);
        }
        for (n = 48; n <= 57; ++n) {
            DONT_ENCODE_SET.set(n);
        }
        DONT_ENCODE_SET.set(37);
        DONT_ENCODE_SET.set(43);
        DONT_ENCODE_SET.set(35);
        DONT_ENCODE_SET.set(38);
        DONT_ENCODE_SET.set(61);
        DONT_ENCODE_SET.set(45);
        DONT_ENCODE_SET.set(95);
        DONT_ENCODE_SET.set(46);
        DONT_ENCODE_SET.set(42);
        DONT_ENCODE_SET.set(126);
        DONT_ENCODE_SET.set(47);
        DONT_ENCODE_SET.set(39);
        DONT_ENCODE_SET.set(33);
        DONT_ENCODE_SET.set(40);
        DONT_ENCODE_SET.set(41);
        DONT_ENCODE_SET.set(59);
        sISO8859_1_Entities = new char[][]{"&nbsp;".toCharArray(), "&iexcl;".toCharArray(), "&cent;".toCharArray(), "&pound;".toCharArray(), "&curren;".toCharArray(), "&yen;".toCharArray(), "&brvbar;".toCharArray(), "&sect;".toCharArray(), "&uml;".toCharArray(), "&copy;".toCharArray(), "&ordf;".toCharArray(), "&laquo;".toCharArray(), "&not;".toCharArray(), "&shy;".toCharArray(), "&reg;".toCharArray(), "&macr;".toCharArray(), "&deg;".toCharArray(), "&plusmn;".toCharArray(), "&sup2;".toCharArray(), "&sup3;".toCharArray(), "&acute;".toCharArray(), "&micro;".toCharArray(), "&para;".toCharArray(), "&middot;".toCharArray(), "&cedil;".toCharArray(), "&sup1;".toCharArray(), "&ordm;".toCharArray(), "&raquo;".toCharArray(), "&frac14;".toCharArray(), "&frac12;".toCharArray(), "&frac34;".toCharArray(), "&iquest;".toCharArray(), "&Agrave;".toCharArray(), "&Aacute;".toCharArray(), "&Acirc;".toCharArray(), "&Atilde;".toCharArray(), "&Auml;".toCharArray(), "&Aring;".toCharArray(), "&AElig;".toCharArray(), "&Ccedil;".toCharArray(), "&Egrave;".toCharArray(), "&Eacute;".toCharArray(), "&Ecirc;".toCharArray(), "&Euml;".toCharArray(), "&Igrave;".toCharArray(), "&Iacute;".toCharArray(), "&Icirc;".toCharArray(), "&Iuml;".toCharArray(), "&ETH;".toCharArray(), "&Ntilde;".toCharArray(), "&Ograve;".toCharArray(), "&Oacute;".toCharArray(), "&Ocirc;".toCharArray(), "&Otilde;".toCharArray(), "&Ouml;".toCharArray(), "&times;".toCharArray(), "&Oslash;".toCharArray(), "&Ugrave;".toCharArray(), "&Uacute;".toCharArray(), "&Ucirc;".toCharArray(), "&Uuml;".toCharArray(), "&Yacute;".toCharArray(), "&THORN;".toCharArray(), "&szlig;".toCharArray(), "&agrave;".toCharArray(), "&aacute;".toCharArray(), "&acirc;".toCharArray(), "&atilde;".toCharArray(), "&auml;".toCharArray(), "&aring;".toCharArray(), "&aelig;".toCharArray(), "&ccedil;".toCharArray(), "&egrave;".toCharArray(), "&eacute;".toCharArray(), "&ecirc;".toCharArray(), "&euml;".toCharArray(), "&igrave;".toCharArray(), "&iacute;".toCharArray(), "&icirc;".toCharArray(), "&iuml;".toCharArray(), "&eth;".toCharArray(), "&ntilde;".toCharArray(), "&ograve;".toCharArray(), "&oacute;".toCharArray(), "&ocirc;".toCharArray(), "&otilde;".toCharArray(), "&ouml;".toCharArray(), "&divide;".toCharArray(), "&oslash;".toCharArray(), "&ugrave;".toCharArray(), "&uacute;".toCharArray(), "&ucirc;".toCharArray(), "&uuml;".toCharArray(), "&yacute;".toCharArray(), "&thorn;".toCharArray(), "&yuml;".toCharArray()};
        _LAST_EMPTY_ELEMENT_START = (char)112;
        emptyElementArr = new String[_LAST_EMPTY_ELEMENT_START + '\u0001'][];
        aNames = new String[]{"area"};
        bNames = new String[]{"br", "base", "basefont"};
        cNames = new String[]{"col"};
        fNames = new String[]{"frame"};
        hNames = new String[]{"hr"};
        iNames = new String[]{"img", "input", "isindex"};
        lNames = new String[]{"link"};
        mNames = new String[]{"meta"};
        pNames = new String[]{"param"};
        HtmlUtils.emptyElementArr[97] = aNames;
        HtmlUtils.emptyElementArr[65] = aNames;
        HtmlUtils.emptyElementArr[98] = bNames;
        HtmlUtils.emptyElementArr[66] = bNames;
        HtmlUtils.emptyElementArr[99] = cNames;
        HtmlUtils.emptyElementArr[67] = cNames;
        HtmlUtils.emptyElementArr[102] = fNames;
        HtmlUtils.emptyElementArr[70] = fNames;
        HtmlUtils.emptyElementArr[104] = hNames;
        HtmlUtils.emptyElementArr[72] = hNames;
        HtmlUtils.emptyElementArr[105] = iNames;
        HtmlUtils.emptyElementArr[73] = iNames;
        HtmlUtils.emptyElementArr[108] = lNames;
        HtmlUtils.emptyElementArr[76] = lNames;
        HtmlUtils.emptyElementArr[109] = mNames;
        HtmlUtils.emptyElementArr[77] = mNames;
        HtmlUtils.emptyElementArr[112] = pNames;
        HtmlUtils.emptyElementArr[80] = pNames;
    }

    private static class MyByteArrayOutputStream
    extends ByteArrayOutputStream {
        public MyByteArrayOutputStream(int n) {
            super(n);
        }

        public byte[] getBuf() {
            return this.buf;
        }
    }
}

