/*
 * Decompiled with CFR 0.152.
 */
package com.sun.faces.spi;

import com.sun.faces.config.WebConfiguration;
import com.sun.faces.spi.AnnotationScanner;
import com.sun.faces.spi.DiscoverableInjectionProvider;
import com.sun.faces.spi.InjectionProvider;
import com.sun.faces.spi.InjectionProviderException;
import com.sun.faces.util.FacesLogger;
import com.sun.faces.util.Util;
import com.sun.faces.vendor.WebContainerInjectionProvider;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.faces.context.ExternalContext;
import javax.servlet.ServletContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InjectionProviderFactory {
    private static final InjectionProvider NOOP_PROVIDER = new NoopInjectionProvider();
    private static final InjectionProvider GENERIC_WEB_PROVIDER = new WebContainerInjectionProvider();
    private static final String INJECTION_SERVICE = "META-INF/services/com.sun.faces.spi.injectionprovider";
    private static final String INJECTION_PROVIDER_PROPERTY = "com.sun.faces.InjectionProvider";
    private static final Logger LOGGER = FacesLogger.APPLICATION.getLogger();
    private static final String[] EMPTY_ARRAY = new String[0];

    public static InjectionProvider createInstance(ExternalContext externalContext) {
        String string = InjectionProviderFactory.findProviderClass(externalContext);
        InjectionProvider injectionProvider = InjectionProviderFactory.getProviderInstance(string, externalContext);
        if (!NoopInjectionProvider.class.equals(injectionProvider.getClass()) && !WebContainerInjectionProvider.class.equals(injectionProvider.getClass())) {
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.log(Level.FINE, "jsf.spi.injection.provider_configured", new Object[]{injectionProvider.getClass().getName()});
            }
            return injectionProvider;
        }
        if (WebContainerInjectionProvider.class.equals(injectionProvider.getClass())) {
            if (LOGGER.isLoggable(Level.INFO)) {
                LOGGER.info("jsf.core.injection.provider_generic_web_configured");
            }
            return injectionProvider;
        }
        if (LOGGER.isLoggable(Level.WARNING)) {
            LOGGER.log(Level.WARNING, "jsf.spi.injection.no_injection");
        }
        return injectionProvider;
    }

    private static InjectionProvider getProviderInstance(String string, ExternalContext externalContext) {
        InjectionProvider injectionProvider;
        block18: {
            injectionProvider = NOOP_PROVIDER;
            if (string != null) {
                try {
                    Class clazz = Util.loadClass(string, InjectionProviderFactory.class);
                    if (InjectionProviderFactory.implementsInjectionProvider(clazz)) {
                        try {
                            Constructor constructor = clazz.getConstructor(ServletContext.class);
                            return (InjectionProvider)constructor.newInstance((ServletContext)externalContext.getContext());
                        }
                        catch (NoSuchMethodException noSuchMethodException) {
                            return (InjectionProvider)clazz.newInstance();
                        }
                        catch (InvocationTargetException invocationTargetException) {
                            if (LOGGER.isLoggable(Level.SEVERE)) {
                                LOGGER.log(Level.SEVERE, "jsf.spi.injection.provider_cannot_instantiate", new Object[]{string});
                                LOGGER.log(Level.SEVERE, "", invocationTargetException);
                            }
                        }
                    } else if (LOGGER.isLoggable(Level.SEVERE)) {
                        LOGGER.log(Level.SEVERE, "jsf.spi.injection.provider_not_implemented", new Object[]{string});
                    }
                }
                catch (ClassNotFoundException classNotFoundException) {
                    if (LOGGER.isLoggable(Level.SEVERE)) {
                        LOGGER.log(Level.SEVERE, "jsf.spi.injection.provider_not_found", new Object[]{string});
                    }
                }
                catch (InstantiationException instantiationException) {
                    if (LOGGER.isLoggable(Level.SEVERE)) {
                        LOGGER.log(Level.SEVERE, "jsf.spi.injection.provider_cannot_instantiate", new Object[]{string});
                        LOGGER.log(Level.SEVERE, "", instantiationException);
                    }
                }
                catch (IllegalAccessException illegalAccessException) {
                    if (!LOGGER.isLoggable(Level.SEVERE)) break block18;
                    LOGGER.log(Level.SEVERE, "jsf.spi.injection.provider_cannot_instantiate", new Object[]{string});
                    LOGGER.log(Level.SEVERE, "", illegalAccessException);
                }
            }
        }
        if (NOOP_PROVIDER.equals(injectionProvider)) {
            try {
                if (Util.loadClass("javax.annotation.PostConstruct", null) != null && Util.loadClass("javax.annotation.PreDestroy", null) != null) {
                    injectionProvider = GENERIC_WEB_PROVIDER;
                }
            }
            catch (Exception exception) {
                injectionProvider = NOOP_PROVIDER;
            }
        }
        return injectionProvider;
    }

    private static boolean implementsInjectionProvider(Class<?> clazz) {
        return InjectionProvider.class.isAssignableFrom(clazz);
    }

    private static boolean extendsDiscoverableInjectionProvider(Class<?> clazz) {
        return DiscoverableInjectionProvider.class.isAssignableFrom(clazz);
    }

    private static String findProviderClass(ExternalContext externalContext) {
        WebConfiguration webConfiguration = WebConfiguration.getInstance(externalContext);
        String string = webConfiguration.getOptionValue(WebConfiguration.WebContextInitParameter.InjectionProviderClass);
        if (string != null) {
            return string;
        }
        string = System.getProperty(INJECTION_PROVIDER_PROPERTY);
        if (string != null) {
            return string;
        }
        String[] stringArray = InjectionProviderFactory.getServiceEntries();
        if (stringArray.length > 0) {
            for (int i = 0; i < stringArray.length && (string = InjectionProviderFactory.getProviderFromEntry(stringArray[i])) == null; ++i) {
            }
        } else {
            return string;
        }
        return string;
    }

    private static String getProviderFromEntry(String string) {
        block9: {
            if (string == null) {
                return null;
            }
            String[] stringArray = Util.split(string, ":");
            if (stringArray.length != 2) {
                if (LOGGER.isLoggable(Level.SEVERE)) {
                    LOGGER.log(Level.SEVERE, "jsf.spi.injection.invalid_service_entry", new Object[]{string});
                }
                return null;
            }
            try {
                Class clazz = Util.loadClass(stringArray[0], null);
                if (InjectionProviderFactory.extendsDiscoverableInjectionProvider(clazz)) {
                    if (DiscoverableInjectionProvider.isInjectionFeatureAvailable(stringArray[1])) {
                        return stringArray[0];
                    }
                    break block9;
                }
                if (LOGGER.isLoggable(Level.SEVERE)) {
                    LOGGER.log(Level.SEVERE, "jsf.spi.injection.provider.entry_not_discoverable", new Object[]{stringArray[0]});
                }
                return null;
            }
            catch (ClassNotFoundException classNotFoundException) {
                if (LOGGER.isLoggable(Level.SEVERE)) {
                    LOGGER.log(Level.SEVERE, "jsf.spi.injection.provider_not_found", new Object[]{stringArray[0]});
                }
                return null;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String[] getServiceEntries() {
        Enumeration<URL> enumeration;
        ArrayList<String> arrayList;
        block27: {
            arrayList = null;
            ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
            if (classLoader == null) {
                return EMPTY_ARRAY;
            }
            enumeration = null;
            try {
                enumeration = classLoader.getResources(INJECTION_SERVICE);
            }
            catch (IOException iOException) {
                if (!LOGGER.isLoggable(Level.SEVERE)) break block27;
                LOGGER.log(Level.SEVERE, iOException.toString(), iOException);
            }
        }
        if (enumeration != null) {
            InputStream inputStream = null;
            BufferedReader bufferedReader = null;
            while (enumeration.hasMoreElements()) {
                try {
                    if (arrayList == null) {
                        arrayList = new ArrayList<String>();
                    }
                    URL uRL = enumeration.nextElement();
                    URLConnection uRLConnection = uRL.openConnection();
                    uRLConnection.setUseCaches(false);
                    inputStream = uRLConnection.getInputStream();
                    if (inputStream == null) continue;
                    try {
                        bufferedReader = new BufferedReader(new InputStreamReader(inputStream, "UTF-8"));
                    }
                    catch (Exception exception) {
                        bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
                    }
                    String string = bufferedReader.readLine();
                    while (string != null) {
                        arrayList.add(string.trim());
                        string = bufferedReader.readLine();
                    }
                }
                catch (Exception exception) {
                    if (!LOGGER.isLoggable(Level.SEVERE)) continue;
                    LOGGER.log(Level.SEVERE, "jsf.spi.provider.cannot_read_service", new Object[]{INJECTION_SERVICE});
                    LOGGER.log(Level.SEVERE, exception.toString(), exception);
                }
                finally {
                    if (inputStream != null) {
                        try {
                            inputStream.close();
                        }
                        catch (Exception exception) {}
                    }
                    if (bufferedReader == null) continue;
                    try {
                        bufferedReader.close();
                    }
                    catch (Exception exception) {}
                }
            }
        }
        return arrayList != null && !arrayList.isEmpty() ? arrayList.toArray(new String[arrayList.size()]) : EMPTY_ARRAY;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class NoopInjectionProvider
    implements InjectionProvider,
    AnnotationScanner {
        private NoopInjectionProvider() {
        }

        @Override
        public void inject(Object object) {
        }

        @Override
        public Map<String, List<AnnotationScanner.ScannedAnnotation>> getAnnotatedClassesInCurrentModule(ServletContext servletContext) throws InjectionProviderException {
            return Collections.emptyMap();
        }

        @Override
        public void invokePreDestroy(Object object) {
        }

        @Override
        public void invokePostConstruct(Object object) throws InjectionProviderException {
        }
    }
}

