/*
 * Decompiled with CFR 0.152.
 */
package com.sun.faces.renderkit.html_basic;

import com.sun.faces.renderkit.RenderKitUtils;
import com.sun.faces.util.FacesLogger;
import java.util.Collection;
import java.util.LinkedList;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.faces.FacesException;
import javax.faces.component.ActionSource;
import javax.faces.component.EditableValueHolder;
import javax.faces.component.UIComponent;
import javax.faces.component.behavior.AjaxBehavior;
import javax.faces.component.behavior.Behavior;
import javax.faces.component.behavior.ClientBehavior;
import javax.faces.component.behavior.ClientBehaviorContext;
import javax.faces.context.FacesContext;
import javax.faces.event.AjaxBehaviorEvent;
import javax.faces.event.FacesEvent;
import javax.faces.event.PhaseId;
import javax.faces.render.ClientBehaviorRenderer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AjaxBehaviorRenderer
extends ClientBehaviorRenderer {
    protected static final Logger logger = FacesLogger.RENDERKIT.getLogger();

    public String getScript(ClientBehaviorContext clientBehaviorContext, ClientBehavior clientBehavior) {
        if (!(clientBehavior instanceof AjaxBehavior)) {
            throw new IllegalArgumentException("Instance of javax.faces.component.behavior.AjaxBehavior required: " + clientBehavior);
        }
        return AjaxBehaviorRenderer.buildAjaxCommand(clientBehaviorContext, (AjaxBehavior)clientBehavior);
    }

    public void decode(FacesContext facesContext, UIComponent uIComponent, ClientBehavior clientBehavior) {
        if (null == facesContext || null == uIComponent || null == clientBehavior) {
            throw new NullPointerException();
        }
        if (!(clientBehavior instanceof AjaxBehavior)) {
            throw new IllegalArgumentException("Instance of javax.faces.component.behavior.AjaxBehavior required: " + clientBehavior);
        }
        AjaxBehavior ajaxBehavior = (AjaxBehavior)clientBehavior;
        if (ajaxBehavior.isDisabled()) {
            return;
        }
        uIComponent.queueEvent((FacesEvent)AjaxBehaviorRenderer.createEvent(uIComponent, ajaxBehavior));
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("This command resulted in form submission  AjaxBehaviorEvent queued.");
            logger.log(Level.FINE, "End decoding component {0}", uIComponent.getId());
        }
    }

    private static AjaxBehaviorEvent createEvent(UIComponent uIComponent, AjaxBehavior ajaxBehavior) {
        AjaxBehaviorEvent ajaxBehaviorEvent = new AjaxBehaviorEvent(uIComponent, (Behavior)ajaxBehavior);
        PhaseId phaseId = AjaxBehaviorRenderer.isImmediate(uIComponent, ajaxBehavior) ? PhaseId.APPLY_REQUEST_VALUES : PhaseId.INVOKE_APPLICATION;
        ajaxBehaviorEvent.setPhaseId(phaseId);
        return ajaxBehaviorEvent;
    }

    private static boolean isImmediate(UIComponent uIComponent, AjaxBehavior ajaxBehavior) {
        boolean bl = false;
        if (ajaxBehavior.isImmediateSet()) {
            bl = ajaxBehavior.isImmediate();
        } else if (uIComponent instanceof EditableValueHolder) {
            bl = ((EditableValueHolder)uIComponent).isImmediate();
        } else if (uIComponent instanceof ActionSource) {
            bl = ((ActionSource)uIComponent).isImmediate();
        }
        return bl;
    }

    private static String buildAjaxCommand(ClientBehaviorContext clientBehaviorContext, AjaxBehavior ajaxBehavior) {
        if (ajaxBehavior.isDisabled()) {
            return null;
        }
        UIComponent uIComponent = clientBehaviorContext.getComponent();
        String string = clientBehaviorContext.getEventName();
        StringBuilder stringBuilder = new StringBuilder(256);
        LinkedList<String> linkedList = ajaxBehavior.getExecute();
        Collection collection = ajaxBehavior.getRender();
        String string2 = ajaxBehavior.getOnevent();
        String string3 = ajaxBehavior.getOnerror();
        String string4 = clientBehaviorContext.getSourceId();
        Collection collection2 = clientBehaviorContext.getParameters();
        ClientBehaviorContext.Parameter parameter = null;
        for (ClientBehaviorContext.Parameter parameter2 : collection2) {
            if (!parameter2.getName().equals("incExec") || !((Boolean)parameter2.getValue()).booleanValue()) continue;
            parameter = parameter2;
        }
        if (parameter != null && !linkedList.contains(string4)) {
            linkedList = new LinkedList<String>(linkedList);
            linkedList.add(uIComponent.getClientId());
        }
        if (parameter != null) {
            try {
                collection2.remove(parameter);
            }
            catch (UnsupportedOperationException unsupportedOperationException) {
                // empty catch block
            }
        }
        stringBuilder.append("mojarra.ab(");
        if (string4 == null) {
            stringBuilder.append("this");
        } else {
            stringBuilder.append("'");
            stringBuilder.append(string4);
            stringBuilder.append("'");
        }
        stringBuilder.append(",event,'");
        stringBuilder.append(string);
        stringBuilder.append("',");
        AjaxBehaviorRenderer.appendIds(uIComponent, stringBuilder, linkedList);
        stringBuilder.append(",");
        AjaxBehaviorRenderer.appendIds(uIComponent, stringBuilder, collection);
        if (string2 != null || string3 != null || !collection2.isEmpty()) {
            stringBuilder.append(",{");
            if (string2 != null) {
                RenderKitUtils.appendProperty(stringBuilder, "onevent", string2, false);
            }
            if (string3 != null) {
                RenderKitUtils.appendProperty(stringBuilder, "onerror", string3, false);
            }
            if (!collection2.isEmpty()) {
                for (ClientBehaviorContext.Parameter parameter2 : collection2) {
                    RenderKitUtils.appendProperty(stringBuilder, parameter2.getName(), parameter2.getValue());
                }
            }
            stringBuilder.append("}");
        }
        stringBuilder.append(")");
        return stringBuilder.toString();
    }

    private static void appendIds(UIComponent uIComponent, StringBuilder stringBuilder, Collection<String> collection) {
        if (null == collection || collection.isEmpty()) {
            stringBuilder.append('0');
            return;
        }
        stringBuilder.append("'");
        boolean bl = true;
        for (String string : collection) {
            if (string.trim().length() == 0) continue;
            if (!bl) {
                stringBuilder.append(' ');
            } else {
                bl = false;
            }
            if (string.equals("@all") || string.equals("@none") || string.equals("@form") || string.equals("@this")) {
                stringBuilder.append(string);
                continue;
            }
            stringBuilder.append(AjaxBehaviorRenderer.getResolvedId(uIComponent, string));
        }
        stringBuilder.append("'");
    }

    private static String getResolvedId(UIComponent uIComponent, String string) {
        UIComponent uIComponent2 = uIComponent.findComponent(string);
        if (uIComponent2 == null) {
            throw new FacesException("<f:ajax> contains an unknown id '" + string + "' - cannot locate it in the context of the component " + uIComponent.getId());
        }
        return uIComponent2.getClientId();
    }
}

