/*
 * Decompiled with CFR 0.152.
 */
package com.sun.faces.io;

import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;

public class Base64OutputStreamWriter
extends OutputStream {
    private byte[] buf;
    private char[] chars;
    private int count;
    private int encCount;
    private int totalCharsWritten;
    private Writer writer;
    private static final char[] CA = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/".toCharArray();

    public Base64OutputStreamWriter(int n, Writer writer) {
        if (n < 0) {
            throw new IllegalArgumentException("Negative initial size: " + n);
        }
        this.buf = new byte[n];
        this.chars = new char[n];
        this.totalCharsWritten = 0;
        this.writer = writer;
    }

    public void write(int n) throws IOException {
        throw new UnsupportedOperationException();
    }

    public void write(byte[] byArray, int n, int n2) throws IOException {
        if (n < 0 || n > byArray.length || n2 < 0 || n + n2 > byArray.length || n + n2 < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (n2 == 0) {
            return;
        }
        if (this.count + n2 > this.buf.length) {
            this.encodePendingBytes(false);
        }
        System.arraycopy(byArray, n, this.buf, this.count, n2);
        this.count += n2;
    }

    public void write(byte[] byArray) throws IOException {
        this.write(byArray, 0, byArray.length);
    }

    public void close() throws IOException {
    }

    public void finish() throws IOException {
        this.encodePendingBytes(true);
    }

    public int getTotalCharsWritten() {
        return this.totalCharsWritten;
    }

    private void encodePendingBytes(boolean bl) throws IOException {
        int n;
        int n2 = this.count / 3 * 3;
        int n3 = 0;
        while (n3 < n2) {
            n = (this.buf[n3++] & 0xFF) << 16 | (this.buf[n3++] & 0xFF) << 8 | this.buf[n3++] & 0xFF;
            if (this.encCount + 4 > this.chars.length) {
                this.drainCharBuffer();
            }
            this.chars[this.encCount++] = CA[n >>> 18 & 0x3F];
            this.chars[this.encCount++] = CA[n >>> 12 & 0x3F];
            this.chars[this.encCount++] = CA[n >>> 6 & 0x3F];
            this.chars[this.encCount++] = CA[n & 0x3F];
        }
        n3 = this.count - n2;
        if (!bl) {
            System.arraycopy(this.buf, n2, this.buf, 0, n3);
            this.count = n3;
        } else {
            this.drainCharBuffer();
            if (n3 > 0) {
                n = (this.buf[n2] & 0xFF) << 10 | (n3 == 2 ? (this.buf[this.count - 1] & 0xFF) << 2 : 0);
                this.writer.write(CA[n >> 12]);
                this.writer.write(CA[n >>> 6 & 0x3F]);
                this.writer.write(n3 == 2 ? CA[n & 0x3F] : 61);
                this.writer.write(61);
            }
        }
    }

    private void drainCharBuffer() throws IOException {
        this.writer.write(this.chars, 0, this.encCount);
        this.totalCharsWritten += this.encCount;
        this.encCount = 0;
    }
}

