/*
 * Decompiled with CFR 0.152.
 */
package com.sun.faces.facelets.tag;

import com.sun.faces.facelets.tag.TagHandlerFactory;
import com.sun.faces.facelets.tag.TagLibrary;
import com.sun.faces.facelets.tag.UserTagHandler;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import javax.el.ELException;
import javax.faces.FacesException;
import javax.faces.view.facelets.BehaviorConfig;
import javax.faces.view.facelets.BehaviorHandler;
import javax.faces.view.facelets.ComponentConfig;
import javax.faces.view.facelets.ComponentHandler;
import javax.faces.view.facelets.ConverterConfig;
import javax.faces.view.facelets.ConverterHandler;
import javax.faces.view.facelets.FaceletException;
import javax.faces.view.facelets.FaceletHandler;
import javax.faces.view.facelets.Tag;
import javax.faces.view.facelets.TagConfig;
import javax.faces.view.facelets.TagHandler;
import javax.faces.view.facelets.ValidatorConfig;
import javax.faces.view.facelets.ValidatorHandler;

public abstract class AbstractTagLibrary
implements TagLibrary {
    private final Map factories;
    private final String namespace;
    private final Map functions;

    public AbstractTagLibrary(String string) {
        this.namespace = string;
        this.factories = new HashMap();
        this.functions = new HashMap();
    }

    protected final void addComponent(String string, String string2, String string3) {
        this.factories.put(string, new ComponentHandlerFactory(string2, string3));
    }

    protected final void addComponent(String string, String string2, String string3, Class clazz) {
        this.factories.put(string, new UserComponentHandlerFactory(string2, string3, clazz));
    }

    protected final void addConverter(String string, String string2) {
        this.factories.put(string, new ConverterHandlerFactory(string2));
    }

    protected final void addConverter(String string, String string2, Class clazz) {
        this.factories.put(string, new UserConverterHandlerFactory(string2, clazz));
    }

    protected final void addValidator(String string, String string2) {
        this.factories.put(string, new ValidatorHandlerFactory(string2));
    }

    protected final void addValidator(String string, String string2, Class clazz) {
        this.factories.put(string, new UserValidatorHandlerFactory(string2, clazz));
    }

    protected final void addBehavior(String string, String string2) {
        this.factories.put(string, new BehaviorHandlerFactory(string2));
    }

    protected final void addBehavior(String string, String string2, Class clazz) {
        this.factories.put(string, new UserBehaviorHandlerFactory(string2, clazz));
    }

    protected final void addTagHandler(String string, Class clazz) {
        this.factories.put(string, new HandlerFactory(clazz));
    }

    protected final void addUserTag(String string, URL uRL) {
        this.factories.put(string, new UserTagFactory(uRL));
    }

    protected final void addFunction(String string, Method method) {
        this.functions.put(string, method);
    }

    public boolean containsNamespace(String string, Tag tag) {
        return this.namespace.equals(string);
    }

    public boolean containsTagHandler(String string, String string2) {
        return this.namespace.equals(string) && this.factories.containsKey(string2);
    }

    public TagHandler createTagHandler(String string, String string2, TagConfig tagConfig) throws FacesException {
        TagHandlerFactory tagHandlerFactory;
        if (this.namespace.equals(string) && (tagHandlerFactory = (TagHandlerFactory)this.factories.get(string2)) != null) {
            return tagHandlerFactory.createHandler(tagConfig);
        }
        return null;
    }

    public boolean containsFunction(String string, String string2) {
        if (this.namespace.equals(string)) {
            return this.functions.containsKey(string2);
        }
        return false;
    }

    public Method createFunction(String string, String string2) {
        if (this.namespace.equals(string)) {
            return (Method)this.functions.get(string2);
        }
        return null;
    }

    public boolean equals(Object object) {
        return object instanceof TagLibrary && object.hashCode() == this.hashCode();
    }

    public int hashCode() {
        return this.namespace.hashCode();
    }

    public String getNamespace() {
        return this.namespace;
    }

    private static class UserBehaviorHandlerFactory
    implements TagHandlerFactory {
        private static final Class[] CONS_SIG = new Class[]{BehaviorConfig.class};
        protected final String behaviorId;
        protected final Class type;
        protected final Constructor constructor;

        public UserBehaviorHandlerFactory(String string, Class clazz) {
            this.behaviorId = string;
            this.type = clazz;
            try {
                this.constructor = this.type.getConstructor(CONS_SIG);
            }
            catch (Exception exception) {
                throw new FaceletException("Must have a Constructor that takes in a BehaviorConfig", (Throwable)exception);
            }
        }

        public TagHandler createHandler(TagConfig tagConfig) throws FacesException, ELException {
            try {
                BehaviorConfigWrapper behaviorConfigWrapper = new BehaviorConfigWrapper(tagConfig, this.behaviorId);
                return (TagHandler)this.constructor.newInstance(behaviorConfigWrapper);
            }
            catch (InvocationTargetException invocationTargetException) {
                throw new FaceletException(invocationTargetException.getCause().getMessage(), invocationTargetException.getCause().getCause());
            }
            catch (Exception exception) {
                throw new FaceletException("Error Instantiating BehaviorHandler: " + this.type.getName(), (Throwable)exception);
            }
        }
    }

    private static class UserValidatorHandlerFactory
    implements TagHandlerFactory {
        private static final Class[] CONS_SIG = new Class[]{ValidatorConfig.class};
        protected final String validatorId;
        protected final Class type;
        protected final Constructor constructor;

        public UserValidatorHandlerFactory(String string, Class clazz) {
            this.validatorId = string;
            this.type = clazz;
            try {
                this.constructor = this.type.getConstructor(CONS_SIG);
            }
            catch (Exception exception) {
                throw new FaceletException("Must have a Constructor that takes in a ValidatorConfig", (Throwable)exception);
            }
        }

        public TagHandler createHandler(TagConfig tagConfig) throws FacesException, ELException {
            try {
                ValidatorConfigWrapper validatorConfigWrapper = new ValidatorConfigWrapper(tagConfig, this.validatorId);
                return (TagHandler)this.constructor.newInstance(validatorConfigWrapper);
            }
            catch (InvocationTargetException invocationTargetException) {
                throw new FaceletException(invocationTargetException.getCause().getMessage(), invocationTargetException.getCause().getCause());
            }
            catch (Exception exception) {
                throw new FaceletException("Error Instantiating ValidatorHandler: " + this.type.getName(), (Throwable)exception);
            }
        }
    }

    private static class UserConverterHandlerFactory
    implements TagHandlerFactory {
        private static final Class[] CONS_SIG = new Class[]{ConverterConfig.class};
        protected final String converterId;
        protected final Class type;
        protected final Constructor constructor;

        public UserConverterHandlerFactory(String string, Class clazz) {
            this.converterId = string;
            this.type = clazz;
            try {
                this.constructor = this.type.getConstructor(CONS_SIG);
            }
            catch (Exception exception) {
                throw new FaceletException("Must have a Constructor that takes in a ConverterConfig", (Throwable)exception);
            }
        }

        public TagHandler createHandler(TagConfig tagConfig) throws FacesException, ELException {
            try {
                ConverterConfigWrapper converterConfigWrapper = new ConverterConfigWrapper(tagConfig, this.converterId);
                return (TagHandler)this.constructor.newInstance(converterConfigWrapper);
            }
            catch (InvocationTargetException invocationTargetException) {
                throw new FaceletException(invocationTargetException.getCause().getMessage(), invocationTargetException.getCause().getCause());
            }
            catch (Exception exception) {
                throw new FaceletException("Error Instantiating ConverterHandler: " + this.type.getName(), (Throwable)exception);
            }
        }
    }

    private static final class BehaviorHandlerFactory
    implements TagHandlerFactory {
        private final String behaviorId;

        public BehaviorHandlerFactory(String string) {
            this.behaviorId = string;
        }

        public TagHandler createHandler(TagConfig tagConfig) throws FacesException, ELException {
            return new BehaviorHandler((BehaviorConfig)new BehaviorConfigWrapper(tagConfig, this.behaviorId));
        }
    }

    private static class ConverterHandlerFactory
    implements TagHandlerFactory {
        protected final String converterId;

        public ConverterHandlerFactory(String string) {
            this.converterId = string;
        }

        public TagHandler createHandler(TagConfig tagConfig) throws FacesException, ELException {
            return new ConverterHandler((ConverterConfig)new ConverterConfigWrapper(tagConfig, this.converterId));
        }
    }

    private static class ValidatorHandlerFactory
    implements TagHandlerFactory {
        protected final String validatorId;

        public ValidatorHandlerFactory(String string) {
            this.validatorId = string;
        }

        public TagHandler createHandler(TagConfig tagConfig) throws FacesException, ELException {
            return new ValidatorHandler((ValidatorConfig)new ValidatorConfigWrapper(tagConfig, this.validatorId));
        }
    }

    private static class UserComponentHandlerFactory
    implements TagHandlerFactory {
        private static final Class[] CONS_SIG = new Class[]{ComponentConfig.class};
        protected final String componentType;
        protected final String renderType;
        protected final Class type;
        protected final Constructor constructor;

        public UserComponentHandlerFactory(String string, String string2, Class clazz) {
            this.componentType = string;
            this.renderType = string2;
            this.type = clazz;
            try {
                this.constructor = this.type.getConstructor(CONS_SIG);
            }
            catch (Exception exception) {
                throw new FaceletException("Must have a Constructor that takes in a ComponentConfig", (Throwable)exception);
            }
        }

        public TagHandler createHandler(TagConfig tagConfig) throws FacesException, ELException {
            try {
                ComponentConfigWrapper componentConfigWrapper = new ComponentConfigWrapper(tagConfig, this.componentType, this.renderType);
                return (TagHandler)this.constructor.newInstance(componentConfigWrapper);
            }
            catch (InvocationTargetException invocationTargetException) {
                throw new FaceletException(invocationTargetException.getCause().getMessage(), invocationTargetException.getCause().getCause());
            }
            catch (Exception exception) {
                throw new FaceletException("Error Instantiating ComponentHandler: " + this.type.getName(), (Throwable)exception);
            }
        }
    }

    private static class ComponentHandlerFactory
    implements TagHandlerFactory {
        protected final String componentType;
        protected final String renderType;

        public ComponentHandlerFactory(String string, String string2) {
            this.componentType = string;
            this.renderType = string2;
        }

        public TagHandler createHandler(TagConfig tagConfig) throws FacesException, ELException {
            ComponentConfigWrapper componentConfigWrapper = new ComponentConfigWrapper(tagConfig, this.componentType, this.renderType);
            return new ComponentHandler((ComponentConfig)componentConfigWrapper);
        }
    }

    private static class UserTagFactory
    implements TagHandlerFactory {
        protected final URL location;

        public UserTagFactory(URL uRL) {
            this.location = uRL;
        }

        public TagHandler createHandler(TagConfig tagConfig) throws FacesException, ELException {
            return new UserTagHandler(tagConfig, this.location);
        }
    }

    protected static class ComponentConfigWrapper
    implements ComponentConfig {
        protected final TagConfig parent;
        protected final String componentType;
        protected final String rendererType;

        public ComponentConfigWrapper(TagConfig tagConfig, String string, String string2) {
            this.parent = tagConfig;
            this.componentType = string;
            this.rendererType = string2;
        }

        public String getComponentType() {
            return this.componentType;
        }

        public String getRendererType() {
            return this.rendererType;
        }

        public FaceletHandler getNextHandler() {
            return this.parent.getNextHandler();
        }

        public Tag getTag() {
            return this.parent.getTag();
        }

        public String getTagId() {
            return this.parent.getTagId();
        }
    }

    private static class HandlerFactory
    implements TagHandlerFactory {
        private static final Class[] CONSTRUCTOR_SIG = new Class[]{TagConfig.class};
        protected final Class handlerType;

        public HandlerFactory(Class clazz) {
            this.handlerType = clazz;
        }

        public TagHandler createHandler(TagConfig tagConfig) throws FacesException, ELException {
            try {
                return (TagHandler)this.handlerType.getConstructor(CONSTRUCTOR_SIG).newInstance(tagConfig);
            }
            catch (InvocationTargetException invocationTargetException) {
                Throwable throwable = invocationTargetException.getCause();
                if (throwable instanceof FacesException) {
                    throw (FacesException)throwable;
                }
                if (throwable instanceof ELException) {
                    throw (ELException)throwable;
                }
                throw new FacesException("Error Instantiating: " + this.handlerType.getName(), throwable);
            }
            catch (Exception exception) {
                throw new FacesException("Error Instantiating: " + this.handlerType.getName(), (Throwable)exception);
            }
        }
    }

    private static final class BehaviorConfigWrapper
    implements BehaviorConfig {
        private final TagConfig parent;
        private final String behaviorId;

        public BehaviorConfigWrapper(TagConfig tagConfig, String string) {
            this.parent = tagConfig;
            this.behaviorId = string;
        }

        public String getBehaviorId() {
            return this.behaviorId;
        }

        public FaceletHandler getNextHandler() {
            return this.parent.getNextHandler();
        }

        public Tag getTag() {
            return this.parent.getTag();
        }

        public String getTagId() {
            return this.parent.getTagId();
        }
    }

    private static class ConverterConfigWrapper
    implements ConverterConfig {
        private final TagConfig parent;
        private final String converterId;

        public ConverterConfigWrapper(TagConfig tagConfig, String string) {
            this.parent = tagConfig;
            this.converterId = string;
        }

        public String getConverterId() {
            return this.converterId;
        }

        public FaceletHandler getNextHandler() {
            return this.parent.getNextHandler();
        }

        public Tag getTag() {
            return this.parent.getTag();
        }

        public String getTagId() {
            return this.parent.getTagId();
        }
    }

    private static class ValidatorConfigWrapper
    implements ValidatorConfig {
        private final TagConfig parent;
        private final String validatorId;

        public ValidatorConfigWrapper(TagConfig tagConfig, String string) {
            this.parent = tagConfig;
            this.validatorId = string;
        }

        public String getValidatorId() {
            return this.validatorId;
        }

        public FaceletHandler getNextHandler() {
            return this.parent.getNextHandler();
        }

        public Tag getTag() {
            return this.parent.getTag();
        }

        public String getTagId() {
            return this.parent.getTagId();
        }
    }
}

