/*
 * Decompiled with CFR 0.152.
 */
package com.sun.faces.facelets.impl;

import com.sun.faces.context.FacesFileNotFoundException;
import com.sun.faces.facelets.Facelet;
import com.sun.faces.facelets.FaceletFactory;
import com.sun.faces.facelets.compiler.Compiler;
import com.sun.faces.facelets.impl.DefaultFacelet;
import com.sun.faces.facelets.impl.IdMapper;
import com.sun.faces.util.Cache;
import com.sun.faces.util.FacesLogger;
import com.sun.faces.util.Util;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import javax.faces.FacesException;
import javax.faces.view.facelets.FaceletCache;
import javax.faces.view.facelets.FaceletHandler;
import javax.faces.view.facelets.ResourceResolver;

public class DefaultFaceletFactory
extends FaceletFactory {
    protected static final Logger log = FacesLogger.FACELETS_FACTORY.getLogger();
    private final Compiler compiler;
    private Map<String, URL> relativeLocations;
    private final ResourceResolver resolver;
    private final URL baseUrl;
    private final long refreshPeriod;
    private final FaceletCache<DefaultFacelet> cache;
    Cache<String, IdMapper> idMappers;

    public DefaultFaceletFactory(Compiler compiler, ResourceResolver resourceResolver) throws IOException {
        this(compiler, resourceResolver, -1L, null);
    }

    public DefaultFaceletFactory(Compiler compiler, ResourceResolver resourceResolver, long l) {
        this(compiler, resourceResolver, l, null);
    }

    public DefaultFaceletFactory(Compiler compiler, ResourceResolver resourceResolver, long l, FaceletCache faceletCache) {
        Util.notNull("compiler", compiler);
        Util.notNull("resolver", resourceResolver);
        this.compiler = compiler;
        this.relativeLocations = new ConcurrentHashMap<String, URL>();
        this.resolver = resourceResolver;
        this.baseUrl = resourceResolver.resolveUrl("/");
        this.idMappers = new Cache<String, IdMapper>(new IdMapperFactory());
        this.refreshPeriod = l = l >= 0L ? l * 1000L : -1L;
        if (log.isLoggable(Level.FINE)) {
            log.log(Level.FINE, "Using ResourceResolver: {0}", resourceResolver);
            log.log(Level.FINE, "Using Refresh Period: {0}", l);
        }
        this.cache = faceletCache;
        FaceletCache.MemberFactory<DefaultFacelet> memberFactory = new FaceletCache.MemberFactory<DefaultFacelet>(){

            public DefaultFacelet newInstance(URL uRL) throws IOException {
                return DefaultFaceletFactory.this.createFacelet(uRL);
            }
        };
        FaceletCache.MemberFactory<DefaultFacelet> memberFactory2 = new FaceletCache.MemberFactory<DefaultFacelet>(){

            public DefaultFacelet newInstance(URL uRL) throws IOException {
                return DefaultFaceletFactory.this.createMetadataFacelet(uRL);
            }
        };
        try {
            Method method = FaceletCache.class.getDeclaredMethod("setMemberFactories", FaceletCache.MemberFactory.class, FaceletCache.MemberFactory.class);
            method.setAccessible(true);
            method.invoke(this.cache, memberFactory, memberFactory2);
        }
        catch (Exception exception) {
            if (log.isLoggable(Level.SEVERE)) {
                log.log(Level.SEVERE, null, exception);
            }
            throw new FacesException((Throwable)exception);
        }
    }

    public ResourceResolver getResourceResolver() {
        return this.resolver;
    }

    public Facelet getFacelet(String string) throws IOException {
        return this.getFacelet(this.resolveURL(string));
    }

    public Facelet getMetadataFacelet(String string) throws IOException {
        return this.getMetadataFacelet(this.resolveURL(string));
    }

    public URL resolveURL(URL uRL, String string) throws IOException {
        if (string.startsWith("/")) {
            URL uRL2 = this.resolver.resolveUrl(string);
            if (uRL2 == null) {
                throw new FacesFileNotFoundException(string + " Not Found in ExternalContext as a Resource");
            }
            return uRL2;
        }
        return new URL(uRL, string);
    }

    public Facelet getFacelet(URL uRL) throws IOException {
        return (Facelet)this.cache.getFacelet(uRL);
    }

    public Facelet getMetadataFacelet(URL uRL) throws IOException {
        return (Facelet)this.cache.getViewMetadataFacelet(uRL);
    }

    public boolean needsToBeRefreshed(URL uRL) {
        return !this.cache.isFaceletCached(uRL);
    }

    private URL resolveURL(String string) throws IOException {
        URL uRL = this.relativeLocations.get(string);
        if (uRL == null) {
            uRL = this.resolveURL(this.baseUrl, string);
            if (uRL != null) {
                this.relativeLocations.put(string, uRL);
            } else {
                throw new IOException("'" + string + "' not found.");
            }
        }
        return uRL;
    }

    private DefaultFacelet createFacelet(URL uRL) throws IOException {
        if (log.isLoggable(Level.FINE)) {
            log.fine("Creating Facelet for: " + uRL);
        }
        String string = Pattern.quote(this.baseUrl.getFile());
        String string2 = '/' + uRL.getFile().replaceFirst(string, "");
        try {
            FaceletHandler faceletHandler = this.compiler.compile(uRL, string2);
            return new DefaultFacelet(this, this.compiler.createExpressionFactory(), uRL, string2, faceletHandler);
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new FileNotFoundException("Facelet " + string2 + " not found at: " + uRL.toExternalForm());
        }
    }

    private DefaultFacelet createMetadataFacelet(URL uRL) throws IOException {
        if (log.isLoggable(Level.FINE)) {
            log.fine("Creating Metadata Facelet for: " + uRL);
        }
        String string = Pattern.quote(this.baseUrl.getFile());
        String string2 = '/' + uRL.getFile().replaceFirst(string, "");
        try {
            FaceletHandler faceletHandler = this.compiler.metadataCompile(uRL, string2);
            return new DefaultFacelet(this, this.compiler.createExpressionFactory(), uRL, string2, faceletHandler);
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new FileNotFoundException("Facelet " + string2 + " not found at: " + uRL.toExternalForm());
        }
    }

    public long getRefreshPeriod() {
        return this.refreshPeriod;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class IdMapperFactory
    implements Cache.Factory<String, IdMapper> {
        private IdMapperFactory() {
        }

        @Override
        public IdMapper newInstance(String string) throws InterruptedException {
            return new IdMapper();
        }
    }
}

