/*
 * Decompiled with CFR 0.152.
 */
package com.sun.faces.facelets.el;

import com.sun.faces.util.HtmlUtils;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import javax.el.ELContext;
import javax.el.ELException;
import javax.el.ExpressionFactory;
import javax.el.ValueExpression;
import javax.faces.context.ResponseWriter;

public class ELText {
    protected final String literal;

    public ELText(String string) {
        this.literal = string;
    }

    public boolean isLiteral() {
        return true;
    }

    public ELText apply(ExpressionFactory expressionFactory, ELContext eLContext) {
        return this;
    }

    public void write(Writer writer, ELContext eLContext) throws ELException, IOException {
        writer.write(this.literal);
    }

    public void writeText(ResponseWriter responseWriter, ELContext eLContext) throws ELException, IOException {
        responseWriter.writeText((Object)this.literal, null);
    }

    public String toString(ELContext eLContext) throws ELException {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }

    public static boolean isLiteral(String string) {
        ELText eLText = ELText.parse(string);
        return eLText == null || eLText.isLiteral();
    }

    public static ELText parse(String string) throws ELException {
        return ELText.parse(null, null, string);
    }

    public static ELText parse(ExpressionFactory expressionFactory, ELContext eLContext, String string) throws ELException {
        char[] cArray = string.toCharArray();
        int n = 0;
        char c = '\u0000';
        int n2 = cArray.length;
        int n3 = n2 - 1;
        boolean bl = false;
        int n4 = 0;
        StringBuffer stringBuffer = new StringBuffer(128);
        ArrayList<ELText> arrayList = new ArrayList<ELText>();
        ELTextVariable eLTextVariable = null;
        ValueExpression valueExpression = null;
        while (n < n2) {
            c = cArray[n];
            if ('\\' == c) {
                boolean bl2 = bl = !bl;
                if (bl && n < n3 && (cArray[n + 1] == '$' || cArray[n + 1] == '#')) {
                    ++n;
                    continue;
                }
            } else if (!(bl || '$' != c && '#' != c || n >= n3 || '{' != cArray[n + 1])) {
                if (stringBuffer.length() > 0) {
                    arrayList.add(new ELText(stringBuffer.toString()));
                    stringBuffer.setLength(0);
                }
                n4 = ELText.findVarLength(cArray, n);
                if (eLContext != null && expressionFactory != null) {
                    valueExpression = expressionFactory.createValueExpression(eLContext, new String(cArray, n, n4), String.class);
                    eLTextVariable = new ELTextVariable(valueExpression);
                } else {
                    eLTextVariable = new ELTextVariable(new LiteralValueExpression(new String(cArray, n, n4)));
                }
                arrayList.add(eLTextVariable);
                n += n4;
                continue;
            }
            bl = false;
            stringBuffer.append(c);
            ++n;
        }
        if (stringBuffer.length() > 0) {
            arrayList.add(new ELText(stringBuffer.toString()));
            stringBuffer.setLength(0);
        }
        if (arrayList.size() == 0) {
            return null;
        }
        if (arrayList.size() == 1) {
            return (ELText)arrayList.get(0);
        }
        ELText[] eLTextArray = arrayList.toArray(new ELText[arrayList.size()]);
        return new ELTextComposite(eLTextArray);
    }

    private static int findVarLength(char[] cArray, int n) throws ELException {
        int n2;
        int n3 = cArray.length;
        char c = '\u0000';
        char c2 = '\u0000';
        for (n2 = n; n2 < n3; ++n2) {
            c = cArray[n2];
            if ('\\' == c && n2 < n3 - 1) {
                ++n2;
                continue;
            }
            if ('\'' == c || '\"' == c) {
                if (c2 == c) {
                    c2 = '\u0000';
                    continue;
                }
                c2 = c;
                continue;
            }
            if (c2 != '\u0000' || '}' != c) continue;
            return n2 - n + 1;
        }
        throw new ELException("EL Expression Unbalanced: ... " + new String(cArray, n, n2 - n));
    }

    private static final class ELTextVariable
    extends ELText {
        private final ValueExpression ve;

        public ELTextVariable(ValueExpression valueExpression) {
            super(valueExpression.getExpressionString());
            this.ve = valueExpression;
        }

        public boolean isLiteral() {
            return false;
        }

        public ELText apply(ExpressionFactory expressionFactory, ELContext eLContext) {
            return new ELTextVariable(expressionFactory.createValueExpression(eLContext, this.ve.getExpressionString(), String.class));
        }

        public void write(Writer writer, ELContext eLContext) throws ELException, IOException {
            Object object = this.ve.getValue(eLContext);
            if (object != null) {
                char[] cArray = new char[1028];
                HtmlUtils.writeTextForXML(writer, object.toString(), cArray);
            }
        }

        public String toString(ELContext eLContext) throws ELException {
            Object object = this.ve.getValue(eLContext);
            if (object != null) {
                return object.toString();
            }
            return null;
        }

        public void writeText(ResponseWriter responseWriter, ELContext eLContext) throws ELException, IOException {
            Object object = this.ve.getValue(eLContext);
            if (object != null) {
                responseWriter.writeText((Object)((String)object), null);
            }
        }
    }

    private static final class ELTextComposite
    extends ELText {
        private final ELText[] txt;

        public ELTextComposite(ELText[] eLTextArray) {
            super(null);
            this.txt = eLTextArray;
        }

        public void write(Writer writer, ELContext eLContext) throws ELException, IOException {
            for (int i = 0; i < this.txt.length; ++i) {
                this.txt[i].write(writer, eLContext);
            }
        }

        public void writeText(ResponseWriter responseWriter, ELContext eLContext) throws ELException, IOException {
            for (int i = 0; i < this.txt.length; ++i) {
                this.txt[i].writeText(responseWriter, eLContext);
            }
        }

        public String toString(ELContext eLContext) {
            StringBuffer stringBuffer = new StringBuffer();
            for (int i = 0; i < this.txt.length; ++i) {
                stringBuffer.append(this.txt[i].toString(eLContext));
            }
            return stringBuffer.toString();
        }

        public String toString() {
            StringBuffer stringBuffer = new StringBuffer();
            for (int i = 0; i < this.txt.length; ++i) {
                stringBuffer.append(this.txt[i].toString());
            }
            return stringBuffer.toString();
        }

        public boolean isLiteral() {
            return false;
        }

        public ELText apply(ExpressionFactory expressionFactory, ELContext eLContext) {
            int n = this.txt.length;
            ELText[] eLTextArray = new ELText[n];
            for (int i = 0; i < n; ++i) {
                eLTextArray[i] = this.txt[i].apply(expressionFactory, eLContext);
            }
            return new ELTextComposite(eLTextArray);
        }
    }

    private static final class LiteralValueExpression
    extends ValueExpression {
        private static final long serialVersionUID = 1L;
        private final String text;

        public LiteralValueExpression(String string) {
            this.text = string;
        }

        public boolean isLiteralText() {
            return false;
        }

        public int hashCode() {
            return 0;
        }

        public String getExpressionString() {
            return this.text;
        }

        public boolean equals(Object object) {
            return false;
        }

        public void setValue(ELContext eLContext, Object object) {
        }

        public boolean isReadOnly(ELContext eLContext) {
            return false;
        }

        public Object getValue(ELContext eLContext) {
            return null;
        }

        public Class getType(ELContext eLContext) {
            return null;
        }

        public Class getExpectedType() {
            return null;
        }
    }
}

