/*
 * Decompiled with CFR 0.152.
 */
package com.sun.faces.facelets.el;

import com.sun.faces.component.CompositeComponentStackManager;
import com.sun.faces.facelets.el.ContextualCompositeValueExpression;
import com.sun.faces.facelets.el.TagValueExpression;
import javax.el.ELContext;
import javax.el.ELException;
import javax.el.MethodExpression;
import javax.el.MethodInfo;
import javax.el.ValueExpression;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.view.Location;

public class ContextualCompositeMethodExpression
extends MethodExpression {
    private final MethodExpression delegate;
    private final ValueExpression source;
    private final Location location;
    private final transient UIComponent cc;

    public ContextualCompositeMethodExpression(ValueExpression valueExpression, MethodExpression methodExpression) {
        this.delegate = methodExpression;
        this.source = valueExpression;
        this.location = null;
        FacesContext facesContext = FacesContext.getCurrentInstance();
        this.cc = UIComponent.getCurrentCompositeComponent((FacesContext)facesContext);
    }

    public ContextualCompositeMethodExpression(Location location, MethodExpression methodExpression) {
        this.delegate = methodExpression;
        this.location = location;
        this.source = null;
        FacesContext facesContext = FacesContext.getCurrentInstance();
        this.cc = UIComponent.getCurrentCompositeComponent((FacesContext)facesContext);
    }

    public MethodInfo getMethodInfo(ELContext eLContext) {
        return this.delegate.getMethodInfo(eLContext);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object invoke(ELContext eLContext, Object[] objectArray) {
        FacesContext facesContext = (FacesContext)eLContext.getContext(FacesContext.class);
        boolean bl = this.pushCompositeComponent(facesContext);
        try {
            Object object = this.delegate.invoke(eLContext, objectArray);
            if (bl) {
                this.popCompositeComponent(facesContext);
            }
            return object;
        }
        catch (Throwable throwable) {
            try {
                if (bl) {
                    this.popCompositeComponent(facesContext);
                }
                throw throwable;
            }
            catch (ELException eLException) {
                if (this.source != null) {
                    Object object = this.source.getValue(eLContext);
                    if (object != null && object instanceof MethodExpression) {
                        return ((MethodExpression)object).invoke(eLContext, objectArray);
                    }
                    throw eLException;
                }
                throw eLException;
            }
        }
    }

    public String getExpressionString() {
        return this.delegate.getExpressionString();
    }

    public boolean equals(Object object) {
        return this.delegate.equals(object);
    }

    public int hashCode() {
        return this.delegate.hashCode();
    }

    public boolean isLiteralText() {
        return this.delegate.isLiteralText();
    }

    private boolean pushCompositeComponent(FacesContext facesContext) {
        ValueExpression valueExpression;
        CompositeComponentStackManager compositeComponentStackManager = CompositeComponentStackManager.getManager(facesContext);
        UIComponent uIComponent = null;
        if (this.location != null) {
            uIComponent = compositeComponentStackManager.findCompositeComponentUsingLocation(facesContext, this.location);
        } else if (this.source instanceof TagValueExpression && (valueExpression = ((TagValueExpression)this.source).getWrapped()) instanceof ContextualCompositeValueExpression) {
            uIComponent = compositeComponentStackManager.findCompositeComponentUsingLocation(facesContext, ((ContextualCompositeValueExpression)valueExpression).getLocation());
        }
        if (null == uIComponent) {
            uIComponent = this.cc;
        }
        return compositeComponentStackManager.push(uIComponent);
    }

    private void popCompositeComponent(FacesContext facesContext) {
        CompositeComponentStackManager compositeComponentStackManager = CompositeComponentStackManager.getManager(facesContext);
        compositeComponentStackManager.pop();
    }
}

