/*
 * Decompiled with CFR 0.152.
 */
package com.sun.faces.facelets.compiler;

import com.sun.faces.facelets.compiler.AttributeInstruction;
import com.sun.faces.facelets.compiler.CommentInstruction;
import com.sun.faces.facelets.compiler.CompilationUnit;
import com.sun.faces.facelets.compiler.EndElementInstruction;
import com.sun.faces.facelets.compiler.Instruction;
import com.sun.faces.facelets.compiler.LiteralAttributeInstruction;
import com.sun.faces.facelets.compiler.LiteralCommentInstruction;
import com.sun.faces.facelets.compiler.LiteralTextInstruction;
import com.sun.faces.facelets.compiler.LiteralXMLInstruction;
import com.sun.faces.facelets.compiler.StartElementInstruction;
import com.sun.faces.facelets.compiler.TextInstruction;
import com.sun.faces.facelets.compiler.UIInstructionHandler;
import com.sun.faces.facelets.compiler.XMLInstruction;
import com.sun.faces.facelets.el.ELText;
import java.util.ArrayList;
import java.util.List;
import java.util.Stack;
import javax.el.ELException;
import javax.faces.view.facelets.CompositeFaceletHandler;
import javax.faces.view.facelets.FaceletHandler;
import javax.faces.view.facelets.Tag;
import javax.faces.view.facelets.TagAttribute;
import javax.faces.view.facelets.TagException;

final class TextUnit
extends CompilationUnit {
    private final StringBuffer buffer;
    private final StringBuffer textBuffer;
    private final List instructionBuffer;
    private final Stack tags;
    private final List children;
    private boolean startTagOpen;
    private final String alias;
    private final String id;

    public TextUnit(String string, String string2) {
        this.alias = string;
        this.id = string2;
        this.buffer = new StringBuffer();
        this.textBuffer = new StringBuffer();
        this.instructionBuffer = new ArrayList();
        this.tags = new Stack();
        this.children = new ArrayList();
        this.startTagOpen = false;
    }

    public FaceletHandler createFaceletHandler() {
        this.flushBufferToConfig(true);
        if (this.children.size() == 0) {
            return LEAF;
        }
        FaceletHandler[] faceletHandlerArray = new FaceletHandler[this.children.size()];
        for (int i = 0; i < faceletHandlerArray.length; ++i) {
            Object e = this.children.get(i);
            faceletHandlerArray[i] = e instanceof FaceletHandler ? (FaceletHandler)e : ((CompilationUnit)e).createFaceletHandler();
        }
        if (faceletHandlerArray.length == 1) {
            return faceletHandlerArray[0];
        }
        return new CompositeFaceletHandler(faceletHandlerArray);
    }

    private void addInstruction(Instruction instruction) {
        this.flushTextBuffer(false);
        this.instructionBuffer.add(instruction);
    }

    private void flushTextBuffer(boolean bl) {
        if (this.textBuffer.length() > 0) {
            ELText eLText;
            String string = this.textBuffer.toString();
            if (bl) {
                string = TextUnit.trimRight(string);
            }
            if (string.length() > 0 && (eLText = ELText.parse(string)) != null) {
                if (eLText.isLiteral()) {
                    this.instructionBuffer.add(new LiteralTextInstruction(eLText.toString()));
                } else {
                    this.instructionBuffer.add(new TextInstruction(this.alias, eLText));
                }
            }
        }
        this.textBuffer.setLength(0);
    }

    public void write(String string) {
        this.finishStartTag();
        this.textBuffer.append(string);
        this.buffer.append(string);
    }

    public void writeInstruction(String string) {
        this.finishStartTag();
        ELText eLText = ELText.parse(string);
        if (eLText.isLiteral()) {
            this.addInstruction(new LiteralXMLInstruction(string));
        } else {
            this.addInstruction(new XMLInstruction(eLText));
        }
        this.buffer.append(string);
    }

    public void writeComment(String string) {
        this.finishStartTag();
        ELText eLText = ELText.parse(string);
        if (eLText.isLiteral()) {
            this.addInstruction(new LiteralCommentInstruction(string));
        } else {
            this.addInstruction(new CommentInstruction(eLText));
        }
        this.buffer.append("<!--" + string + "-->");
    }

    public void startTag(Tag tag) {
        this.finishStartTag();
        this.tags.push(tag);
        this.buffer.append('<');
        this.buffer.append(tag.getQName());
        this.addInstruction(new StartElementInstruction(tag.getQName()));
        TagAttribute[] tagAttributeArray = tag.getAttributes().getAll();
        if (tagAttributeArray.length > 0) {
            for (int i = 0; i < tagAttributeArray.length; ++i) {
                String string = tagAttributeArray[i].getQName();
                String string2 = tagAttributeArray[i].getValue();
                this.buffer.append(' ').append(string).append("=\"").append(string2).append("\"");
                ELText eLText = ELText.parse(string2);
                if (eLText == null) continue;
                if (eLText.isLiteral()) {
                    this.addInstruction(new LiteralAttributeInstruction(string, eLText.toString()));
                    continue;
                }
                this.addInstruction(new AttributeInstruction(this.alias, string, eLText));
            }
        }
        this.startTagOpen = true;
    }

    private void finishStartTag() {
        if (this.tags.size() > 0 && this.startTagOpen) {
            this.buffer.append(">");
            this.startTagOpen = false;
        }
    }

    public void endTag() {
        Tag tag = (Tag)this.tags.pop();
        this.addInstruction(new EndElementInstruction(tag.getQName()));
        if (this.startTagOpen) {
            this.buffer.append("/>");
            this.startTagOpen = false;
        } else {
            this.buffer.append("</").append(tag.getQName()).append('>');
        }
    }

    public void addChild(CompilationUnit compilationUnit) {
        this.finishStartTag();
        this.flushBufferToConfig(true);
        this.children.add(compilationUnit);
    }

    protected void flushBufferToConfig(boolean bl) {
        this.flushTextBuffer(bl);
        int n = this.instructionBuffer.size();
        if (n > 0) {
            try {
                ELText eLText;
                String string = this.buffer.toString();
                if (bl) {
                    string = TextUnit.trimRight(string);
                }
                if ((eLText = ELText.parse(string)) != null) {
                    Instruction[] instructionArray = this.instructionBuffer.toArray(new Instruction[n]);
                    this.children.add(new UIInstructionHandler(this.alias, this.id, instructionArray, eLText));
                    this.instructionBuffer.clear();
                }
            }
            catch (ELException eLException) {
                if (this.tags.size() > 0) {
                    throw new TagException((Tag)this.tags.peek(), eLException.getMessage());
                }
                throw new ELException(this.alias + ": " + eLException.getMessage(), eLException.getCause());
            }
        }
        this.buffer.setLength(0);
    }

    public boolean isClosed() {
        return this.tags.empty();
    }

    private static final String trimRight(String string) {
        for (int i = string.length() - 1; i >= 0; --i) {
            if (Character.isWhitespace(string.charAt(i))) {
                continue;
            }
            return string;
        }
        return "";
    }

    public String toString() {
        return "TextUnit[" + this.children.size() + "]";
    }
}

