/*
 * Decompiled with CFR 0.152.
 */
package com.sun.faces.context.flash;

import com.sun.faces.config.WebConfiguration;
import com.sun.faces.facelets.tag.ui.UIDebug;
import com.sun.faces.util.FacesLogger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.faces.application.FacesMessage;
import javax.faces.component.UIViewRoot;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import javax.faces.context.Flash;
import javax.faces.event.PhaseId;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ELFlash
extends Flash {
    private Map<String, Map<String, Object>> flashInnerMap;
    private final AtomicLong sequenceNumber;
    private int numberOfConcurentFlashUsers;
    private long numberOfFlashesBetweenFlashReapings;
    private long lastReaping;
    private static final Logger LOGGER = FacesLogger.FLASH.getLogger();
    static final String PREFIX = "csfcf";
    static final String FLASH_ATTRIBUTE_NAME = "csfcff";
    static final String FLASH_COOKIE_NAME = "csfcfc";
    static final String FLASH_NOW_REQUEST_KEY = "csfcffn";

    private ELFlash() {
        block5: {
            String string;
            WebConfiguration webConfiguration;
            block4: {
                this.flashInnerMap = null;
                this.sequenceNumber = new AtomicLong(0L);
                this.numberOfConcurentFlashUsers = Integer.parseInt(WebConfiguration.WebContextInitParameter.NumberOfConcurrentFlashUsers.getDefaultValue());
                this.numberOfFlashesBetweenFlashReapings = Long.parseLong(WebConfiguration.WebContextInitParameter.NumberOfFlashesBetweenFlashReapings.getDefaultValue());
                this.flashInnerMap = new ConcurrentHashMap<String, Map<String, Object>>();
                webConfiguration = WebConfiguration.getInstance();
                try {
                    string = webConfiguration.getOptionValue(WebConfiguration.WebContextInitParameter.NumberOfConcurrentFlashUsers);
                    this.numberOfConcurentFlashUsers = Integer.parseInt(string);
                }
                catch (NumberFormatException numberFormatException) {
                    if (!LOGGER.isLoggable(Level.WARNING)) break block4;
                    LOGGER.log(Level.WARNING, "Unable to set number of concurrent flash users.  Defaulting to " + this.numberOfConcurentFlashUsers);
                }
            }
            try {
                string = webConfiguration.getOptionValue(WebConfiguration.WebContextInitParameter.NumberOfFlashesBetweenFlashReapings);
                this.numberOfFlashesBetweenFlashReapings = Long.parseLong(string);
            }
            catch (NumberFormatException numberFormatException) {
                if (!LOGGER.isLoggable(Level.WARNING)) break block5;
                LOGGER.log(Level.WARNING, "Unable to set number flashes between flash repaings.  Defaulting to " + this.numberOfFlashesBetweenFlashReapings);
            }
        }
    }

    public static Map<String, Object> getFlash() {
        FacesContext facesContext = FacesContext.getCurrentInstance();
        return ELFlash.getFlash(facesContext.getExternalContext(), true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ELFlash getFlash(ExternalContext externalContext, boolean bl) {
        Map map = externalContext.getApplicationMap();
        ELFlash eLFlash = (ELFlash)((Object)map.get(FLASH_ATTRIBUTE_NAME));
        if (null == eLFlash && bl) {
            Object object = externalContext.getContext();
            synchronized (object) {
                eLFlash = (ELFlash)((Object)map.get(FLASH_ATTRIBUTE_NAME));
                if (null == eLFlash) {
                    eLFlash = new ELFlash();
                    map.put(FLASH_ATTRIBUTE_NAME, eLFlash);
                }
            }
        }
        return eLFlash;
    }

    public boolean isKeepMessages() {
        boolean bl = false;
        Map<String, Object> map = this.loggingGetPhaseMapForReading(false);
        if (null != map) {
            Object object = map.get(CONSTANTS.KeepAllMessagesAttributeName.toString());
            bl = null != object ? (Boolean)object : false;
        }
        return bl;
    }

    public void setKeepMessages(boolean bl) {
        this.loggingGetPhaseMapForWriting(false).put(CONSTANTS.KeepAllMessagesAttributeName.toString(), bl);
    }

    public boolean isRedirect() {
        boolean bl = false;
        FacesContext facesContext = FacesContext.getCurrentInstance();
        Map map = facesContext.getAttributes();
        PreviousNextFlashInfoManager previousNextFlashInfoManager = this.getCurrentFlashManager(map, false);
        if (null != previousNextFlashInfoManager) {
            bl = previousNextFlashInfoManager.getPreviousRequestFlashInfo().isIsRedirect();
        }
        return bl;
    }

    public void setRedirect(boolean bl) {
    }

    public Object get(Object object) {
        Object object2 = null;
        if (null != object) {
            if (object.equals("keepMessages")) {
                object2 = this.isKeepMessages();
            } else if (object.equals("redirect")) {
                object2 = this.isRedirect();
            } else {
                FacesContext facesContext = FacesContext.getCurrentInstance();
                if (this.isKeepFlagSet(facesContext)) {
                    object2 = this.getPhaseMapForReading().get(object);
                    this.keep(object.toString());
                    this.clearKeepFlag(facesContext);
                    return object2;
                }
            }
        }
        if (null == object2) {
            object2 = this.getPhaseMapForReading().get(object);
        }
        if (LOGGER.isLoggable(Level.FINEST)) {
            LOGGER.log(Level.FINEST, "get({0}) = {1}", new Object[]{object, object2});
        }
        return object2;
    }

    public Object put(String string, Object object) {
        Object object2 = null;
        Object object3 = null;
        if (null != string) {
            if (string.equals("keepMessages")) {
                object2 = Boolean.parseBoolean((String)object);
                this.setKeepMessages((Boolean)object2);
            }
            if (string.equals("redirect")) {
                object2 = Boolean.parseBoolean((String)object);
                this.setRedirect((Boolean)object2);
            }
        }
        Object object4 = object3 = null == object2 ? this.getPhaseMapForWriting().put(string, object) : object2;
        if (LOGGER.isLoggable(Level.FINEST)) {
            LOGGER.log(Level.FINEST, "put({0},{1})", new Object[]{string, object});
        }
        return object3;
    }

    public Object remove(Object object) {
        Object object2 = null;
        object2 = this.getPhaseMapForWriting().remove(object);
        return object2;
    }

    public boolean containsKey(Object object) {
        boolean bl = false;
        bl = this.getPhaseMapForReading().containsKey(object);
        return bl;
    }

    public boolean containsValue(Object object) {
        boolean bl = false;
        bl = this.getPhaseMapForReading().containsValue(object);
        return bl;
    }

    public void putAll(Map<? extends String, ?> map) {
        this.getPhaseMapForWriting().putAll(map);
    }

    public Collection<Object> values() {
        Collection<Object> collection = null;
        collection = this.getPhaseMapForReading().values();
        return collection;
    }

    public int size() {
        int n = 0;
        n = this.getPhaseMapForReading().size();
        return n;
    }

    public void clear() {
        this.getPhaseMapForWriting().clear();
    }

    protected Object clone() throws CloneNotSupportedException {
        throw new CloneNotSupportedException();
    }

    public Set<Map.Entry<String, Object>> entrySet() {
        Set<Map.Entry<String, Object>> set = this.getPhaseMapForReading().entrySet();
        Set<Map.Entry<String, Object>> set2 = this.getPhaseMapForWriting().entrySet();
        HashSet<Map.Entry<String, Object>> hashSet = null;
        hashSet = new HashSet<Map.Entry<String, Object>>();
        hashSet.addAll(set);
        hashSet.addAll(set2);
        return hashSet;
    }

    public boolean isEmpty() {
        boolean bl = this.getPhaseMapForReading().isEmpty();
        boolean bl2 = this.getPhaseMapForWriting().isEmpty();
        boolean bl3 = false;
        bl3 = bl && bl2;
        return bl3;
    }

    public Set<String> keySet() {
        Set<String> set = this.getPhaseMapForReading().keySet();
        Set<String> set2 = this.getPhaseMapForWriting().keySet();
        HashSet<String> hashSet = null;
        hashSet = new HashSet<String>();
        hashSet.addAll(set);
        hashSet.addAll(set2);
        return hashSet;
    }

    public void keep(String string) {
        FacesContext facesContext = FacesContext.getCurrentInstance();
        Map map = facesContext.getExternalContext().getRequestMap();
        Map map2 = facesContext.getAttributes();
        PreviousNextFlashInfoManager previousNextFlashInfoManager = this.getCurrentFlashManager(map2, true);
        if (null != previousNextFlashInfoManager) {
            Object object = map.remove(string);
            if (null == object) {
                FlashInfo flashInfo = null;
                flashInfo = previousNextFlashInfoManager.getPreviousRequestFlashInfo();
                if (null != flashInfo) {
                    object = flashInfo.getFlashMap().remove(string);
                }
            }
            if (null != object) {
                this.getPhaseMapForWriting().put(string, object);
            }
        }
    }

    public void putNow(String string, Object object) {
        FacesContext facesContext = FacesContext.getCurrentInstance();
        Map map = facesContext.getAttributes();
        PreviousNextFlashInfoManager previousNextFlashInfoManager = this.getCurrentFlashManager(map, true);
        if (null != previousNextFlashInfoManager) {
            FlashInfo flashInfo = null;
            flashInfo = previousNextFlashInfoManager.getPreviousRequestFlashInfo();
            if (null != flashInfo) {
                flashInfo.getFlashMap().put(string, object);
            }
        }
    }

    public void doPrePhaseActions(FacesContext facesContext) {
        PhaseId phaseId = facesContext.getCurrentPhaseId();
        Map map = facesContext.getAttributes();
        map.put(CONSTANTS.SavedResponseCompleteFlagValue, facesContext.getResponseComplete());
        if (phaseId.equals(PhaseId.RESTORE_VIEW)) {
            Cookie cookie = null;
            cookie = this.getCookie(facesContext.getExternalContext());
            if (null != cookie) {
                this.getCurrentFlashManager(facesContext, map, cookie);
            }
            if (this.isKeepMessages()) {
                this.restoreAllMessages(facesContext);
            }
        }
    }

    public void doPostPhaseActions(FacesContext facesContext) {
        boolean bl;
        PhaseId phaseId = facesContext.getCurrentPhaseId();
        Map map = facesContext.getAttributes();
        boolean bl2 = this.responseCompleteWasJustSetTrue(facesContext, map);
        boolean bl3 = bl = bl2 || phaseId == PhaseId.RENDER_RESPONSE;
        if (bl) {
            this.doLastPhaseActions(facesContext, false);
        }
    }

    public void doLastPhaseActions(FacesContext facesContext, boolean bl) {
        ExternalContext externalContext = facesContext.getExternalContext();
        Map map = facesContext.getAttributes();
        PreviousNextFlashInfoManager previousNextFlashInfoManager = this.getCurrentFlashManager(map, false);
        if (null == previousNextFlashInfoManager) {
            return;
        }
        if (this.isKeepMessages()) {
            this.saveAllMessages(facesContext);
        }
        this.releaseCurrentFlashManager(map);
        if (bl) {
            FlashInfo flashInfo = previousNextFlashInfoManager.getPreviousRequestFlashInfo();
            flashInfo.setIsRedirect(true);
            previousNextFlashInfoManager.expireNext_MovePreviousToNext();
        } else {
            FlashInfo flashInfo = previousNextFlashInfoManager.getPreviousRequestFlashInfo();
            if (null != flashInfo && flashInfo.getLifetimeMarker() == LifetimeMarker.SecondTimeThru) {
                previousNextFlashInfoManager.expirePrevious();
            }
        }
        if (LOGGER.isLoggable(Level.FINEST)) {
            LOGGER.log(Level.FINEST, "---------------------------------------");
        }
        this.setCookie(facesContext, previousNextFlashInfoManager, previousNextFlashInfoManager.encode());
    }

    private void maybeWriteCookie(FacesContext facesContext, PreviousNextFlashInfoManager previousNextFlashInfoManager) {
        FlashInfo flashInfo = previousNextFlashInfoManager.getPreviousRequestFlashInfo();
        if (null != flashInfo && flashInfo.getLifetimeMarker() == LifetimeMarker.SecondTimeThru) {
            PreviousNextFlashInfoManager previousNextFlashInfoManager2 = previousNextFlashInfoManager.copyWithoutInnerMap();
            previousNextFlashInfoManager2.expirePrevious();
            this.setCookie(facesContext, previousNextFlashInfoManager, previousNextFlashInfoManager2.encode());
        }
    }

    void setKeepFlag(FacesContext facesContext) {
        facesContext.getAttributes().put(CONSTANTS.KeepFlagAttributeName, Boolean.TRUE);
    }

    void clearKeepFlag(FacesContext facesContext) {
        facesContext.getAttributes().remove((Object)CONSTANTS.KeepFlagAttributeName);
    }

    boolean isKeepFlagSet(FacesContext facesContext) {
        return Boolean.TRUE == facesContext.getAttributes().get((Object)CONSTANTS.KeepFlagAttributeName);
    }

    private long getNewSequenceNumber() {
        long l = this.sequenceNumber.incrementAndGet();
        if (0L == l % this.numberOfFlashesBetweenFlashReapings) {
            this.reapFlashes();
        }
        if (l == Long.MAX_VALUE) {
            l = 1L;
            this.sequenceNumber.set(1L);
        }
        return l;
    }

    private void reapFlashes() {
        if (this.flashInnerMap.size() < this.numberOfConcurentFlashUsers) {
            return;
        }
        Set<String> set = this.flashInnerMap.keySet();
        long l = this.sequenceNumber.get();
        for (String string : set) {
            long l2 = Long.parseLong(string);
            if ((long)this.numberOfConcurentFlashUsers >= l - l2) continue;
            Map<String, Object> map = this.flashInnerMap.get(string);
            if (null != map) {
                map.clear();
            }
            this.flashInnerMap.remove(string);
        }
    }

    private boolean responseCompleteWasJustSetTrue(FacesContext facesContext, Map<Object, Object> map) {
        boolean bl = false;
        bl = Boolean.FALSE == map.get((Object)CONSTANTS.SavedResponseCompleteFlagValue) && facesContext.getResponseComplete();
        return bl;
    }

    private static String getLogPrefix(FacesContext facesContext) {
        String string;
        UIViewRoot uIViewRoot;
        StringBuilder stringBuilder = new StringBuilder();
        ExternalContext externalContext = facesContext.getExternalContext();
        Object object = externalContext.getRequest();
        if (object instanceof HttpServletRequest) {
            stringBuilder.append(((HttpServletRequest)object).getMethod()).append(" ");
        }
        if (null != (uIViewRoot = facesContext.getViewRoot()) && null != (string = uIViewRoot.getViewId())) {
            stringBuilder.append(string).append(" ");
        }
        return stringBuilder.toString();
    }

    private Map<String, Object> loggingGetPhaseMapForWriting(boolean bl) {
        FacesContext facesContext = FacesContext.getCurrentInstance();
        Map<String, Object> map = null;
        PhaseId phaseId = facesContext.getCurrentPhaseId();
        Map map2 = facesContext.getAttributes();
        PreviousNextFlashInfoManager previousNextFlashInfoManager = this.getCurrentFlashManager(map2, true);
        if (null != previousNextFlashInfoManager) {
            FlashInfo flashInfo;
            boolean bl2;
            boolean bl3 = bl2 = bl && LOGGER.isLoggable(Level.FINEST);
            if (phaseId.getOrdinal() < PhaseId.RENDER_RESPONSE.getOrdinal()) {
                flashInfo = previousNextFlashInfoManager.getPreviousRequestFlashInfo();
                if (bl2) {
                    LOGGER.log(Level.FINEST, "{0}previous[{1}]", new Object[]{ELFlash.getLogPrefix(facesContext), flashInfo.getSequenceNumber()});
                }
            } else {
                flashInfo = previousNextFlashInfoManager.getNextRequestFlashInfo(this, true);
                if (bl2) {
                    LOGGER.log(Level.FINEST, "{0}next[{1}]", new Object[]{ELFlash.getLogPrefix(facesContext), flashInfo.getSequenceNumber()});
                }
                this.maybeWriteCookie(facesContext, previousNextFlashInfoManager);
            }
            map = flashInfo.getFlashMap();
        }
        return map;
    }

    private Map<String, Object> getPhaseMapForWriting() {
        return this.loggingGetPhaseMapForWriting(true);
    }

    private Map<String, Object> loggingGetPhaseMapForReading(boolean bl) {
        FlashInfo flashInfo;
        FacesContext facesContext = FacesContext.getCurrentInstance();
        Map<String, Object> map = Collections.emptyMap();
        Map map2 = facesContext.getAttributes();
        PreviousNextFlashInfoManager previousNextFlashInfoManager = this.getCurrentFlashManager(map2, false);
        if (null != previousNextFlashInfoManager && null != (flashInfo = previousNextFlashInfoManager.getPreviousRequestFlashInfo())) {
            boolean bl2;
            boolean bl3 = bl2 = bl && LOGGER.isLoggable(Level.FINEST);
            if (bl2) {
                LOGGER.log(Level.FINEST, "{0}previous[{1}]", new Object[]{ELFlash.getLogPrefix(facesContext), flashInfo.getSequenceNumber()});
            }
            map = flashInfo.getFlashMap();
        }
        return map;
    }

    private Map<String, Object> getPhaseMapForReading() {
        return this.loggingGetPhaseMapForReading(true);
    }

    void saveAllMessages(FacesContext facesContext) {
        ArrayList arrayList;
        Iterator iterator;
        Map map = facesContext.getAttributes();
        PreviousNextFlashInfoManager previousNextFlashInfoManager = this.getCurrentFlashManager(map, true);
        if (null == previousNextFlashInfoManager) {
            return;
        }
        if (previousNextFlashInfoManager.getPreviousRequestFlashInfo().isIsRedirect()) {
            return;
        }
        Iterator iterator2 = facesContext.getClientIdsWithMessages();
        HashMap hashMap = null;
        while (iterator2.hasNext()) {
            String string = (String)iterator2.next();
            iterator = facesContext.getMessages(string);
            arrayList = new ArrayList();
            while (iterator.hasNext()) {
                arrayList.add(iterator.next());
            }
            if (null == hashMap) {
                hashMap = new HashMap();
            }
            hashMap.put(string, arrayList);
        }
        arrayList = null;
        iterator = facesContext.getMessages(null);
        arrayList = new ArrayList();
        while (iterator.hasNext()) {
            arrayList.add(iterator.next());
        }
        if (null != arrayList) {
            if (null == hashMap) {
                hashMap = new HashMap();
            }
            hashMap.put(null, arrayList);
        }
        this.getPhaseMapForWriting().put(CONSTANTS.FacesMessageAttributeName.toString(), hashMap);
    }

    void restoreAllMessages(FacesContext facesContext) {
        Map<String, Object> map = this.getPhaseMapForReading();
        Map map2 = (Map)map.get(CONSTANTS.FacesMessageAttributeName.toString());
        if (null != map2) {
            for (Map.Entry entry : map2.entrySet()) {
                List list = (List)map2.get(entry.getKey());
                if (null == list) continue;
                for (FacesMessage facesMessage : list) {
                    facesContext.addMessage((String)entry.getKey(), facesMessage);
                }
            }
            map.remove(CONSTANTS.FacesMessageAttributeName.toString());
        }
    }

    private Cookie getCookie(ExternalContext externalContext) {
        Cookie cookie = null;
        cookie = (Cookie)externalContext.getRequestCookieMap().get(FLASH_COOKIE_NAME);
        return cookie;
    }

    private void setCookie(FacesContext facesContext, PreviousNextFlashInfoManager previousNextFlashInfoManager, Cookie cookie) {
        Map map = facesContext.getAttributes();
        ExternalContext externalContext = facesContext.getExternalContext();
        if (map.containsKey((Object)CONSTANTS.DidWriteCookieAttributeName)) {
            return;
        }
        FlashInfo flashInfo = previousNextFlashInfoManager.getNextRequestFlashInfo();
        FlashInfo flashInfo2 = previousNextFlashInfoManager.getPreviousRequestFlashInfo();
        if (null != flashInfo && !flashInfo.getFlashMap().isEmpty() || null != flashInfo2 && !flashInfo2.getFlashMap().isEmpty()) {
            HttpServletResponse httpServletResponse = (HttpServletResponse)externalContext.getResponse();
            if (httpServletResponse.isCommitted()) {
                if (LOGGER.isLoggable(Level.WARNING)) {
                    LOGGER.log(Level.WARNING, "jsf.externalcontext.flash.response.already.committed");
                }
            } else {
                httpServletResponse.addCookie(cookie);
            }
            map.put(CONSTANTS.DidWriteCookieAttributeName, Boolean.TRUE);
        }
    }

    private void releaseCurrentFlashManager(Map<Object, Object> map) {
        map.remove((Object)CONSTANTS.RequestFlashManager);
    }

    private PreviousNextFlashInfoManager getCurrentFlashManager(Map<Object, Object> map, boolean bl) {
        PreviousNextFlashInfoManager previousNextFlashInfoManager = (PreviousNextFlashInfoManager)map.get((Object)CONSTANTS.RequestFlashManager);
        if (null == previousNextFlashInfoManager && bl) {
            previousNextFlashInfoManager = new PreviousNextFlashInfoManager(this.flashInnerMap);
            previousNextFlashInfoManager.initializeBaseCase(this);
            map.put((Object)CONSTANTS.RequestFlashManager, previousNextFlashInfoManager);
        }
        return previousNextFlashInfoManager;
    }

    private PreviousNextFlashInfoManager getCurrentFlashManager(FacesContext facesContext, Map<Object, Object> map, Cookie cookie) {
        PreviousNextFlashInfoManager previousNextFlashInfoManager = (PreviousNextFlashInfoManager)map.get((Object)CONSTANTS.RequestFlashManager);
        if (null == previousNextFlashInfoManager) {
            previousNextFlashInfoManager = new PreviousNextFlashInfoManager(this.flashInnerMap);
            previousNextFlashInfoManager.decode(facesContext, this, cookie);
            map.put((Object)CONSTANTS.RequestFlashManager, previousNextFlashInfoManager);
        }
        return previousNextFlashInfoManager;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class FlashInfo {
        private boolean isRedirect;
        private LifetimeMarker lifetimeMarker;
        private long sequenceNumber;
        private Map<String, Object> flashMap;

        private FlashInfo() {
        }

        FlashInfo(long l, LifetimeMarker lifetimeMarker, boolean bl) {
            this.setSequenceNumber(l);
            this.setLifetimeMarker(lifetimeMarker);
            this.setIsRedirect(bl);
        }

        FlashInfo copyWithoutInnerMap() {
            FlashInfo flashInfo = new FlashInfo(this.sequenceNumber, this.lifetimeMarker, this.isRedirect);
            return flashInfo;
        }

        public boolean equals(Object object) {
            if (object == null) {
                return false;
            }
            if (this.getClass() != object.getClass()) {
                return false;
            }
            FlashInfo flashInfo = (FlashInfo)object;
            if (this.isRedirect != flashInfo.isRedirect) {
                return false;
            }
            if (!(this.lifetimeMarker == flashInfo.lifetimeMarker || this.lifetimeMarker != null && this.lifetimeMarker.equals((Object)flashInfo.lifetimeMarker))) {
                return false;
            }
            return this.sequenceNumber == flashInfo.sequenceNumber;
        }

        public int hashCode() {
            int n = 7;
            n = 71 * n + (this.isRedirect ? 1 : 0);
            n = 71 * n + (this.lifetimeMarker != null ? this.lifetimeMarker.hashCode() : 0);
            n = 71 * n + (int)(this.sequenceNumber ^ this.sequenceNumber >>> 32);
            return n;
        }

        void decode(String string) {
            if (null == string || 0 == string.length()) {
                return;
            }
            int n = string.indexOf(88);
            this.setSequenceNumber(Long.parseLong(string.substring(0, n++)));
            this.setLifetimeMarker(LifetimeMarker.decode(string.charAt(n++)));
            this.setIsRedirect(LifetimeMarker.IsRedirect == LifetimeMarker.decode(string.charAt(n++)));
        }

        String encode() {
            String string = null;
            string = this.isIsRedirect() ? Long.toString(this.getSequenceNumber()) + "X" + this.getLifetimeMarker().encode() + LifetimeMarker.IsRedirect.encode() : Long.toString(this.getSequenceNumber()) + "X" + this.getLifetimeMarker().encode() + LifetimeMarker.IsNormal.encode();
            return string;
        }

        boolean isIsRedirect() {
            return this.isRedirect;
        }

        void setIsRedirect(boolean bl) {
            this.isRedirect = bl;
        }

        long getSequenceNumber() {
            return this.sequenceNumber;
        }

        void setSequenceNumber(long l) {
            this.sequenceNumber = l;
        }

        LifetimeMarker getLifetimeMarker() {
            return this.lifetimeMarker;
        }

        void setLifetimeMarker(LifetimeMarker lifetimeMarker) {
            this.lifetimeMarker = lifetimeMarker;
        }

        Map<String, Object> getFlashMap() {
            return this.flashMap;
        }

        void setFlashMap(Map<String, Object> map) {
            this.flashMap = map;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class PreviousNextFlashInfoManager {
        private FlashInfo previousRequestFlashInfo;
        private FlashInfo nextRequestFlashInfo;
        private boolean incomingCookieCameFromRedirect = false;
        private Map<String, Map<String, Object>> innerMap;

        private PreviousNextFlashInfoManager() {
        }

        private PreviousNextFlashInfoManager(Map<String, Map<String, Object>> map) {
            this.innerMap = map;
        }

        protected PreviousNextFlashInfoManager copyWithoutInnerMap() {
            PreviousNextFlashInfoManager previousNextFlashInfoManager = new PreviousNextFlashInfoManager();
            previousNextFlashInfoManager.innerMap = Collections.emptyMap();
            if (null != this.previousRequestFlashInfo) {
                previousNextFlashInfoManager.previousRequestFlashInfo = this.previousRequestFlashInfo.copyWithoutInnerMap();
            }
            if (null != this.nextRequestFlashInfo) {
                previousNextFlashInfoManager.nextRequestFlashInfo = this.nextRequestFlashInfo.copyWithoutInnerMap();
            }
            previousNextFlashInfoManager.incomingCookieCameFromRedirect = this.incomingCookieCameFromRedirect;
            return previousNextFlashInfoManager;
        }

        public String toString() {
            String string = null;
            string = "previousRequestSequenceNumber: " + (null != this.previousRequestFlashInfo ? Long.valueOf(this.previousRequestFlashInfo.getSequenceNumber()) : "null") + " nextRequestSequenceNumber: " + (null != this.nextRequestFlashInfo ? Long.valueOf(this.nextRequestFlashInfo.getSequenceNumber()) : "null");
            return string;
        }

        void initializeBaseCase(ELFlash eLFlash) {
            HashMap<String, Object> hashMap = null;
            this.previousRequestFlashInfo = new FlashInfo(eLFlash.getNewSequenceNumber(), LifetimeMarker.FirstTimeThru, false);
            hashMap = new HashMap<String, Object>();
            this.innerMap.put(this.previousRequestFlashInfo.getSequenceNumber() + "", hashMap);
            this.previousRequestFlashInfo.setFlashMap(hashMap);
            this.nextRequestFlashInfo = new FlashInfo(eLFlash.getNewSequenceNumber(), LifetimeMarker.FirstTimeThru, false);
            hashMap = new HashMap();
            this.innerMap.put(this.nextRequestFlashInfo.getSequenceNumber() + "", hashMap);
            this.nextRequestFlashInfo.setFlashMap(hashMap);
        }

        void expirePrevious() {
            if (null != this.previousRequestFlashInfo) {
                Map<String, Object> map = this.previousRequestFlashInfo.getFlashMap();
                if (null != map) {
                    if (LOGGER.isLoggable(Level.FINEST)) {
                        LOGGER.log(Level.FINEST, "{0} expire previous[{1}]", new Object[]{ELFlash.getLogPrefix(FacesContext.getCurrentInstance()), this.previousRequestFlashInfo.getSequenceNumber()});
                    }
                    map.clear();
                }
                this.innerMap.remove(this.previousRequestFlashInfo.getSequenceNumber() + "");
                this.previousRequestFlashInfo = null;
            }
        }

        void expireNext_MovePreviousToNext() {
            if (null != this.nextRequestFlashInfo) {
                if (LOGGER.isLoggable(Level.FINEST)) {
                    LOGGER.log(Level.FINEST, "{0} expire next[{1}], move previous to next", new Object[]{ELFlash.getLogPrefix(FacesContext.getCurrentInstance()), this.nextRequestFlashInfo.getSequenceNumber()});
                }
                this.nextRequestFlashInfo.getFlashMap().clear();
                this.innerMap.remove(this.nextRequestFlashInfo.getSequenceNumber() + "");
                this.nextRequestFlashInfo = null;
            }
            this.nextRequestFlashInfo = this.previousRequestFlashInfo;
            this.previousRequestFlashInfo = null;
        }

        void decode(FacesContext facesContext, ELFlash eLFlash, Cookie cookie) {
            block9: {
                String string = cookie.getValue();
                try {
                    int n = string.indexOf("_");
                    String string2 = string.substring(0, n++);
                    if (0 < string2.length()) {
                        this.nextRequestFlashInfo = new FlashInfo();
                        this.nextRequestFlashInfo.decode(string2);
                    }
                    this.previousRequestFlashInfo = new FlashInfo();
                    this.previousRequestFlashInfo.decode(string.substring(n));
                    if (this.previousRequestFlashInfo.isIsRedirect()) {
                        this.setIncomingCookieCameFromRedirect(true);
                        this.previousRequestFlashInfo.setIsRedirect(false);
                    } else if (!UIDebug.debugRequest(facesContext)) {
                        this.previousRequestFlashInfo.setLifetimeMarker(LifetimeMarker.SecondTimeThru);
                        this.nextRequestFlashInfo = null;
                    }
                    Map<String, Object> map = this.innerMap.get(this.previousRequestFlashInfo.getSequenceNumber() + "");
                    if (null == map) {
                        this.previousRequestFlashInfo = new FlashInfo();
                        this.previousRequestFlashInfo.setSequenceNumber(eLFlash.getNewSequenceNumber());
                        this.previousRequestFlashInfo.setLifetimeMarker(LifetimeMarker.FirstTimeThru);
                        this.previousRequestFlashInfo.setIsRedirect(false);
                        map = new HashMap<String, Object>();
                        this.innerMap.put(this.previousRequestFlashInfo.getSequenceNumber() + "", map);
                    }
                    this.previousRequestFlashInfo.setFlashMap(map);
                    if (null != this.nextRequestFlashInfo) {
                        map = this.innerMap.get(this.nextRequestFlashInfo.getSequenceNumber() + "");
                        if (null == map) {
                            this.nextRequestFlashInfo = new FlashInfo();
                            this.nextRequestFlashInfo.setSequenceNumber(eLFlash.getNewSequenceNumber());
                            this.nextRequestFlashInfo.setLifetimeMarker(LifetimeMarker.FirstTimeThru);
                            this.nextRequestFlashInfo.setIsRedirect(false);
                            map = new HashMap<String, Object>();
                            this.innerMap.put(this.nextRequestFlashInfo.getSequenceNumber() + "", map);
                        }
                        this.nextRequestFlashInfo.setFlashMap(map);
                    }
                }
                catch (Throwable throwable) {
                    if (!LOGGER.isLoggable(Level.SEVERE)) break block9;
                    LOGGER.log(Level.SEVERE, "jsf.externalcontext.flash.bad.cookie", new Object[]{string});
                }
            }
        }

        Cookie encode() {
            Cookie cookie = null;
            String string = (null != this.previousRequestFlashInfo ? this.previousRequestFlashInfo.encode() : "") + "_" + (null != this.nextRequestFlashInfo ? this.nextRequestFlashInfo.encode() : "");
            cookie = new Cookie(ELFlash.FLASH_COOKIE_NAME, string);
            if (1 == string.length()) {
                cookie.setMaxAge(0);
                cookie.setPath("/");
            }
            return cookie;
        }

        FlashInfo getPreviousRequestFlashInfo() {
            return this.previousRequestFlashInfo;
        }

        void setPreviousRequestFlashInfo(FlashInfo flashInfo) {
            this.previousRequestFlashInfo = flashInfo;
        }

        FlashInfo getNextRequestFlashInfo() {
            return this.nextRequestFlashInfo;
        }

        FlashInfo getNextRequestFlashInfo(ELFlash eLFlash, boolean bl) {
            if (bl && null == this.nextRequestFlashInfo) {
                this.nextRequestFlashInfo = new FlashInfo();
                this.nextRequestFlashInfo.setSequenceNumber(eLFlash.getNewSequenceNumber());
                this.nextRequestFlashInfo.setLifetimeMarker(LifetimeMarker.FirstTimeThru);
                this.nextRequestFlashInfo.setIsRedirect(false);
                HashMap<String, Object> hashMap = null;
                hashMap = new HashMap<String, Object>();
                this.innerMap.put(this.nextRequestFlashInfo.getSequenceNumber() + "", hashMap);
                this.nextRequestFlashInfo.setFlashMap(hashMap);
            }
            return this.nextRequestFlashInfo;
        }

        void setNextRequestFlashInfo(FlashInfo flashInfo) {
            this.nextRequestFlashInfo = flashInfo;
        }

        boolean isIncomingCookieCameFromRedirect() {
            return this.incomingCookieCameFromRedirect;
        }

        void setIncomingCookieCameFromRedirect(boolean bl) {
            this.incomingCookieCameFromRedirect = bl;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum LifetimeMarker {
        FirstTimeThru("f"),
        SecondTimeThru("s"),
        IsRedirect("r"),
        IsNormal("n");

        private static char FIRST_TIME_THRU;
        private static char SECOND_TIME_THRU;
        private static char IS_REDIRECT;
        private static char IS_NORMAL;
        private String name;

        private LifetimeMarker(String string2) {
            this.name = string2;
        }

        public String toString() {
            return this.name;
        }

        public char encode() {
            return this.name.charAt(0);
        }

        public static LifetimeMarker decode(char c) {
            LifetimeMarker lifetimeMarker = FirstTimeThru;
            if (FIRST_TIME_THRU == c) {
                lifetimeMarker = FirstTimeThru;
            } else if (SECOND_TIME_THRU == c) {
                lifetimeMarker = SecondTimeThru;
            } else if (IS_REDIRECT == c) {
                lifetimeMarker = IsRedirect;
            } else if (IS_NORMAL == c) {
                lifetimeMarker = IsNormal;
            } else {
                throw new IllegalStateException("class invariant failed: invalid lifetime marker");
            }
            return lifetimeMarker;
        }

        static {
            FIRST_TIME_THRU = (char)102;
            SECOND_TIME_THRU = (char)115;
            IS_REDIRECT = (char)114;
            IS_NORMAL = (char)110;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum CONSTANTS {
        RequestFlashManager,
        SavedResponseCompleteFlagValue,
        FacesMessageAttributeName,
        KeepAllMessagesAttributeName,
        KeepFlagAttributeName,
        DidWriteCookieAttributeName;

    }
}

