/*
 * Decompiled with CFR 0.152.
 */
package com.sun.faces.context;

import com.sun.faces.application.ApplicationAssociate;
import com.sun.faces.application.ApplicationStateInfo;
import com.sun.faces.util.ComponentStruct;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.faces.component.UIComponent;
import javax.faces.component.UIViewRoot;
import javax.faces.context.FacesContext;
import javax.faces.event.AbortProcessingException;
import javax.faces.event.PostAddToViewEvent;
import javax.faces.event.PreRemoveFromViewEvent;
import javax.faces.event.SystemEvent;
import javax.faces.event.SystemEventListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StateContext {
    private static final String KEY = StateContext.class.getName() + "_KEY";
    private boolean partial;
    private boolean partialLocked;
    private boolean trackMods = true;
    private AddRemoveListener modListener;
    private ApplicationStateInfo stateInfo;
    private WeakReference<UIViewRoot> viewRootRef = new WeakReference<Object>(null);

    private StateContext(ApplicationStateInfo applicationStateInfo) {
        this.stateInfo = applicationStateInfo;
    }

    public static StateContext getStateContext(FacesContext facesContext) {
        StateContext stateContext = (StateContext)facesContext.getAttributes().get(KEY);
        if (stateContext == null) {
            ApplicationAssociate applicationAssociate = ApplicationAssociate.getCurrentInstance();
            ApplicationStateInfo applicationStateInfo = applicationAssociate.getApplicationStateInfo();
            stateContext = new StateContext(applicationStateInfo);
            facesContext.getAttributes().put(KEY, stateContext);
        }
        return stateContext;
    }

    public boolean partialStateSaving(FacesContext facesContext, String string) {
        UIViewRoot uIViewRoot;
        UIViewRoot uIViewRoot2 = facesContext.getViewRoot();
        if (uIViewRoot2 != (uIViewRoot = (UIViewRoot)this.viewRootRef.get())) {
            this.viewRootRef = new WeakReference<UIViewRoot>(uIViewRoot2);
            if (uIViewRoot != null) {
                this.modListener = null;
                this.partialLocked = false;
            }
        }
        if (!this.partialLocked) {
            if (string == null) {
                string = uIViewRoot2 != null ? uIViewRoot2.getViewId() : (String)facesContext.getAttributes().get("com.sun.faces.viewId");
            }
            this.partial = this.stateInfo.usePartialStateSaving(string);
            this.partialLocked = true;
        }
        return this.partial;
    }

    public boolean trackViewModifications() {
        return this.trackMods;
    }

    public void startTrackViewModifications(FacesContext facesContext, UIViewRoot uIViewRoot) {
        if (this.modListener == null) {
            this.modListener = new AddRemoveListener(facesContext);
            uIViewRoot.subscribeToViewEvent(PostAddToViewEvent.class, (SystemEventListener)this.modListener);
            uIViewRoot.subscribeToViewEvent(PreRemoveFromViewEvent.class, (SystemEventListener)this.modListener);
        }
        this.setTrackViewModifications(true);
    }

    public void setTrackViewModifications(boolean bl) {
        this.trackMods = bl;
    }

    public boolean componentAddedDynamically(UIComponent uIComponent) {
        return uIComponent.getAttributes().containsKey("com.sun.faces.DynamicComponent");
    }

    public int getIndexOfDynamicallyAddedChildInParent(UIComponent uIComponent) {
        int n = -1;
        Map map = uIComponent.getAttributes();
        if (map.containsKey("com.sun.faces.DynamicComponent")) {
            n = (Integer)map.get("com.sun.faces.DynamicComponent");
        }
        return n;
    }

    public boolean hasOneOrMoreDynamicChild(UIComponent uIComponent) {
        return uIComponent.getAttributes().containsKey("com.sun.faces.DynamicChildCount");
    }

    private int incrementDynamicChildCount(UIComponent uIComponent) {
        int n = 0;
        Map map = uIComponent.getAttributes();
        Integer n2 = (Integer)map.get("com.sun.faces.DynamicChildCount");
        if (null != n2) {
            Integer n3 = n2;
            Integer n4 = n2 = Integer.valueOf(n2 + 1);
            n = n3;
        } else {
            n = 1;
        }
        map.put("com.sun.faces.DynamicChildCount", n);
        return n;
    }

    private int decrementDynamicChildCount(UIComponent uIComponent) {
        int n = 0;
        Map map = uIComponent.getAttributes();
        Integer n2 = (Integer)map.get("com.sun.faces.DynamicChildCount");
        if (null != n2) {
            int n3;
            if (0 < n2) {
                Integer n4 = n2;
                Integer n5 = n2 = Integer.valueOf(n2 - 1);
                n3 = n4;
            } else {
                n3 = n = 0;
            }
        }
        if (0 == n && null != n2) {
            map.remove("com.sun.faces.DynamicChildCount");
        }
        return n;
    }

    public List<ComponentStruct> getDynamicActions() {
        return this.modListener != null ? this.modListener.getDynamicActions() : null;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class AddRemoveListener
    implements SystemEventListener {
        private StateContext stateCtx;
        private List<ComponentStruct> dynamicActions;

        public AddRemoveListener(FacesContext facesContext) {
            this.stateCtx = StateContext.getStateContext(facesContext);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public List<ComponentStruct> getDynamicActions() {
            AddRemoveListener addRemoveListener = this;
            synchronized (addRemoveListener) {
                if (this.dynamicActions == null) {
                    this.dynamicActions = new ArrayList<ComponentStruct>();
                }
            }
            return this.dynamicActions;
        }

        public void processEvent(SystemEvent systemEvent) throws AbortProcessingException {
            FacesContext facesContext = FacesContext.getCurrentInstance();
            if (systemEvent instanceof PreRemoveFromViewEvent) {
                if (this.stateCtx.trackViewModifications()) {
                    this.handleRemove(facesContext, ((PreRemoveFromViewEvent)systemEvent).getComponent());
                }
            } else if (this.stateCtx.trackViewModifications()) {
                this.handleAdd(facesContext, ((PostAddToViewEvent)systemEvent).getComponent());
            }
        }

        public boolean isListenerForSource(Object object) {
            return object instanceof UIComponent && !(object instanceof UIViewRoot);
        }

        private void handleRemove(FacesContext facesContext, UIComponent uIComponent) {
            if (!uIComponent.isTransient() && uIComponent.isInView()) {
                StateContext.this.decrementDynamicChildCount(uIComponent.getParent());
                ComponentStruct componentStruct = new ComponentStruct();
                componentStruct.action = "REMOVE";
                componentStruct.clientId = uIComponent.getClientId(facesContext);
                componentStruct.id = uIComponent.getId();
                this.getDynamicActions().add(componentStruct);
            }
        }

        private void handleAdd(FacesContext facesContext, UIComponent uIComponent) {
            if (!uIComponent.isTransient() && uIComponent.getParent() != null && uIComponent.getParent().isInView()) {
                if (uIComponent.getParent().getFacets().containsValue(uIComponent)) {
                    Map map = uIComponent.getParent().getFacets();
                    for (Map.Entry entry : map.entrySet()) {
                        if (entry.getValue() != uIComponent) continue;
                        StateContext.this.incrementDynamicChildCount(uIComponent.getParent());
                        uIComponent.getAttributes().put("com.sun.faces.DynamicComponent", uIComponent.getParent().getChildren().indexOf(uIComponent));
                        uIComponent.clearInitialState();
                        ComponentStruct componentStruct = new ComponentStruct();
                        componentStruct.action = "ADD";
                        componentStruct.facetName = entry.getKey().toString();
                        componentStruct.parentClientId = uIComponent.getParent().getClientId(facesContext);
                        componentStruct.clientId = uIComponent.getClientId(facesContext);
                        componentStruct.id = uIComponent.getId();
                        this.getDynamicActions().add(componentStruct);
                    }
                } else {
                    StateContext.this.incrementDynamicChildCount(uIComponent.getParent());
                    uIComponent.getAttributes().put("com.sun.faces.DynamicComponent", uIComponent.getParent().getChildren().indexOf(uIComponent));
                    uIComponent.clearInitialState();
                    ComponentStruct componentStruct = new ComponentStruct();
                    componentStruct.action = "ADD";
                    componentStruct.parentClientId = uIComponent.getParent().getClientId(facesContext);
                    componentStruct.clientId = uIComponent.getClientId(facesContext);
                    componentStruct.id = uIComponent.getId();
                    this.getDynamicActions().add(componentStruct);
                }
            }
        }
    }
}

