/*
 * Decompiled with CFR 0.152.
 */
package com.sun.faces.context;

import com.sun.faces.context.BaseContextMap;
import com.sun.faces.util.FacesLogger;
import com.sun.faces.util.Util;
import java.io.Serializable;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.faces.application.ProjectStage;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SessionMap
extends BaseContextMap<Object> {
    private static final Logger LOGGER = FacesLogger.APPLICATION.getLogger();
    private final HttpServletRequest request;
    private final ProjectStage stage;

    public SessionMap(HttpServletRequest httpServletRequest, ProjectStage projectStage) {
        this.request = httpServletRequest;
        this.stage = projectStage;
    }

    @Override
    public void clear() {
        HttpSession httpSession = this.getSession(false);
        if (httpSession != null) {
            Enumeration enumeration = httpSession.getAttributeNames();
            while (enumeration.hasMoreElements()) {
                String string = (String)enumeration.nextElement();
                httpSession.removeAttribute(string);
            }
        }
    }

    @Override
    public void putAll(Map map) {
        HttpSession httpSession = this.getSession(true);
        for (Map.Entry entry : map.entrySet()) {
            Object v = entry.getValue();
            Object k = entry.getKey();
            if (ProjectStage.Development.equals((Object)this.stage) && !(v instanceof Serializable) && LOGGER.isLoggable(Level.WARNING)) {
                LOGGER.log(Level.WARNING, "jsf.context.extcontext.sessionmap.nonserializable", new Object[]{k, v.getClass().getName()});
            }
            httpSession.setAttribute((String)k, v);
        }
    }

    @Override
    public Object get(Object object) {
        Util.notNull("key", object);
        HttpSession httpSession = this.getSession(false);
        return httpSession != null ? httpSession.getAttribute(object.toString()) : null;
    }

    @Override
    public Object put(String string, Object object) {
        Util.notNull("key", string);
        HttpSession httpSession = this.getSession(true);
        Object object2 = httpSession.getAttribute(string);
        if (object != null && ProjectStage.Development.equals((Object)this.stage) && !(object instanceof Serializable) && LOGGER.isLoggable(Level.WARNING)) {
            LOGGER.log(Level.WARNING, "jsf.context.extcontext.sessionmap.nonserializable", new Object[]{string, object.getClass().getName()});
        }
        boolean bl = true;
        if (null != object && null != object2) {
            boolean bl2 = bl = !object2.equals(object);
        }
        if (bl) {
            httpSession.setAttribute(string, object);
        }
        return object2;
    }

    @Override
    public Object remove(Object object) {
        if (object == null) {
            return null;
        }
        HttpSession httpSession = this.getSession(false);
        if (httpSession != null) {
            String string = object.toString();
            Object object2 = httpSession.getAttribute(string);
            httpSession.removeAttribute(string);
            return object2;
        }
        return null;
    }

    @Override
    public boolean containsKey(Object object) {
        HttpSession httpSession = this.getSession(false);
        return httpSession != null && httpSession.getAttribute(object.toString()) != null;
    }

    @Override
    public boolean equals(Object object) {
        return object != null && object instanceof SessionMap && super.equals(object);
    }

    @Override
    public int hashCode() {
        HttpSession httpSession = this.getSession(false);
        int n = 7 * (httpSession != null ? httpSession.hashCode() : super.hashCode());
        if (httpSession != null) {
            Iterator iterator = this.entrySet().iterator();
            while (iterator.hasNext()) {
                n += iterator.next().hashCode();
            }
        }
        return n;
    }

    @Override
    protected Iterator<Map.Entry<String, Object>> getEntryIterator() {
        HttpSession httpSession = this.getSession(false);
        if (httpSession != null) {
            return new BaseContextMap.EntryIterator(httpSession.getAttributeNames());
        }
        Map map = Collections.emptyMap();
        return map.entrySet().iterator();
    }

    @Override
    protected Iterator<String> getKeyIterator() {
        HttpSession httpSession = this.getSession(false);
        if (httpSession != null) {
            return new BaseContextMap.KeyIterator(httpSession.getAttributeNames());
        }
        Map map = Collections.emptyMap();
        return map.keySet().iterator();
    }

    @Override
    protected Iterator<Object> getValueIterator() {
        HttpSession httpSession = this.getSession(false);
        if (httpSession != null) {
            return new BaseContextMap.ValueIterator(httpSession.getAttributeNames());
        }
        Map map = Collections.emptyMap();
        return map.values().iterator();
    }

    private HttpSession getSession(boolean bl) {
        return this.request.getSession(bl);
    }
}

