/*
 * Decompiled with CFR 0.152.
 */
package com.sun.faces.context;

import com.sun.faces.util.FacesLogger;
import java.io.IOException;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.faces.FacesException;
import javax.faces.application.ProjectStage;
import javax.faces.component.UIComponent;
import javax.faces.context.ExceptionHandler;
import javax.faces.context.ExceptionHandlerWrapper;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import javax.faces.context.PartialResponseWriter;
import javax.faces.event.AbortProcessingException;
import javax.faces.event.ExceptionQueuedEvent;
import javax.faces.event.ExceptionQueuedEventContext;
import javax.faces.event.PhaseId;
import javax.faces.event.SystemEvent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AjaxExceptionHandlerImpl
extends ExceptionHandlerWrapper {
    private static final Logger LOGGER = FacesLogger.CONTEXT.getLogger();
    private static final String LOG_BEFORE_KEY = "jsf.context.exception.handler.log_before";
    private static final String LOG_AFTER_KEY = "jsf.context.exception.handler.log_after";
    private static final String LOG_KEY = "jsf.context.exception.handler.log";
    private LinkedList<ExceptionQueuedEvent> unhandledExceptions;
    private LinkedList<ExceptionQueuedEvent> handledExceptions;
    private ExceptionQueuedEvent handled;
    private ExceptionHandler exceptionHandler = null;

    public AjaxExceptionHandlerImpl(ExceptionHandler exceptionHandler) {
        this.exceptionHandler = exceptionHandler;
    }

    public ExceptionHandler getWrapped() {
        return this.exceptionHandler;
    }

    public ExceptionQueuedEvent getHandledExceptionQueuedEvent() {
        return this.handled;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handle() throws FacesException {
        Iterator<ExceptionQueuedEvent> iterator = this.getUnhandledExceptionQueuedEvents().iterator();
        while (iterator.hasNext()) {
            ExceptionQueuedEvent exceptionQueuedEvent = iterator.next();
            ExceptionQueuedEventContext exceptionQueuedEventContext = (ExceptionQueuedEventContext)exceptionQueuedEvent.getSource();
            try {
                Throwable throwable = exceptionQueuedEventContext.getException();
                if (this.isRethrown(throwable)) {
                    this.handled = exceptionQueuedEvent;
                    Throwable throwable2 = this.getRootCause(throwable);
                    if (throwable2 != null) {
                        this.handlePartialResponseError(exceptionQueuedEventContext.getContext(), throwable2);
                        continue;
                    }
                    if (throwable instanceof FacesException) {
                        this.handlePartialResponseError(exceptionQueuedEventContext.getContext(), throwable);
                        continue;
                    }
                    this.handlePartialResponseError(exceptionQueuedEventContext.getContext(), new FacesException(throwable.getMessage(), throwable));
                    continue;
                }
                this.log(exceptionQueuedEventContext);
            }
            finally {
                if (this.handledExceptions == null) {
                    this.handledExceptions = new LinkedList();
                }
                this.handledExceptions.add(exceptionQueuedEvent);
                iterator.remove();
            }
        }
    }

    public void processEvent(SystemEvent systemEvent) throws AbortProcessingException {
        if (systemEvent != null) {
            if (this.unhandledExceptions == null) {
                this.unhandledExceptions = new LinkedList();
            }
            this.unhandledExceptions.add((ExceptionQueuedEvent)systemEvent);
        }
    }

    public Iterable<ExceptionQueuedEvent> getUnhandledExceptionQueuedEvents() {
        return this.unhandledExceptions != null ? this.unhandledExceptions : Collections.emptyList();
    }

    public Iterable<ExceptionQueuedEvent> getHandledExceptionQueuedEvents() {
        return this.handledExceptions != null ? this.handledExceptions : Collections.emptyList();
    }

    private void handlePartialResponseError(FacesContext facesContext, Throwable throwable) {
        block3: {
            if (facesContext.getResponseComplete()) {
                return;
            }
            try {
                ExternalContext externalContext = facesContext.getExternalContext();
                externalContext.setResponseContentType("text/xml");
                externalContext.addResponseHeader("Cache-Control", "no-cache");
                PartialResponseWriter partialResponseWriter = facesContext.getPartialViewContext().getPartialResponseWriter();
                partialResponseWriter.startDocument();
                String string = facesContext.isProjectStage(ProjectStage.Production) ? "See your server log for more information" : (throwable.getCause() != null ? throwable.getCause().getMessage() : throwable.getMessage());
                partialResponseWriter.write(string != null ? string : "");
                partialResponseWriter.endDocument();
                facesContext.responseComplete();
            }
            catch (IOException iOException) {
                if (!LOGGER.isLoggable(Level.SEVERE)) break block3;
                LOGGER.log(Level.SEVERE, iOException.toString(), iOException);
            }
        }
    }

    private boolean isRethrown(Throwable throwable) {
        return !(throwable instanceof AbortProcessingException);
    }

    private void log(ExceptionQueuedEventContext exceptionQueuedEventContext) {
        UIComponent uIComponent = exceptionQueuedEventContext.getComponent();
        boolean bl = exceptionQueuedEventContext.inBeforePhase();
        boolean bl2 = exceptionQueuedEventContext.inAfterPhase();
        PhaseId phaseId = exceptionQueuedEventContext.getPhaseId();
        Throwable throwable = exceptionQueuedEventContext.getException();
        String string = this.getLoggingKey(bl, bl2);
        if (LOGGER.isLoggable(Level.SEVERE)) {
            LOGGER.log(Level.SEVERE, string, new Object[]{throwable.getClass().getName(), phaseId.toString(), uIComponent != null ? uIComponent.getClientId(exceptionQueuedEventContext.getContext()) : "", throwable.getMessage()});
            LOGGER.log(Level.SEVERE, throwable.getMessage(), throwable);
        }
    }

    private String getLoggingKey(boolean bl, boolean bl2) {
        if (bl) {
            return LOG_BEFORE_KEY;
        }
        if (bl2) {
            return LOG_AFTER_KEY;
        }
        return LOG_KEY;
    }
}

