/*
 * Decompiled with CFR 0.152.
 */
package com.sun.faces.config.processor;

import com.sun.faces.application.ApplicationAssociate;
import com.sun.faces.application.ApplicationResourceBundle;
import com.sun.faces.config.ConfigurationException;
import com.sun.faces.config.DocumentInfo;
import com.sun.faces.config.WebConfiguration;
import com.sun.faces.config.processor.AbstractConfigProcessor;
import com.sun.faces.el.ChainAwareVariableResolver;
import com.sun.faces.el.DummyPropertyResolverImpl;
import com.sun.faces.util.FacesLogger;
import com.sun.faces.util.Util;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.el.ELResolver;
import javax.faces.application.Application;
import javax.faces.application.ConfigurableNavigationHandler;
import javax.faces.application.NavigationHandler;
import javax.faces.application.ResourceHandler;
import javax.faces.application.StateManager;
import javax.faces.application.ViewHandler;
import javax.faces.context.FacesContext;
import javax.faces.el.PropertyResolver;
import javax.faces.el.VariableResolver;
import javax.faces.event.ActionListener;
import javax.faces.event.NamedEvent;
import javax.faces.event.SystemEventListener;
import javax.servlet.ServletContext;
import javax.validation.Validation;
import javax.validation.ValidatorFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ApplicationConfigProcessor
extends AbstractConfigProcessor {
    private static final Logger LOGGER = FacesLogger.CONFIG.getLogger();
    private static final String APPLICATION = "application";
    private static final String ACTION_LISTENER = "action-listener";
    private static final String DEFAULT_RENDERKIT_ID = "default-render-kit-id";
    private static final String DEFAULT_VALIDATORS = "default-validators";
    private static final String VALIDATOR_ID = "validator-id";
    private static final String MESSAGE_BUNDLE = "message-bundle";
    private static final String NAVIGATION_HANDLER = "navigation-handler";
    private static final String VIEW_HANDLER = "view-handler";
    private static final String STATE_MANAGER = "state-manager";
    private static final String RESOURCE_HANDLER = "resource-handler";
    private static final String EL_RESOLVER = "el-resolver";
    private static final String PROPERTY_RESOLVER = "property-resolver";
    private static final String VARIABLE_RESOLVER = "variable-resolver";
    private static final String DEFAULT_LOCALE = "default-locale";
    private static final String SUPPORTED_LOCALE = "supported-locale";
    private static final String RESOURCE_BUNDLE = "resource-bundle";
    private static final String BASE_NAME = "base-name";
    private static final String VAR = "var";
    private static final String RES_DESCRIPTIONS = "description";
    private static final String RES_DISPLAY_NAMES = "display-name";
    private static final String SYSTEM_EVENT_LISTENER = "system-event-listener";
    private static final String SYSTEM_EVENT_LISTENER_CLASS = "system-event-listener-class";
    private static final String SYSTEM_EVENT_CLASS = "system-event-class";
    private static final String SOURCE_CLASS = "source-class";

    @Override
    public void process(ServletContext servletContext, DocumentInfo[] documentInfoArray) throws Exception {
        Application application = this.getApplication();
        ApplicationAssociate applicationAssociate = ApplicationAssociate.getInstance(FacesContext.getCurrentInstance().getExternalContext());
        LinkedHashMap<String, Node> linkedHashMap = new LinkedHashMap<String, Node>();
        LinkedHashSet<String> linkedHashSet = null;
        for (int i = 0; i < documentInfoArray.length; ++i) {
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.log(Level.FINE, MessageFormat.format("Processing application elements for document: ''{0}''", documentInfoArray[i].getSourceURI()));
            }
            Document document = documentInfoArray[i].getDocument();
            String string = document.getDocumentElement().getNamespaceURI();
            NodeList nodeList = document.getDocumentElement().getElementsByTagNameNS(string, APPLICATION);
            if (nodeList == null || nodeList.getLength() <= 0) continue;
            int n = nodeList.getLength();
            for (int j = 0; j < n; ++j) {
                Node node = nodeList.item(j);
                NodeList nodeList2 = ((Element)node).getElementsByTagNameNS(string, "*");
                if (nodeList2 == null || nodeList2.getLength() <= 0) continue;
                int n2 = nodeList2.getLength();
                for (int k = 0; k < n2; ++k) {
                    Node node2 = nodeList2.item(k);
                    if (MESSAGE_BUNDLE.equals(node2.getLocalName())) {
                        this.setMessageBundle(application, node2);
                        continue;
                    }
                    if (DEFAULT_RENDERKIT_ID.equals(node2.getLocalName())) {
                        this.setDefaultRenderKitId(application, node2);
                        continue;
                    }
                    if (ACTION_LISTENER.equals(node2.getLocalName())) {
                        this.addActionListener(application, node2);
                        continue;
                    }
                    if (NAVIGATION_HANDLER.equals(node2.getLocalName())) {
                        this.setNavigationHandler(application, node2);
                        continue;
                    }
                    if (VIEW_HANDLER.equals(node2.getLocalName())) {
                        String string2 = this.getNodeText(node2);
                        if (string2 == null) continue;
                        linkedHashMap.put(string2, node2);
                        continue;
                    }
                    if (STATE_MANAGER.equals(node2.getLocalName())) {
                        this.setStateManager(application, node2);
                        continue;
                    }
                    if (EL_RESOLVER.equals(node2.getLocalName())) {
                        this.addELResolver(applicationAssociate, node2);
                        continue;
                    }
                    if (PROPERTY_RESOLVER.equals(node2.getLocalName())) {
                        this.addPropertyResolver(applicationAssociate, node2);
                        continue;
                    }
                    if (VARIABLE_RESOLVER.equals(node2.getLocalName())) {
                        this.addVariableResolver(applicationAssociate, node2);
                        continue;
                    }
                    if (DEFAULT_LOCALE.equals(node2.getLocalName())) {
                        this.setDefaultLocale(application, node2);
                        continue;
                    }
                    if (SUPPORTED_LOCALE.equals(node2.getLocalName())) {
                        this.addSupportedLocale(application, node2);
                        continue;
                    }
                    if (RESOURCE_BUNDLE.equals(node2.getLocalName())) {
                        this.addResouceBundle(applicationAssociate, node2);
                        continue;
                    }
                    if (RESOURCE_HANDLER.equals(node2.getLocalName())) {
                        this.setResourceHandler(application, node2);
                        continue;
                    }
                    if (SYSTEM_EVENT_LISTENER.equals(node2.getLocalName())) {
                        this.addSystemEventListener(application, node2);
                        continue;
                    }
                    if (DEFAULT_VALIDATORS.equals(node2.getLocalName())) {
                        if (linkedHashSet == null) {
                            linkedHashSet = new LinkedHashSet<String>();
                            continue;
                        }
                        linkedHashSet.clear();
                        continue;
                    }
                    if (!VALIDATOR_ID.equals(node2.getLocalName())) continue;
                    linkedHashSet.add(this.getNodeText(node2));
                }
            }
        }
        this.registerDefaultValidatorIds(application, linkedHashSet);
        this.processViewHandlers(application, linkedHashMap);
        this.processAnnotations(NamedEvent.class);
        this.invokeNext(servletContext, documentInfoArray);
    }

    private void registerDefaultValidatorIds(Application application, LinkedHashSet<String> linkedHashSet) {
        if (linkedHashSet == null) {
            Object object;
            linkedHashSet = new LinkedHashSet();
            if (ApplicationConfigProcessor.isBeanValidatorAvailable() && !((WebConfiguration)(object = WebConfiguration.getInstance())).isOptionEnabled(WebConfiguration.BooleanWebContextInitParameter.DisableDefaultBeanValidator)) {
                linkedHashSet.add("javax.faces.Bean");
            }
        }
        for (String string : linkedHashSet) {
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.log(Level.FINE, MessageFormat.format("Calling Application.addDefaultValidatorId({0})", string));
            }
            application.addDefaultValidatorId(string);
        }
    }

    static boolean isBeanValidatorAvailable() {
        boolean bl = false;
        Map map = FacesContext.getCurrentInstance().getExternalContext().getApplicationMap();
        if (map.containsKey("javax.faces.BEANS_VALIDATION_AVAILABLE")) {
            bl = (Boolean)map.get("javax.faces.BEANS_VALIDATION_AVAILABLE");
        } else {
            block8: {
                try {
                    Thread.currentThread().getContextClassLoader().loadClass("javax.validation.MessageInterpolator");
                    Object v = map.get("javax.faces.validator.beanValidator.ValidatorFactory");
                    if (v instanceof ValidatorFactory) {
                        bl = true;
                        break block8;
                    }
                    try {
                        ValidatorFactory validatorFactory = Validation.buildDefaultValidatorFactory();
                        map.put("javax.faces.validator.beanValidator.ValidatorFactory", validatorFactory);
                        bl = true;
                    }
                    catch (Throwable throwable) {
                        if (LOGGER.isLoggable(Level.FINE)) {
                            String string = "Could not build a default Bean Validator factory: " + throwable.getMessage();
                            LOGGER.fine(string);
                        }
                    }
                }
                catch (Throwable throwable) {
                    if (!LOGGER.isLoggable(Level.FINE)) break block8;
                    LOGGER.fine("Unable to load Beans Validation");
                }
            }
            map.put("javax.faces.BEANS_VALIDATION_AVAILABLE", bl);
        }
        return bl;
    }

    private void setMessageBundle(Application application, Node node) {
        String string;
        if (node != null && (string = this.getNodeText(node)) != null) {
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.log(Level.FINE, MessageFormat.format("Calling Application.setMessageBundle({0})", string));
            }
            application.setMessageBundle(string);
        }
    }

    private void setDefaultRenderKitId(Application application, Node node) {
        String string;
        if (node != null && (string = this.getNodeText(node)) != null) {
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.log(Level.FINE, MessageFormat.format("Calling Application.setDefaultRenderKitId({0})", string));
            }
            application.setDefaultRenderKitId(string);
        }
    }

    private void addActionListener(Application application, Node node) {
        Object object;
        String string;
        if (node != null && (string = this.getNodeText(node)) != null && (object = this.createInstance(string, ActionListener.class, application.getActionListener(), node)) != null) {
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.log(Level.FINE, MessageFormat.format("Calling Application.setActionListeners({0})", string));
            }
            application.setActionListener((ActionListener)object);
        }
    }

    private void setNavigationHandler(Application application, Node node) {
        Class<?> clazz;
        Object object;
        String string;
        if (node != null && (string = this.getNodeText(node)) != null && (object = this.createInstance(string, (clazz = this.findRootType(string, node, new Class[]{ConfigurableNavigationHandler.class, NavigationHandler.class})) != null ? clazz : NavigationHandler.class, application.getNavigationHandler(), node)) != null) {
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.log(Level.FINE, MessageFormat.format("Calling Application.setNavigationHandlers({0})", string));
            }
            application.setNavigationHandler((NavigationHandler)object);
        }
    }

    private void setStateManager(Application application, Node node) {
        Object object;
        String string;
        if (node != null && (string = this.getNodeText(node)) != null && (object = this.createInstance(string, StateManager.class, application.getStateManager(), node)) != null) {
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.log(Level.FINE, MessageFormat.format("Calling Application.setStateManagers({0})", string));
            }
            application.setStateManager((StateManager)object);
        }
    }

    private void setViewHandler(Application application, Node node) {
        Object object;
        String string;
        if (node != null && (string = this.getNodeText(node)) != null && (object = this.createInstance(string, ViewHandler.class, application.getViewHandler(), node)) != null) {
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.log(Level.FINE, MessageFormat.format("Calling Application.setViewHandler({0})", string));
            }
            application.setViewHandler((ViewHandler)object);
        }
    }

    private void addELResolver(ApplicationAssociate applicationAssociate, Node node) {
        if (node != null && applicationAssociate != null) {
            Object object;
            String string;
            List<ELResolver> list = applicationAssociate.getELResolversFromFacesConfig();
            if (list == null) {
                list = new ArrayList<ELResolver>();
                applicationAssociate.setELResolversFromFacesConfig(list);
            }
            if ((string = this.getNodeText(node)) != null && (object = this.createInstance(string, ELResolver.class, null, node)) != null) {
                if (LOGGER.isLoggable(Level.FINE)) {
                    LOGGER.log(Level.FINE, MessageFormat.format("Adding ''{0}'' to ELResolver chain", string));
                }
                list.add((ELResolver)object);
            }
        }
    }

    private void addPropertyResolver(ApplicationAssociate applicationAssociate, Node node) {
        if (node != null && applicationAssociate != null) {
            String string;
            Object object = applicationAssociate.getLegacyPRChainHead();
            if (object == null) {
                object = new DummyPropertyResolverImpl();
            }
            if ((string = this.getNodeText(node)) != null) {
                object = this.createInstance(string, PropertyResolver.class, object, node);
                if (LOGGER.isLoggable(Level.FINE)) {
                    LOGGER.log(Level.FINE, MessageFormat.format("Adding ''{0}'' to PropertyResolver chain", object));
                }
            }
            if (object != null) {
                applicationAssociate.setLegacyPRChainHead((PropertyResolver)object);
            }
        }
    }

    private void addVariableResolver(ApplicationAssociate applicationAssociate, Node node) {
        if (node != null && applicationAssociate != null) {
            String string;
            Object object = applicationAssociate.getLegacyVRChainHead();
            if (object == null) {
                object = new ChainAwareVariableResolver();
            }
            if ((string = this.getNodeText(node)) != null) {
                object = this.createInstance(string, VariableResolver.class, object, node);
                if (LOGGER.isLoggable(Level.FINE)) {
                    LOGGER.log(Level.FINE, MessageFormat.format("Adding ''{0}'' to VariableResolver chain", object));
                }
            }
            if (object != null) {
                applicationAssociate.setLegacyVRChainHead((VariableResolver)object);
            }
        }
    }

    private void setDefaultLocale(Application application, Node node) {
        Locale locale;
        String string;
        if (node != null && (string = this.getNodeText(node)) != null && (locale = Util.getLocaleFromString(string)) != null) {
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.log(Level.FINE, MessageFormat.format("Setting default Locale to ''{0}''", string));
            }
            application.setDefaultLocale(locale);
        }
    }

    private void addSupportedLocale(Application application, Node node) {
        if (node != null) {
            Set<Locale> set = this.getCurrentLocales(application);
            String string = this.getNodeText(node);
            if (string != null) {
                Locale locale = Util.getLocaleFromString(string);
                if (locale != null) {
                    if (LOGGER.isLoggable(Level.FINE)) {
                        LOGGER.log(Level.FINE, MessageFormat.format("Adding supported Locale ''{0}''", string));
                    }
                    set.add(locale);
                }
                application.setSupportedLocales(set);
            }
        }
    }

    private void addResouceBundle(ApplicationAssociate applicationAssociate, Node node) {
        NodeList nodeList;
        if (node != null && (nodeList = node.getChildNodes()) != null) {
            String string = null;
            String string2 = null;
            ArrayList<Node> arrayList = null;
            ArrayList<Node> arrayList2 = null;
            int n = nodeList.getLength();
            for (int i = 0; i < n; ++i) {
                Node node2 = nodeList.item(i);
                if (node2.getNodeType() != 1) continue;
                if (BASE_NAME.equals(node2.getLocalName())) {
                    string = this.getNodeText(node2);
                    continue;
                }
                if (VAR.equals(node2.getLocalName())) {
                    string2 = this.getNodeText(node2);
                    continue;
                }
                if (RES_DESCRIPTIONS.equals(node2.getLocalName())) {
                    if (arrayList == null) {
                        arrayList = new ArrayList<Node>(2);
                    }
                    arrayList.add(node2);
                    continue;
                }
                if (!RES_DISPLAY_NAMES.equals(node2.getLocalName())) continue;
                if (arrayList2 == null) {
                    arrayList2 = new ArrayList<Node>(2);
                }
                arrayList2.add(node2);
            }
            if (string != null && string2 != null) {
                applicationAssociate.addResourceBundle(string2, new ApplicationResourceBundle(string, this.getTextMap(arrayList2), this.getTextMap(arrayList)));
            }
        }
    }

    private Set<Locale> getCurrentLocales(Application application) {
        HashSet<Locale> hashSet = new HashSet<Locale>();
        Iterator iterator = application.getSupportedLocales();
        while (iterator.hasNext()) {
            hashSet.add((Locale)iterator.next());
        }
        return hashSet;
    }

    private void setResourceHandler(Application application, Node node) {
        Object object;
        String string;
        if (node != null && (string = this.getNodeText(node)) != null && (object = this.createInstance(string, ResourceHandler.class, application.getResourceHandler(), node)) != null) {
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.log(Level.FINE, MessageFormat.format("Calling Application.setResourceHandler({0})", string));
            }
            application.setResourceHandler((ResourceHandler)object);
        }
    }

    private void addSystemEventListener(Application application, Node node) {
        SystemEventListener systemEventListener;
        Node node2;
        NodeList nodeList = node.getChildNodes();
        String string = null;
        String string2 = null;
        String string3 = null;
        int n = nodeList.getLength();
        for (int i = 0; i < n; ++i) {
            node2 = nodeList.item(i);
            if (node2.getNodeType() != 1) continue;
            if (SYSTEM_EVENT_LISTENER_CLASS.equals(node2.getLocalName())) {
                string = this.getNodeText(node2);
                continue;
            }
            if (SYSTEM_EVENT_CLASS.equals(node2.getLocalName())) {
                string2 = this.getNodeText(node2);
                continue;
            }
            if (!SOURCE_CLASS.equals(node2.getLocalName())) continue;
            string3 = this.getNodeText(node2);
        }
        if (string != null && (systemEventListener = (SystemEventListener)this.createInstance(string, SystemEventListener.class, null, node)) != null) {
            try {
                Class<?> clazz = this.loadClass(string2, this, null);
                node2 = string3 != null && string3.length() != 0 ? Util.loadClass(string3, this.getClass()) : null;
                application.subscribeToEvent(clazz, (Class)((Object)node2), systemEventListener);
                if (LOGGER.isLoggable(Level.FINE)) {
                    LOGGER.log(Level.FINE, "Subscribing for event {0} and source {1} using listener {2}", new Object[]{clazz.getName(), node2 != null ? ((Class)((Object)node2)).getName() : "ANY", systemEventListener.getClass().getName()});
                }
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new ConfigurationException(classNotFoundException);
            }
        }
    }

    private void processViewHandlers(Application application, LinkedHashMap<String, Node> linkedHashMap) {
        WebConfiguration webConfiguration = WebConfiguration.getInstance();
        if (!webConfiguration.isOptionEnabled(WebConfiguration.BooleanWebContextInitParameter.DisableFaceletJSFViewHandler) && linkedHashMap.containsKey("com.sun.facelets.FaceletViewHandler")) {
            if (LOGGER.isLoggable(Level.WARNING)) {
                LOGGER.log(Level.WARNING, "jsf.application.legacy_facelet_viewhandler_detected", "com.sun.facelets.FaceletViewHandler");
            }
            webConfiguration.overrideContextInitParameter(WebConfiguration.BooleanWebContextInitParameter.DisableFaceletJSFViewHandler, true);
        }
        for (Node node : linkedHashMap.values()) {
            this.setViewHandler(application, node);
        }
    }
}

