/*
 * Decompiled with CFR 0.152.
 */
package com.sun.faces.config;

import com.sun.faces.config.AnnotationScanner;
import com.sun.faces.util.FacesLogger;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.net.JarURLConnection;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.nio.ByteBuffer;
import java.nio.channels.Channel;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.ServletContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JavaClassScanningAnnotationScanner
extends AnnotationScanner {
    private static final Logger LOGGER = FacesLogger.CONFIG.getLogger();
    private static final Pattern JAR_PATTERN = Pattern.compile("(.*/(\\S*\\.jar)).*");
    private static final String WEB_INF_CLASSES = "/WEB-INF/classes/";
    private ClassFile classFileScanner = new ClassFile();

    public JavaClassScanningAnnotationScanner(ServletContext servletContext) {
        super(servletContext);
    }

    @Override
    public Map<Class<? extends Annotation>, Set<Class<?>>> getAnnotatedClasses(Set<URI> set) {
        HashSet<String> hashSet = new HashSet<String>();
        this.processWebInfClasses(this.sc, hashSet);
        this.processClasspath(set, hashSet);
        this.processScripts(hashSet);
        return this.processClassList(hashSet);
    }

    private void processClasspath(Set<URI> set, Set<String> set2) {
        for (URI uRI : set) {
            try {
                Matcher matcher = JAR_PATTERN.matcher(uRI.toString());
                if (matcher.matches()) {
                    String string = matcher.group(2);
                    if (!this.processJar(string)) continue;
                    StringBuilder stringBuilder = new StringBuilder(32);
                    String string2 = matcher.group(1);
                    if (!string2.startsWith("jar:")) {
                        stringBuilder.append("jar:");
                    }
                    if (string2.startsWith("zip:")) {
                        stringBuilder.append("file:").append(string2.substring(4));
                    } else if (string2.startsWith("bundle:")) {
                        stringBuilder.append("file:").append(string2.substring(7));
                    } else {
                        stringBuilder.append(string2);
                    }
                    stringBuilder.append("!/");
                    URL uRL = new URL(stringBuilder.toString());
                    JarFile jarFile = ((JarURLConnection)uRL.openConnection()).getJarFile();
                    this.processJarEntries(jarFile, this.getClasspathPackages() != null ? this.getClasspathPackages().get(string) : null, set2);
                    continue;
                }
                if (!LOGGER.isLoggable(Level.FINE)) continue;
                LOGGER.fine("Unable to match URL to a jar file: " + uRI.toString());
            }
            catch (Exception exception) {
                if (!LOGGER.isLoggable(Level.SEVERE)) continue;
                LOGGER.log(Level.SEVERE, "Unable to process annotations for url, {0}.  Reason: " + exception.toString(), new Object[]{uRI});
                LOGGER.log(Level.SEVERE, "", exception);
            }
        }
    }

    private static boolean isAnnotation(String string) {
        return FACES_ANNOTATIONS.contains(string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processJarEntries(JarFile jarFile, String[] stringArray, Set<String> set) {
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.log(Level.FINE, "Scanning JAR {0} for annotations...", jarFile.getName());
        }
        Enumeration<JarEntry> enumeration = jarFile.entries();
        while (enumeration.hasMoreElements()) {
            String string;
            String string2;
            JarEntry jarEntry = enumeration.nextElement();
            if (jarEntry.isDirectory() || (string2 = jarEntry.getName()).startsWith("META-INF") || !string2.endsWith(".class") || !this.processClass(string = this.convertToClassName(string2), stringArray)) continue;
            ReadableByteChannel readableByteChannel = null;
            try {
                readableByteChannel = Channels.newChannel(jarFile.getInputStream(jarEntry));
                if (!this.classFileScanner.containsAnnotation(readableByteChannel)) continue;
                if (LOGGER.isLoggable(Level.FINE)) {
                    LOGGER.log(Level.FINE, "[JAR] Found annotated Class: {0}", string);
                }
                set.add(string);
            }
            catch (IOException iOException) {
                if (!LOGGER.isLoggable(Level.SEVERE)) continue;
                LOGGER.log(Level.SEVERE, "Unexpected exception scanning JAR {0} for annotations", jarFile.getName());
                LOGGER.log(Level.SEVERE, iOException.toString(), iOException);
            }
            finally {
                if (readableByteChannel == null) continue;
                try {
                    readableByteChannel.close();
                }
                catch (IOException iOException) {
                    if (!LOGGER.isLoggable(Level.FINE)) continue;
                    LOGGER.log(Level.FINE, iOException.toString(), iOException);
                }
            }
        }
    }

    private void processWebInfClasses(ServletContext servletContext, Set<String> set) {
        this.processWebInfClasses(servletContext, WEB_INF_CLASSES, set);
    }

    private void processWebInfClasses(ServletContext servletContext, String string, Set<String> set) {
        Set set2 = servletContext.getResourcePaths(string);
        this.processWebInfClasses(servletContext, set2, set);
    }

    private void processWebInfClasses(ServletContext servletContext, Set<String> set, Set<String> set2) {
        if (set != null && !set.isEmpty()) {
            for (String string : set) {
                String string2;
                if (string.endsWith("/")) {
                    this.processWebInfClasses(servletContext, string, set2);
                    continue;
                }
                if (!string.endsWith(".class") || !this.processClass(string2 = this.convertToClassName(WEB_INF_CLASSES, string)) || !this.containsAnnotation(servletContext, string)) continue;
                if (LOGGER.isLoggable(Level.FINE)) {
                    LOGGER.log(Level.FINE, "[WEB-INF/classes] Found annotated Class: {0}", string2);
                }
                set2.add(string2);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean containsAnnotation(ServletContext servletContext, String string) {
        Channel channel = null;
        try {
            URL uRL = servletContext.getResource(string);
            channel = Channels.newChannel(uRL.openStream());
            boolean bl = this.classFileScanner.containsAnnotation((ReadableByteChannel)channel);
            return bl;
        }
        catch (MalformedURLException malformedURLException) {
            if (LOGGER.isLoggable(Level.SEVERE)) {
                LOGGER.log(Level.SEVERE, malformedURLException.toString(), malformedURLException);
            }
        }
        catch (IOException iOException) {
            if (LOGGER.isLoggable(Level.SEVERE)) {
                LOGGER.log(Level.SEVERE, iOException.toString(), iOException);
            }
        }
        finally {
            block19: {
                if (channel != null) {
                    try {
                        channel.close();
                    }
                    catch (IOException iOException) {
                        if (!LOGGER.isLoggable(Level.FINE)) break block19;
                        LOGGER.log(Level.FINE, iOException.toString(), iOException);
                    }
                }
            }
        }
        return false;
    }

    private String convertToClassName(String string) {
        return this.convertToClassName(null, string);
    }

    private String convertToClassName(String string, String string2) {
        String string3 = string2;
        if (string != null) {
            string3 = string3.substring(string.length());
        }
        string3 = string3.substring(0, string3.length() - 6);
        return string3.replace('/', '.');
    }

    private static class ConstantPoolInfo {
        private static final Logger LOGGER = FacesLogger.CONFIG.getLogger();
        public static final byte CLASS = 7;
        public static final int FIELDREF = 9;
        public static final int METHODREF = 10;
        public static final int STRING = 8;
        public static final int INTEGER = 3;
        public static final int FLOAT = 4;
        public static final int LONG = 5;
        public static final int DOUBLE = 6;
        public static final int INTERFACEMETHODREF = 11;
        public static final int NAMEANDTYPE = 12;
        public static final int ASCIZ = 1;
        public static final int UNICODE = 2;
        byte[] bytes = new byte[Short.MAX_VALUE];

        public boolean containsAnnotation(int n, ByteBuffer byteBuffer, ReadableByteChannel readableByteChannel) throws IOException {
            block7: for (int i = 1; i < n; ++i) {
                if (!this.refill(byteBuffer, readableByteChannel, 1)) {
                    return true;
                }
                byte by = byteBuffer.get();
                switch (by) {
                    case 1: 
                    case 2: {
                        String string;
                        if (!this.refill(byteBuffer, readableByteChannel, 2)) {
                            return true;
                        }
                        short s = byteBuffer.getShort();
                        if (s < 0 || s > Short.MAX_VALUE) {
                            return true;
                        }
                        if (s > byteBuffer.capacity()) {
                            return true;
                        }
                        if (!this.refill(byteBuffer, readableByteChannel, s)) {
                            return true;
                        }
                        byteBuffer.get(this.bytes, 0, s);
                        if (this.bytes[0] != 76 || this.bytes[1] != 106 || this.bytes[2] != 97 || !JavaClassScanningAnnotationScanner.isAnnotation(string = by == 1 ? new String(this.bytes, 0, (int)s, "US-ASCII") : new String(this.bytes, 0, (int)s))) continue block7;
                        return true;
                    }
                    case 7: 
                    case 8: {
                        if (!this.refill(byteBuffer, readableByteChannel, 2)) {
                            return true;
                        }
                        byteBuffer.getShort();
                        continue block7;
                    }
                    case 3: 
                    case 4: 
                    case 9: 
                    case 10: 
                    case 11: {
                        if (!this.refill(byteBuffer, readableByteChannel, 4)) {
                            return true;
                        }
                        byteBuffer.position(byteBuffer.position() + 4);
                        continue block7;
                    }
                    case 5: 
                    case 6: {
                        if (!this.refill(byteBuffer, readableByteChannel, 8)) {
                            return true;
                        }
                        byteBuffer.position(byteBuffer.position() + 8);
                        ++i;
                        continue block7;
                    }
                    case 12: {
                        if (!this.refill(byteBuffer, readableByteChannel, 4)) {
                            return true;
                        }
                        byteBuffer.getShort();
                        byteBuffer.getShort();
                        continue block7;
                    }
                    default: {
                        if (!LOGGER.isLoggable(Level.SEVERE)) continue block7;
                        LOGGER.log(Level.SEVERE, "Unknow type constant pool {0} at position {1}", new Object[]{by, i});
                    }
                }
            }
            return false;
        }

        private boolean refill(ByteBuffer byteBuffer, ReadableByteChannel readableByteChannel, int n) throws IOException {
            int n2 = byteBuffer.capacity();
            if (byteBuffer.position() + n > n2) {
                byteBuffer.compact();
                int n3 = readableByteChannel.read(byteBuffer);
                if (n3 < 0) {
                    return false;
                }
                byteBuffer.rewind();
            }
            return true;
        }
    }

    private static final class ClassFile {
        private static final int magic = -889275714;
        public static final int ACC_PUBLIC = 1;
        public static final int ACC_PRIVATE = 2;
        public static final int ACC_PROTECTED = 4;
        public static final int ACC_STATIC = 8;
        public static final int ACC_FINAL = 16;
        public static final int ACC_SYNCHRONIZED = 32;
        public static final int ACC_THREADSAFE = 64;
        public static final int ACC_TRANSIENT = 128;
        public static final int ACC_NATIVE = 256;
        public static final int ACC_INTERFACE = 512;
        public static final int ACC_ABSTRACT = 1024;
        public short majorVersion;
        public short minorVersion;
        public ConstantPoolInfo[] constantPool;
        public short accessFlags;
        public ConstantPoolInfo thisClass;
        public ConstantPoolInfo superClass;
        public ConstantPoolInfo[] interfaces;
        ByteBuffer header;
        ConstantPoolInfo constantPoolInfo = new ConstantPoolInfo();

        public ClassFile() {
            this.header = ByteBuffer.allocate(12000);
        }

        public void setConstantPoolInfo(ConstantPoolInfo constantPoolInfo) {
            this.constantPoolInfo = constantPoolInfo;
        }

        public boolean containsAnnotation(ReadableByteChannel readableByteChannel) throws IOException {
            this.header.clear();
            long l = readableByteChannel.read(this.header);
            if (l == -1L) {
                return false;
            }
            this.header.rewind();
            if (this.header.getInt() != -889275714) {
                return false;
            }
            this.minorVersion = this.header.getShort();
            this.majorVersion = this.header.getShort();
            short s = this.header.getShort();
            return this.constantPoolInfo.containsAnnotation(s, this.header, readableByteChannel);
        }
    }
}

