/*
 * Decompiled with CFR 0.152.
 */
package com.sun.faces.config;

import com.sun.faces.config.DocumentInfo;
import com.sun.faces.util.FacesLogger;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FacesConfigInfo {
    private static final Logger LOGGER = FacesLogger.CONFIG.getLogger();
    private static final String ABSOLUTE_ORDERING = "absolute-ordering";
    private static final String ORDERING = "ordering";
    private static final String NAME = "name";
    private static final String OTHERS = "others";
    private double version = 2.0;
    private boolean isWebInfFacesConfig;
    private boolean metadataComplete;
    private List<String> absoluteOrdering;

    public FacesConfigInfo(DocumentInfo documentInfo) {
        Document document = documentInfo.getDocument();
        this.isWebInfFacesConfig = this.isWebinfFacesConfig(document);
        this.version = this.getVersion(document);
        if (this.isWebInfFacesConfig && this.isVersionGreaterOrEqual(2.0)) {
            this.extractOrdering(document);
        }
        this.metadataComplete = this.isMetadataComplete(document);
    }

    public boolean isVersionGreaterOrEqual(double d) {
        return this.version >= d;
    }

    public boolean isWebInfFacesConfig() {
        return this.isWebInfFacesConfig;
    }

    public boolean isMetadataComplete() {
        return this.metadataComplete;
    }

    public List<String> getAbsoluteOrdering() {
        return this.absoluteOrdering != null ? Collections.unmodifiableList(this.absoluteOrdering) : null;
    }

    private double getVersion(Document document) {
        String string = document.getDocumentElement().getAttributeNS(document.getNamespaceURI(), "version");
        if (string != null && string.length() > 0) {
            return Double.parseDouble(string);
        }
        return 1.1;
    }

    private boolean isWebinfFacesConfig(Document document) {
        String string = document.getDocumentElement().getAttribute("com.sun.faces.webinf");
        return string != null && string.length() > 0;
    }

    private boolean isMetadataComplete(Document document) {
        if (this.isVersionGreaterOrEqual(2.0)) {
            String string = document.getDocumentElement().getAttributeNS(document.getNamespaceURI(), "metadata-complete");
            return string != null ? Boolean.valueOf(string) : false;
        }
        return true;
    }

    private void extractOrdering(Document document) {
        NodeList nodeList;
        String string;
        Element element = document.getDocumentElement();
        NodeList nodeList2 = element.getElementsByTagNameNS(string = element.getNamespaceURI(), ORDERING);
        if (nodeList2.getLength() > 0 && LOGGER.isLoggable(Level.WARNING)) {
            LOGGER.warning("jsf.configuration.web.faces.config.contains.ordering");
        }
        if ((nodeList = element.getElementsByTagNameNS(string, ABSOLUTE_ORDERING)).getLength() > 0) {
            if (nodeList.getLength() > 1) {
                throw new IllegalStateException("Multiple 'absolute-ordering' elements found within WEB-INF/faces-config.xml");
            }
            Node node = nodeList.item(0);
            NodeList nodeList3 = node.getChildNodes();
            this.absoluteOrdering = new ArrayList<String>(nodeList3.getLength());
            int n = nodeList3.getLength();
            for (int i = 0; i < n; ++i) {
                Node node2 = nodeList3.item(i);
                if (NAME.equals(node2.getLocalName())) {
                    this.absoluteOrdering.add(this.getNodeText(node2));
                    continue;
                }
                if (!OTHERS.equals(node2.getLocalName())) continue;
                if (this.absoluteOrdering.contains(OTHERS)) {
                    throw new IllegalStateException("'absolute-ordering' element defined with multiple 'others' child elements found within WEB-INF/faces-config.xml");
                }
                this.absoluteOrdering.add(OTHERS);
            }
        }
    }

    private String getNodeText(Node node) {
        String string = null;
        if (node != null && (string = node.getTextContent()) != null) {
            string = string.trim();
        }
        return string != null && string.length() != 0 ? string : null;
    }
}

