/*
 * Decompiled with CFR 0.152.
 */
package com.sun.faces.config;

import com.sun.faces.config.WebConfiguration;
import com.sun.faces.scripting.ScriptManager;
import com.sun.faces.scripting.groovy.GroovyHelper;
import com.sun.faces.scripting.groovy.GroovyScriptManager;
import com.sun.faces.spi.AnnotationProvider;
import com.sun.faces.util.FacesLogger;
import com.sun.faces.util.Util;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.faces.bean.ManagedBean;
import javax.faces.component.FacesComponent;
import javax.faces.component.behavior.FacesBehavior;
import javax.faces.context.FacesContext;
import javax.faces.convert.FacesConverter;
import javax.faces.event.NamedEvent;
import javax.faces.render.FacesBehaviorRenderer;
import javax.faces.render.FacesRenderer;
import javax.faces.validator.FacesValidator;
import javax.servlet.ServletContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AnnotationScanner
extends AnnotationProvider {
    private static final Logger LOGGER = FacesLogger.CONFIG.getLogger();
    private static final String WILDCARD = "*";
    protected static final Set<String> FACES_ANNOTATIONS;
    protected static final Set<Class<? extends Annotation>> FACES_ANNOTATION_TYPE;
    private List<ScriptManager> scriptManagers = new ArrayList<ScriptManager>();
    private boolean isAnnotationScanPackagesSet = false;
    private String[] webInfClassesPackages;
    private Map<String, String[]> classpathPackages;

    public AnnotationScanner(ServletContext servletContext) {
        super(servletContext);
        if (GroovyHelper.isGroovyAvailable(FacesContext.getCurrentInstance())) {
            this.scriptManagers.add(new GroovyScriptManager(servletContext));
        }
        WebConfiguration webConfiguration = WebConfiguration.getInstance(servletContext);
        this.initializeAnnotationScanPackages(webConfiguration);
    }

    private void initializeAnnotationScanPackages(WebConfiguration webConfiguration) {
        if (!webConfiguration.isSet(WebConfiguration.WebContextInitParameter.AnnotationScanPackages)) {
            return;
        }
        this.isAnnotationScanPackagesSet = true;
        this.classpathPackages = new HashMap<String, String[]>(4);
        this.webInfClassesPackages = new String[0];
        String[] stringArray = webConfiguration.getOptionValue(WebConfiguration.WebContextInitParameter.AnnotationScanPackages, "\\s+");
        ArrayList<String> arrayList = new ArrayList<String>(4);
        for (String string : stringArray) {
            if (string.length() == 0) continue;
            if (string.startsWith("jar:")) {
                String[] stringArray2 = Util.split(string, ":");
                if (stringArray2.length != 3) {
                    if (!LOGGER.isLoggable(Level.WARNING)) continue;
                    LOGGER.log(Level.WARNING, "jsf.annotation.scanner.configuration.invalid", new String[]{WebConfiguration.WebContextInitParameter.AnnotationScanPackages.getQualifiedName(), string});
                    continue;
                }
                if (WILDCARD.equals(stringArray2[1]) && !this.classpathPackages.containsKey(WILDCARD)) {
                    this.classpathPackages.clear();
                    this.classpathPackages.put(WILDCARD, this.normalizeJarPackages(Util.split(stringArray2[2], ",")));
                    continue;
                }
                if (WILDCARD.equals(stringArray2[1]) && this.classpathPackages.containsKey(WILDCARD)) {
                    if (!LOGGER.isLoggable(Level.WARNING)) continue;
                    LOGGER.log(Level.WARNING, "jsf.annotation.scanner.configuration.duplicate.wildcard", new String[]{WebConfiguration.WebContextInitParameter.AnnotationScanPackages.getQualifiedName(), string});
                    continue;
                }
                if (this.classpathPackages.containsKey(WILDCARD)) continue;
                this.classpathPackages.put(stringArray2[1], this.normalizeJarPackages(Util.split(stringArray2[2], ",")));
                continue;
            }
            if (WILDCARD.equals(string) && !arrayList.contains(WILDCARD)) {
                arrayList.clear();
                arrayList.add(WILDCARD);
                continue;
            }
            if (arrayList.contains(WILDCARD)) continue;
            arrayList.add(string);
        }
        this.webInfClassesPackages = arrayList.toArray(new String[arrayList.size()]);
    }

    private String[] normalizeJarPackages(String[] stringArray) {
        if (stringArray.length == 0) {
            return stringArray;
        }
        ArrayList<String> arrayList = new ArrayList<String>(stringArray.length);
        for (String string : stringArray) {
            if (WILDCARD.equals(string)) {
                arrayList.clear();
                arrayList.add(WILDCARD);
                break;
            }
            arrayList.add(string);
        }
        return arrayList.toArray(new String[arrayList.size()]);
    }

    protected boolean processJar(String string) {
        return this.classpathPackages == null || this.classpathPackages.containsKey(string) || this.classpathPackages.containsKey(WILDCARD);
    }

    protected boolean processClass(String string) {
        return this.processClass(string, this.webInfClassesPackages);
    }

    protected boolean processClass(String string, String[] stringArray) {
        if (stringArray == null) {
            return true;
        }
        for (String string2 : stringArray) {
            if (!string.startsWith(string2) && !WILDCARD.equals(string2)) continue;
            return true;
        }
        return false;
    }

    protected Map<Class<? extends Annotation>, Set<Class<?>>> processClassList(Set<String> set) {
        Map<Class<Annotation>, Set<Class<?>>> map = null;
        if (set.size() > 0) {
            map = new HashMap(6, 1.0f);
            for (String string : set) {
                try {
                    Annotation[] annotationArray;
                    Class clazz = Util.loadClass(string, this);
                    for (Annotation annotation : annotationArray = clazz.getAnnotations()) {
                        Class<? extends Annotation> clazz2 = annotation.annotationType();
                        if (!FACES_ANNOTATION_TYPE.contains(clazz2)) continue;
                        Set<Class<?>> set2 = map.get(clazz2);
                        if (set2 == null) {
                            set2 = new HashSet();
                            map.put(clazz2, set2);
                        }
                        set2.add(clazz);
                    }
                }
                catch (ClassNotFoundException classNotFoundException) {
                    if (!LOGGER.isLoggable(Level.SEVERE)) continue;
                    LOGGER.log(Level.SEVERE, "Unable to load annotated class: {0}", string);
                    LOGGER.log(Level.SEVERE, "", classNotFoundException);
                }
                catch (NoClassDefFoundError noClassDefFoundError) {
                    if (!LOGGER.isLoggable(Level.SEVERE)) continue;
                    LOGGER.log(Level.SEVERE, "Unable to load annotated class: {0}, reason: {1}", new Object[]{string, noClassDefFoundError.toString()});
                }
            }
        }
        return map != null ? map : Collections.emptyMap();
    }

    protected void processScripts(Set<String> set) {
        for (ScriptManager scriptManager : this.scriptManagers) {
            set.addAll(scriptManager.getScripts());
        }
    }

    protected boolean isAnnotationScanPackagesSet() {
        return this.isAnnotationScanPackagesSet;
    }

    protected Map<String, String[]> getClasspathPackages() {
        return this.classpathPackages;
    }

    protected String[] getWebInfClassesPackages() {
        return this.webInfClassesPackages;
    }

    static {
        HashSet hashSet = new HashSet(8, 1.0f);
        Collections.addAll(hashSet, "Ljavax/faces/component/FacesComponent;", "Ljavax/faces/convert/FacesConverter;", "Ljavax/faces/validator/FacesValidator;", "Ljavax/faces/render/FacesRenderer;", "Ljavax/faces/bean/ManagedBean;", "Ljavax/faces/event/NamedEvent;", "Ljavax/faces/component/behavior/FacesBehavior;", "Ljavax/faces/render/FacesBehaviorRenderer;", "javax.faces.component.FacesComponent", "javax.faces.convert.FacesConverter", "javax.faces.validator.FacesValidator", "javax.faces.render.FacesRenderer", "javax.faces.bean.ManagedBean", "javax.faces.event.NamedEvent", "javax.faces.component.behavior.FacesBehavior", "javax.faces.render.FacesBehaviorRenderer");
        FACES_ANNOTATIONS = Collections.unmodifiableSet(hashSet);
        HashSet hashSet2 = new HashSet(8, 1.0f);
        Collections.addAll(hashSet2, FacesComponent.class, FacesConverter.class, FacesValidator.class, FacesRenderer.class, ManagedBean.class, NamedEvent.class, FacesBehavior.class, FacesBehaviorRenderer.class);
        FACES_ANNOTATION_TYPE = Collections.unmodifiableSet(hashSet2);
    }
}

