/*
 * Decompiled with CFR 0.152.
 */
package com.sun.faces.application.resource;

import com.sun.faces.application.resource.ResourceHelper;
import com.sun.faces.application.resource.VersionInfo;

public class LibraryInfo {
    private String name;
    private VersionInfo version;
    private String localePrefix;
    private ResourceHelper helper;
    private String path;

    LibraryInfo(String string, VersionInfo versionInfo, String string2, ResourceHelper resourceHelper) {
        this.name = string;
        this.version = versionInfo;
        this.localePrefix = string2;
        this.helper = resourceHelper;
        this.initPath();
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        if (this == object) {
            return true;
        }
        LibraryInfo libraryInfo = (LibraryInfo)object;
        if (this.name == null ? libraryInfo.name != null : !this.name.equals(libraryInfo.name)) {
            return false;
        }
        if (!(this.version == libraryInfo.version || this.version != null && this.version.equals(libraryInfo.version))) {
            return false;
        }
        if (this.localePrefix == null ? libraryInfo.localePrefix != null : !this.localePrefix.equals(libraryInfo.localePrefix)) {
            return false;
        }
        return !(this.path == null ? libraryInfo.path != null : !this.path.equals(libraryInfo.path));
    }

    public int hashCode() {
        int n = 5;
        n = 37 * n + (this.name != null ? this.name.hashCode() : 0);
        n = 37 * n + (this.version != null ? this.version.hashCode() : 0);
        n = 37 * n + (this.localePrefix != null ? this.localePrefix.hashCode() : 0);
        n = 37 * n + (this.path != null ? this.path.hashCode() : 0);
        return n;
    }

    public String getName() {
        return this.name;
    }

    public VersionInfo getVersion() {
        return this.version;
    }

    public ResourceHelper getHelper() {
        return this.helper;
    }

    public String getPath() {
        return this.path;
    }

    public String getLocalePrefix() {
        return this.localePrefix;
    }

    public String toString() {
        return "LibraryInfo{name='" + this.name + '\'' + ", version=" + (this.version != null ? this.version : "NONE") + '\'' + ", localePrefix='" + (this.localePrefix != null ? this.localePrefix : "NONE") + '\'' + ", path='" + this.path + '\'' + '}';
    }

    private void initPath() {
        StringBuilder stringBuilder = new StringBuilder(64);
        stringBuilder.append(this.helper.getBaseResourcePath());
        if (this.localePrefix != null) {
            stringBuilder.append('/').append(this.localePrefix);
        }
        stringBuilder.append('/').append(this.name);
        if (this.version != null) {
            stringBuilder.append('/').append(this.version.getVersion());
        }
        this.path = stringBuilder.toString();
    }
}

