/*
 * Decompiled with CFR 0.152.
 */
package com.sun.faces.application.resource;

import com.sun.faces.application.resource.LibraryInfo;
import com.sun.faces.application.resource.ResourceHelper;
import com.sun.faces.application.resource.ResourceInfo;
import com.sun.faces.application.resource.ZipDirectoryEntryScanner;
import com.sun.faces.config.WebConfiguration;
import com.sun.faces.util.Util;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import javax.faces.application.ProjectStage;
import javax.faces.context.FacesContext;

public class ClasspathResourceHelper
extends ResourceHelper {
    private static final String BASE_RESOURCE_PATH = "META-INF/resources";
    private boolean cacheTimestamp;
    private volatile ZipDirectoryEntryScanner libraryScanner;
    private boolean enableMissingResourceLibraryDetection;

    public ClasspathResourceHelper() {
        WebConfiguration webConfiguration = WebConfiguration.getInstance();
        this.cacheTimestamp = webConfiguration.isOptionEnabled(WebConfiguration.BooleanWebContextInitParameter.CacheResourceModificationTimestamp);
        this.enableMissingResourceLibraryDetection = webConfiguration.isOptionEnabled(WebConfiguration.BooleanWebContextInitParameter.EnableMissingResourceLibraryDetection);
    }

    public String getBaseResourcePath() {
        return BASE_RESOURCE_PATH;
    }

    protected InputStream getNonCompressedInputStream(ResourceInfo resourceInfo, FacesContext facesContext) throws IOException {
        String string;
        ClassLoader classLoader = Util.getCurrentLoader(this.getClass());
        InputStream inputStream = classLoader.getResourceAsStream(string = resourceInfo.getPath());
        if (inputStream == null) {
            inputStream = this.getClass().getClassLoader().getResourceAsStream(string);
        }
        return inputStream;
    }

    public URL getURL(ResourceInfo resourceInfo, FacesContext facesContext) {
        ClassLoader classLoader = Util.getCurrentLoader(this.getClass());
        URL uRL = classLoader.getResource(resourceInfo.getPath());
        if (uRL == null) {
            uRL = this.getClass().getClassLoader().getResource(resourceInfo.getPath());
        }
        return uRL;
    }

    public LibraryInfo findLibrary(String string, String string2, FacesContext facesContext) {
        ClassLoader classLoader = Util.getCurrentLoader(this);
        String string3 = string2 == null ? this.getBaseResourcePath() + '/' + string + '/' : this.getBaseResourcePath() + '/' + string2 + '/' + string + '/';
        URL uRL = classLoader.getResource(string3);
        if (uRL == null && (uRL = this.getClass().getClassLoader().getResource(string3)) == null) {
            return null;
        }
        return new LibraryInfo(string, null, string2, this);
    }

    public LibraryInfo findLibraryWithZipDirectoryEntryScan(String string, String string2, FacesContext facesContext, boolean bl) {
        ClassLoader classLoader = Util.getCurrentLoader(this);
        String string3 = string2 == null ? this.getBaseResourcePath() + '/' + string + '/' : this.getBaseResourcePath() + '/' + string2 + '/' + string + '/';
        URL uRL = classLoader.getResource(string3);
        if (uRL == null && (uRL = this.getClass().getClassLoader().getResource(string3)) == null) {
            if (null != string2 && string.equals("javax.faces")) {
                return null;
            }
            if (this.enableMissingResourceLibraryDetection || bl) {
                if (null == this.libraryScanner) {
                    this.libraryScanner = new ZipDirectoryEntryScanner();
                }
                if (!this.libraryScanner.libraryExists(string, string2)) {
                    return null;
                }
            }
        }
        return new LibraryInfo(string, null, string2, this);
    }

    public ResourceInfo findResource(LibraryInfo libraryInfo, String string, String string2, boolean bl, FacesContext facesContext) {
        ClassLoader classLoader = Util.getCurrentLoader(this);
        String string3 = libraryInfo != null ? libraryInfo.getPath() + '/' + string : (string2 == null ? this.getBaseResourcePath() + '/' + string : this.getBaseResourcePath() + '/' + string2 + '/' + string);
        URL uRL = classLoader.getResource(string3);
        if (uRL == null && (uRL = this.getClass().getClassLoader().getResource(string3)) == null) {
            return null;
        }
        ResourceInfo resourceInfo = libraryInfo != null ? new ResourceInfo(libraryInfo, string, null, bl, this.resourceSupportsEL(string, facesContext), facesContext.isProjectStage(ProjectStage.Development), this.cacheTimestamp) : new ResourceInfo(string, null, string2, this, bl, this.resourceSupportsEL(string, facesContext), facesContext.isProjectStage(ProjectStage.Development), this.cacheTimestamp);
        if (resourceInfo.isCompressable()) {
            resourceInfo = this.handleCompression(resourceInfo);
        }
        return resourceInfo;
    }
}

