/*
 * Decompiled with CFR 0.152.
 */
package com.sun.faces.application;

import com.sun.faces.application.ApplicationAssociate;
import com.sun.faces.application.SharedUtils;
import com.sun.faces.util.FacesLogger;
import com.sun.faces.util.MessageUtils;
import com.sun.faces.util.Util;
import java.io.IOException;
import java.util.AbstractCollection;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import javax.faces.FacesException;
import javax.faces.application.ConfigurableNavigationHandler;
import javax.faces.application.FacesMessage;
import javax.faces.application.NavigationCase;
import javax.faces.application.ViewHandler;
import javax.faces.component.UIViewRoot;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import javax.faces.context.PartialViewContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NavigationHandlerImpl
extends ConfigurableNavigationHandler {
    private static final Logger logger = FacesLogger.APPLICATION.getLogger();
    private volatile NavigationMap navigationMap;
    private boolean development;
    private static final Pattern REDIRECT_EQUALS_TRUE = Pattern.compile("(.*)(faces-redirect=true)(.*)");
    private static final Pattern INCLUDE_VIEW_PARAMS_EQUALS_TRUE = Pattern.compile("(.*)(includeViewParams=true)(.*)");

    public NavigationHandlerImpl() {
        ApplicationAssociate applicationAssociate;
        if (logger.isLoggable(Level.FINE)) {
            logger.log(Level.FINE, "Created NavigationHandler instance ");
        }
        if ((applicationAssociate = ApplicationAssociate.getInstance(FacesContext.getCurrentInstance().getExternalContext())) != null) {
            this.development = applicationAssociate.isDevModeEnabled();
        }
    }

    public NavigationCase getNavigationCase(FacesContext facesContext, String string, String string2) {
        Util.notNull("context", facesContext);
        NavigationCase navigationCase = null;
        CaseStruct caseStruct = this.getViewId(facesContext, string, string2);
        if (null != caseStruct) {
            navigationCase = caseStruct.navCase;
        }
        return navigationCase;
    }

    public Map<String, Set<NavigationCase>> getNavigationCases() {
        if (this.navigationMap == null) {
            this.navigationMap = new NavigationMap();
        }
        return this.navigationMap;
    }

    public void handleNavigation(FacesContext facesContext, String string, String string2) {
        Util.notNull("context", facesContext);
        CaseStruct caseStruct = this.getViewId(facesContext, string, string2);
        if (caseStruct != null) {
            ExternalContext externalContext = facesContext.getExternalContext();
            ViewHandler viewHandler = Util.getViewHandler(facesContext);
            assert (null != viewHandler);
            if (caseStruct.navCase.isRedirect()) {
                String string3 = viewHandler.getRedirectURL(facesContext, caseStruct.viewId, SharedUtils.evaluateExpressions(facesContext, caseStruct.navCase.getParameters()), caseStruct.navCase.isIncludeViewParams());
                try {
                    if (logger.isLoggable(Level.FINE)) {
                        logger.fine("Redirecting to path " + string3 + " for outcome " + string2 + "and viewId " + caseStruct.viewId);
                    }
                    this.clearViewMapIfNecessary(facesContext.getViewRoot(), caseStruct.viewId);
                    this.updateRenderTargets(facesContext, caseStruct.viewId);
                    externalContext.getFlash().setRedirect(true);
                    externalContext.redirect(string3);
                }
                catch (IOException iOException) {
                    if (logger.isLoggable(Level.FINE)) {
                        logger.log(Level.FINE, "jsf.redirect_failed_error", string3);
                    }
                    throw new FacesException(iOException.getMessage(), (Throwable)iOException);
                }
                facesContext.responseComplete();
                if (logger.isLoggable(Level.FINE)) {
                    logger.fine("Response complete for " + caseStruct.viewId);
                }
            } else {
                UIViewRoot uIViewRoot = viewHandler.createView(facesContext, caseStruct.viewId);
                this.updateRenderTargets(facesContext, caseStruct.viewId);
                facesContext.setViewRoot(uIViewRoot);
                if (logger.isLoggable(Level.FINE)) {
                    logger.fine("Set new view in FacesContext for " + caseStruct.viewId);
                }
            }
        }
    }

    private void initializeNavigationFromAssociate() {
        ApplicationAssociate applicationAssociate = ApplicationAssociate.getCurrentInstance();
        if (applicationAssociate != null) {
            Map<String, Set<NavigationCase>> map = applicationAssociate.getNavigationCaseListMappings();
            this.navigationMap = new NavigationMap();
            if (map != null) {
                this.navigationMap.putAll((Map<? extends String, ? extends Set<NavigationCase>>)map);
            }
        }
    }

    private void clearViewMapIfNecessary(UIViewRoot uIViewRoot, String string) {
        Map map;
        if (!uIViewRoot.getViewId().equals(string) && (map = uIViewRoot.getViewMap(false)) != null) {
            map.clear();
        }
    }

    private void updateRenderTargets(FacesContext facesContext, String string) {
        PartialViewContext partialViewContext;
        if (!facesContext.getViewRoot().getViewId().equals(string) && !(partialViewContext = facesContext.getPartialViewContext()).isRenderAll()) {
            partialViewContext.setRenderAll(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CaseStruct getViewId(FacesContext facesContext, String string, String string2) {
        NavigationHandlerImpl navigationHandlerImpl;
        if (this.navigationMap == null) {
            navigationHandlerImpl = this;
            synchronized (navigationHandlerImpl) {
                this.initializeNavigationFromAssociate();
            }
        }
        String string3 = (navigationHandlerImpl = facesContext.getViewRoot()) != null ? navigationHandlerImpl.getViewId() : null;
        CaseStruct caseStruct = null;
        if (string3 != null && (caseStruct = this.findExactMatch(facesContext, string3, string, string2)) == null) {
            caseStruct = this.findWildCardMatch(facesContext, string3, string, string2);
        }
        if (caseStruct == null) {
            caseStruct = this.findDefaultMatch(facesContext, string, string2);
        }
        if (caseStruct == null && string2 != null && string3 != null) {
            if (caseStruct == null && 0 == string2.length()) {
                string2 = null;
            } else {
                caseStruct = this.findImplicitMatch(facesContext, string3, string, string2);
            }
        }
        if (caseStruct == null && string2 != null && this.development) {
            Object[] objectArray;
            String string4;
            if (string == null) {
                string4 = "com.sun.faces.NAVIGATION_NO_MATCHING_OUTCOME";
                objectArray = new Object[]{string3, string2};
            } else {
                string4 = "com.sun.faces.NAVIGATION_NO_MATCHING_OUTCOME_ACTION";
                objectArray = new Object[]{string3, string, string2};
            }
            FacesMessage facesMessage = MessageUtils.getExceptionMessage(string4, objectArray);
            facesMessage.setSeverity(FacesMessage.SEVERITY_WARN);
            facesContext.addMessage(null, facesMessage);
        }
        return caseStruct;
    }

    private CaseStruct findExactMatch(FacesContext facesContext, String string, String string2, String string3) {
        Set set = (Set)this.navigationMap.get(string);
        if (set == null) {
            return null;
        }
        return this.determineViewFromActionOutcome(facesContext, set, string2, string3);
    }

    private CaseStruct findWildCardMatch(FacesContext facesContext, String string, String string2, String string3) {
        CaseStruct caseStruct = null;
        for (String string4 : this.navigationMap.wildcardMatchList) {
            if (!string.startsWith(string4)) continue;
            String string5 = new StringBuilder(32).append(string4).append('*').toString();
            Set set = (Set)this.navigationMap.get(string5);
            if (set == null) {
                return null;
            }
            caseStruct = this.determineViewFromActionOutcome(facesContext, set, string2, string3);
            if (caseStruct == null) continue;
            break;
        }
        return caseStruct;
    }

    private CaseStruct findDefaultMatch(FacesContext facesContext, String string, String string2) {
        Set set = (Set)this.navigationMap.get("*");
        if (set == null) {
            return null;
        }
        return this.determineViewFromActionOutcome(facesContext, set, string, string2);
    }

    private CaseStruct findImplicitMatch(FacesContext facesContext, String string, String string2, String string3) {
        ViewHandler viewHandler;
        Object object;
        int n;
        String string4 = string3;
        String string5 = string;
        LinkedHashMap<String, ArrayList<String>> linkedHashMap = null;
        boolean bl = false;
        boolean bl2 = false;
        int n2 = string4.indexOf(63);
        if (-1 != n2) {
            String string6;
            n = string4.length();
            if (n <= n2 + 1) {
                if (logger.isLoggable(Level.SEVERE)) {
                    logger.log(Level.SEVERE, "jsf.navigation_invalid_query_string", string4);
                }
                if (this.development) {
                    object = "com.sun.faces.NAVIGATION_INVALID_QUERY_STRING";
                    Object[] objectArray = new Object[]{string4};
                    FacesMessage facesMessage = MessageUtils.getExceptionMessage((String)object, objectArray);
                    facesMessage.setSeverity(FacesMessage.SEVERITY_WARN);
                    facesContext.addMessage(null, facesMessage);
                }
                string6 = null;
                string4 = string4.substring(0, n2);
            } else {
                string6 = string4.substring(n2 + 1);
                string4 = string4.substring(0, n2);
                object = REDIRECT_EQUALS_TRUE.matcher(string6);
                if (object.find()) {
                    bl = true;
                    string6 = string6.replace(object.group(2), "");
                }
                if ((object = INCLUDE_VIEW_PARAMS_EQUALS_TRUE.matcher(string6)).find()) {
                    bl2 = true;
                    string6 = string6.replace(object.group(2), "");
                }
            }
            if (string6 != null && string6.length() > 0) {
                object = Util.split(string6, "&amp;|&");
                int n3 = ((String[])object).length;
                for (int i = 0; i < n3; ++i) {
                    ArrayList<String> arrayList;
                    String[] stringArray = Util.split(object[i], "=");
                    if (stringArray.length != 2) continue;
                    if (linkedHashMap == null) {
                        linkedHashMap = new LinkedHashMap<String, ArrayList<String>>(n3 / 2, 1.0f);
                        arrayList = new ArrayList<String>(2);
                        arrayList.add(stringArray[1]);
                        linkedHashMap.put(stringArray[0], arrayList);
                        continue;
                    }
                    arrayList = (ArrayList<String>)linkedHashMap.get(stringArray[0]);
                    if (arrayList == null) {
                        arrayList = new ArrayList(2);
                        linkedHashMap.put(stringArray[0], arrayList);
                    }
                    arrayList.add(stringArray[1]);
                }
            }
        }
        if (string4.lastIndexOf(46) == -1 && (n = string5.lastIndexOf(46)) != -1) {
            string4 = string4 + string5.substring(n);
        }
        if (!string4.startsWith("/")) {
            n = string5.lastIndexOf("/");
            if (n != -1) {
                string5 = string5.substring(0, n + 1);
                string4 = string5 + string4;
            } else {
                string4 = "/" + string4;
            }
        }
        if (null != (string4 = (viewHandler = Util.getViewHandler(facesContext)).deriveViewId(facesContext, string4))) {
            object = new CaseStruct();
            object.viewId = string4;
            object.navCase = new NavigationCase(string5, string2, string3, null, string4, linkedHashMap, bl, bl2);
            return object;
        }
        return null;
    }

    private CaseStruct determineViewFromActionOutcome(FacesContext facesContext, Set<NavigationCase> set, String string, String string2) {
        CaseStruct caseStruct = new CaseStruct();
        boolean bl = false;
        for (NavigationCase navigationCase : set) {
            String string3 = navigationCase.getFromAction();
            String string4 = navigationCase.getFromOutcome();
            boolean bl2 = navigationCase.hasCondition();
            String string5 = navigationCase.getToViewId(facesContext);
            if (string3 != null && string4 != null) {
                if (string3.equals(string) && string4.equals(string2)) {
                    caseStruct.viewId = string5;
                    caseStruct.navCase = navigationCase;
                    bl = true;
                }
            } else if (string3 == null && string4 != null) {
                if (string4.equals(string2)) {
                    caseStruct.viewId = string5;
                    caseStruct.navCase = navigationCase;
                    bl = true;
                }
            } else if (string3 != null && string4 == null) {
                if (string3.equals(string) && (string2 != null || bl2)) {
                    caseStruct.viewId = string5;
                    caseStruct.navCase = navigationCase;
                    bl = true;
                }
            } else if (string3 == null && string4 == null && (string2 != null || bl2)) {
                caseStruct.viewId = string5;
                caseStruct.navCase = navigationCase;
                bl = true;
            }
            if (!bl) continue;
            if (bl2 && Boolean.FALSE.equals(navigationCase.getCondition(facesContext))) {
                bl = false;
                continue;
            }
            return caseStruct;
        }
        return null;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class NavigationMap
    extends AbstractMap<String, Set<NavigationCase>> {
        private HashMap<String, Set<NavigationCase>> navigationMap = new HashMap();
        private TreeSet<String> wildcardMatchList = new TreeSet<String>(new Comparator<String>(){

            @Override
            public int compare(String string, String string2) {
                return -string.compareTo(string2);
            }
        });

        private NavigationMap() {
        }

        @Override
        public int size() {
            return this.navigationMap.size();
        }

        @Override
        public boolean isEmpty() {
            return this.navigationMap.isEmpty();
        }

        @Override
        public Set<NavigationCase> put(String string, Set<NavigationCase> set) {
            if (string == null) {
                throw new IllegalArgumentException(string);
            }
            if (set == null) {
                throw new IllegalArgumentException();
            }
            this.updateWildcards(string);
            Set<NavigationCase> set2 = this.navigationMap.get(string);
            if (set2 == null) {
                this.navigationMap.put(string, set);
                return null;
            }
            set2.addAll(set);
            return set2;
        }

        @Override
        public void putAll(Map<? extends String, ? extends Set<NavigationCase>> map) {
            if (map == null) {
                return;
            }
            for (Map.Entry<? extends String, ? extends Set<NavigationCase>> entry : map.entrySet()) {
                String string = entry.getKey();
                this.updateWildcards(string);
                Set<NavigationCase> set = this.navigationMap.get(string);
                if (set == null) {
                    this.navigationMap.put(string, entry.getValue());
                    continue;
                }
                set.addAll((Collection<NavigationCase>)entry.getValue());
            }
        }

        @Override
        public Set<String> keySet() {
            return new AbstractSet<String>(){

                @Override
                public Iterator<String> iterator() {
                    return new Iterator<String>(){
                        Iterator<Map.Entry<String, Set<NavigationCase>>> i;
                        {
                            this.i = NavigationMap.this.entrySet().iterator();
                        }

                        @Override
                        public boolean hasNext() {
                            return this.i.hasNext();
                        }

                        @Override
                        public String next() {
                            return this.i.next().getKey();
                        }

                        @Override
                        public void remove() {
                            throw new UnsupportedOperationException();
                        }
                    };
                }

                @Override
                public int size() {
                    return NavigationMap.this.size();
                }
            };
        }

        @Override
        public Collection<Set<NavigationCase>> values() {
            return new AbstractCollection<Set<NavigationCase>>(){

                @Override
                public Iterator<Set<NavigationCase>> iterator() {
                    return new Iterator<Set<NavigationCase>>(){
                        Iterator<Map.Entry<String, Set<NavigationCase>>> i;
                        {
                            this.i = NavigationMap.this.entrySet().iterator();
                        }

                        @Override
                        public boolean hasNext() {
                            return this.i.hasNext();
                        }

                        @Override
                        public Set<NavigationCase> next() {
                            return this.i.next().getValue();
                        }

                        @Override
                        public void remove() {
                            throw new UnsupportedOperationException();
                        }
                    };
                }

                @Override
                public int size() {
                    return NavigationMap.this.size();
                }
            };
        }

        @Override
        public Set<Map.Entry<String, Set<NavigationCase>>> entrySet() {
            return new AbstractSet<Map.Entry<String, Set<NavigationCase>>>(){

                @Override
                public Iterator<Map.Entry<String, Set<NavigationCase>>> iterator() {
                    return new Iterator<Map.Entry<String, Set<NavigationCase>>>(){
                        Iterator<Map.Entry<String, Set<NavigationCase>>> i;
                        {
                            this.i = NavigationMap.this.navigationMap.entrySet().iterator();
                        }

                        @Override
                        public boolean hasNext() {
                            return this.i.hasNext();
                        }

                        @Override
                        public Map.Entry<String, Set<NavigationCase>> next() {
                            return this.i.next();
                        }

                        @Override
                        public void remove() {
                            throw new UnsupportedOperationException();
                        }
                    };
                }

                @Override
                public int size() {
                    return NavigationMap.this.size();
                }
            };
        }

        private void updateWildcards(String string) {
            if (!this.navigationMap.containsKey(string) && string.endsWith("*")) {
                this.wildcardMatchList.add(string.substring(0, string.lastIndexOf(42)));
            }
        }
    }

    private static class CaseStruct {
        String viewId;
        NavigationCase navCase;

        private CaseStruct() {
        }
    }
}

