/*
 * Decompiled with CFR 0.152.
 */
package com.structurizr.view;

import com.structurizr.model.Container;
import com.structurizr.model.ContainerInstance;
import com.structurizr.model.DeploymentNode;
import com.structurizr.model.Element;
import com.structurizr.model.Relationship;
import com.structurizr.model.SoftwareSystem;
import com.structurizr.model.SoftwareSystemInstance;
import com.structurizr.util.StringUtils;
import com.structurizr.util.TagUtils;
import com.structurizr.view.Border;
import com.structurizr.view.ElementStyle;
import com.structurizr.view.RelationshipStyle;
import com.structurizr.view.Routing;
import com.structurizr.view.Shape;
import com.structurizr.view.Theme;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;

public final class Styles {
    private static final Integer DEFAULT_WIDTH_OF_ELEMENT = 450;
    private static final Integer DEFAULT_HEIGHT_OF_ELEMENT = 300;
    private static final Integer DEFAULT_WIDTH_OF_PERSON = 400;
    private static final Integer DEFAULT_HEIGHT_OF_PERSON = 400;
    private Collection<ElementStyle> elements = new LinkedList<ElementStyle>();
    private Collection<RelationshipStyle> relationships = new LinkedList<RelationshipStyle>();
    private List<Theme> themes = new ArrayList<Theme>();

    public Collection<ElementStyle> getElements() {
        return this.elements;
    }

    public void add(ElementStyle elementStyle) {
        if (elementStyle != null) {
            if (StringUtils.isNullOrEmpty(elementStyle.getTag())) {
                throw new IllegalArgumentException("A tag must be specified.");
            }
            if (this.elements.stream().anyMatch(es -> es.getTag().equals(elementStyle.getTag()))) {
                throw new IllegalArgumentException("An element style for the tag \"" + elementStyle.getTag() + "\" already exists.");
            }
            this.elements.add(elementStyle);
        }
    }

    public ElementStyle addElementStyle(String tag) {
        ElementStyle elementStyle = new ElementStyle(tag);
        this.add(elementStyle);
        return elementStyle;
    }

    public void clearElementStyles() {
        this.elements = new LinkedList<ElementStyle>();
    }

    public void clearRelationshipStyles() {
        this.relationships = new LinkedList<RelationshipStyle>();
    }

    public Collection<RelationshipStyle> getRelationships() {
        return this.relationships;
    }

    public void add(RelationshipStyle relationshipStyle) {
        if (relationshipStyle != null) {
            if (StringUtils.isNullOrEmpty(relationshipStyle.getTag())) {
                throw new IllegalArgumentException("A tag must be specified.");
            }
            if (this.relationships.stream().anyMatch(es -> es.getTag().equals(relationshipStyle.getTag()))) {
                throw new IllegalArgumentException("A relationship style for the tag \"" + relationshipStyle.getTag() + "\" already exists.");
            }
            this.relationships.add(relationshipStyle);
        }
    }

    public RelationshipStyle addRelationshipStyle(String tag) {
        RelationshipStyle relationshipStyle = new RelationshipStyle(tag);
        this.add(relationshipStyle);
        return relationshipStyle;
    }

    public ElementStyle getElementStyle(String tag) {
        if (StringUtils.isNullOrEmpty(tag)) {
            throw new IllegalArgumentException("A tag must be specified.");
        }
        return this.elements.stream().filter(es -> es.getTag().equals(tag)).findFirst().orElse(null);
    }

    public ElementStyle findElementStyle(String tag) {
        if (tag == null) {
            return null;
        }
        boolean elementStyleExists = false;
        tag = tag.trim();
        ElementStyle style = new ElementStyle(tag);
        ArrayList<ElementStyle> elementStyles = new ArrayList<ElementStyle>();
        for (Theme theme : this.themes) {
            elementStyles.addAll(theme.getElements());
        }
        elementStyles.addAll(this.elements);
        for (ElementStyle elementStyle : elementStyles) {
            if (elementStyle == null || !elementStyle.getTag().equals(tag)) continue;
            elementStyleExists = true;
            style.copyFrom(elementStyle);
        }
        if (elementStyleExists) {
            return style;
        }
        return null;
    }

    public RelationshipStyle getRelationshipStyle(String tag) {
        if (StringUtils.isNullOrEmpty(tag)) {
            throw new IllegalArgumentException("A tag must be specified.");
        }
        return this.relationships.stream().filter(rs -> rs.getTag().equals(tag)).findFirst().orElse(null);
    }

    public RelationshipStyle findRelationshipStyle(String tag) {
        if (tag == null) {
            return null;
        }
        boolean relationshipStyleExists = false;
        tag = tag.trim();
        RelationshipStyle style = new RelationshipStyle(tag);
        ArrayList<RelationshipStyle> relationshipStyles = new ArrayList<RelationshipStyle>();
        for (Theme theme : this.themes) {
            relationshipStyles.addAll(theme.getRelationships());
        }
        relationshipStyles.addAll(this.relationships);
        for (RelationshipStyle relationshipStyle : relationshipStyles) {
            if (relationshipStyle == null || !relationshipStyle.getTag().equals(tag)) continue;
            style.copyFrom(relationshipStyle);
            relationshipStyleExists = true;
        }
        if (relationshipStyleExists) {
            return style;
        }
        return null;
    }

    public ElementStyle findElementStyle(Element element) {
        ElementStyle style = new ElementStyle("Element").background("#dddddd").color("#000000").shape(Shape.Box).fontSize(24).border(Border.Solid).opacity(100).metadata(true).description(true);
        if (element instanceof DeploymentNode) {
            style.setBackground("#ffffff");
            style.setColor("#000000");
            style.setStroke("#888888");
        }
        if (element != null) {
            LinkedHashSet<String> tagsUsedToComposeStyle = new LinkedHashSet<String>();
            tagsUsedToComposeStyle.add("Element");
            String tags = element.getTags();
            if (element instanceof SoftwareSystemInstance) {
                SoftwareSystem ss = ((SoftwareSystemInstance)element).getSoftwareSystem();
                tags = ss.getTags() + "," + tags;
            } else if (element instanceof ContainerInstance) {
                Container c = ((ContainerInstance)element).getContainer();
                tags = c.getTags() + "," + tags;
            }
            for (String tag : tags.split(",")) {
                ElementStyle elementStyle;
                if (StringUtils.isNullOrEmpty(tag) || (elementStyle = this.findElementStyle(tag)) == null) continue;
                style.copyFrom(elementStyle);
                tagsUsedToComposeStyle.add(elementStyle.getTag());
            }
            style.setTag(TagUtils.toString(tagsUsedToComposeStyle));
        }
        if (style.getWidth() == null) {
            if (style.getShape() == Shape.Person) {
                style.setWidth(DEFAULT_WIDTH_OF_PERSON);
            } else {
                style.setWidth(DEFAULT_WIDTH_OF_ELEMENT);
            }
        }
        if (style.getHeight() == null) {
            if (style.getShape() == Shape.Person || style.getShape() == Shape.Robot) {
                style.setHeight(DEFAULT_HEIGHT_OF_PERSON);
            } else {
                style.setHeight(DEFAULT_HEIGHT_OF_ELEMENT);
            }
        }
        if (style.getStroke() == null) {
            Color color = Color.decode(style.getBackground());
            style.setStroke(String.format("#%06X", 0xFFFFFF & color.darker().getRGB()));
        }
        return style;
    }

    public RelationshipStyle findRelationshipStyle(Relationship relationship) {
        RelationshipStyle style = new RelationshipStyle("Relationship").thickness(2).color("#707070").dashed(true).routing(Routing.Direct).fontSize(24).width(200).position(50).opacity(100);
        if (relationship != null) {
            LinkedHashSet<String> tagsUsedToComposeStyle = new LinkedHashSet<String>();
            tagsUsedToComposeStyle.add("Relationship");
            String tags = relationship.getTags();
            String linkedRelationshipId = relationship.getLinkedRelationshipId();
            while (!StringUtils.isNullOrEmpty(linkedRelationshipId)) {
                Relationship linkedRelationship = relationship.getModel().getRelationship(linkedRelationshipId);
                tags = linkedRelationship.getTags() + "," + tags;
                linkedRelationshipId = linkedRelationship.getLinkedRelationshipId();
            }
            for (String tag : tags.split(",")) {
                RelationshipStyle relationshipStyle;
                if (StringUtils.isNullOrEmpty(tag) || (relationshipStyle = this.findRelationshipStyle(tag)) == null) continue;
                style.copyFrom(relationshipStyle);
                tagsUsedToComposeStyle.add(relationshipStyle.getTag());
            }
            style.setTag(TagUtils.toString(tagsUsedToComposeStyle));
        }
        return style;
    }

    public void addStylesFromTheme(Theme theme) {
        if (theme != null) {
            this.themes.add(theme);
        }
    }
}

