/*
 * Decompiled with CFR 0.152.
 */
package com.structurizr.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.structurizr.model.CanonicalNameGenerator;
import com.structurizr.model.Element;
import com.structurizr.model.InteractionStyle;
import com.structurizr.model.Model;
import com.structurizr.model.ModelItem;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;

public final class Relationship
extends ModelItem {
    private Model model;
    private Element source;
    private String sourceId;
    private Element destination;
    private String destinationId;
    private String description;
    private String technology;
    private InteractionStyle interactionStyle;
    private String linkedRelationshipId;

    Relationship() {
    }

    Relationship(Element source, Element destination, String description, String technology, InteractionStyle interactionStyle, String[] tags) {
        this();
        this.setSource(source);
        this.setDestination(destination);
        this.setDescription(description);
        this.setTechnology(technology);
        this.setInteractionStyle(interactionStyle);
        this.addTags(tags);
    }

    @JsonIgnore
    public Model getModel() {
        return this.model;
    }

    protected void setModel(Model model) {
        this.model = model;
    }

    @Override
    public String getCanonicalName() {
        return new CanonicalNameGenerator().generate(this);
    }

    @JsonIgnore
    public Element getSource() {
        return this.source;
    }

    public String getSourceId() {
        if (this.source != null) {
            return this.source.getId();
        }
        return this.sourceId;
    }

    void setSourceId(String sourceId) {
        this.sourceId = sourceId;
    }

    void setSource(Element source) {
        this.source = source;
    }

    @JsonIgnore
    public Element getDestination() {
        return this.destination;
    }

    public String getDestinationId() {
        if (this.destination != null) {
            return this.destination.getId();
        }
        return this.destinationId;
    }

    void setDestinationId(String destinationId) {
        this.destinationId = destinationId;
    }

    void setDestination(Element destination) {
        this.destination = destination;
    }

    public String getDescription() {
        return this.description != null ? this.description : "";
    }

    void setDescription(String description) {
        this.description = description;
    }

    public String getTechnology() {
        return this.technology;
    }

    void setTechnology(String technology) {
        this.technology = technology;
    }

    public InteractionStyle getInteractionStyle() {
        return this.interactionStyle;
    }

    void setInteractionStyle(InteractionStyle interactionStyle) {
        this.interactionStyle = interactionStyle;
    }

    public String getLinkedRelationshipId() {
        return this.linkedRelationshipId;
    }

    void setLinkedRelationshipId(String baseRelationshipId) {
        this.linkedRelationshipId = baseRelationshipId;
    }

    @Override
    public Set<String> getDefaultTags() {
        if (this.linkedRelationshipId == null) {
            LinkedHashSet<String> tags = new LinkedHashSet<String>();
            tags.add("Relationship");
            if (this.interactionStyle == InteractionStyle.Synchronous) {
                tags.add("Synchronous");
            } else if (this.interactionStyle == InteractionStyle.Asynchronous) {
                tags.add("Asynchronous");
            }
            return tags;
        }
        return Collections.emptySet();
    }

    public String toString() {
        return this.source.toString() + " ---[" + this.description + "]---> " + this.destination.toString();
    }
}

