/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.net;

import com.stripe.exception.SignatureVerificationException;
import com.stripe.model.Event;
import com.stripe.model.StripeObject;
import java.io.UnsupportedEncodingException;
import java.security.InvalidKeyException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.List;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;

public final class Webhook {
    private static final long DEFAULT_TOLERANCE = 300L;

    public static Event constructEvent(String payload, String sigHeader, String secret) throws SignatureVerificationException {
        return Webhook.constructEvent(payload, sigHeader, secret, 300L);
    }

    public static Event constructEvent(String payload, String sigHeader, String secret, long tolerance) throws SignatureVerificationException {
        Event event = (Event)StripeObject.PRETTY_PRINT_GSON.fromJson(payload, Event.class);
        Signature.verifyHeader(payload, sigHeader, secret, tolerance);
        return event;
    }

    public static final class Util {
        public static String computeHmacSHA256(String key, String message) throws UnsupportedEncodingException, NoSuchAlgorithmException, InvalidKeyException {
            Mac hasher = Mac.getInstance("HmacSHA256");
            hasher.init(new SecretKeySpec(key.getBytes("UTF8"), "HmacSHA256"));
            byte[] hash = hasher.doFinal(message.getBytes("UTF8"));
            String result = "";
            for (byte b : hash) {
                result = result + Integer.toString((b & 0xFF) + 256, 16).substring(1);
            }
            return result;
        }

        public static boolean secureCompare(String a, String b) {
            byte[] digesta = a.getBytes();
            byte[] digestb = b.getBytes();
            return MessageDigest.isEqual(digesta, digestb);
        }

        public static long getTimeNow() {
            long time = System.currentTimeMillis() / 1000L;
            return time;
        }
    }

    public static final class Signature {
        public static final String EXPECTED_SCHEME = "v1";

        public static boolean verifyHeader(String payload, String sigHeader, String secret, long tolerance) throws SignatureVerificationException {
            String expectedSignature;
            long timestamp = Signature.getTimestamp(sigHeader);
            List<String> signatures = Signature.getSignatures(sigHeader, EXPECTED_SCHEME);
            if (timestamp <= 0L) {
                throw new SignatureVerificationException("Unable to extract timestamp and signatures from header", sigHeader);
            }
            if (signatures.size() == 0) {
                throw new SignatureVerificationException("No signatures found with expected scheme", sigHeader);
            }
            String signedPayload = String.format("%d.%s", timestamp, payload);
            try {
                expectedSignature = Signature.computeSignature(signedPayload, secret);
            }
            catch (Exception e) {
                throw new SignatureVerificationException("Unable to compute signature for payload", sigHeader);
            }
            Boolean signatureFound = false;
            for (String signature : signatures) {
                if (!Util.secureCompare(expectedSignature, signature)) continue;
                signatureFound = true;
                break;
            }
            if (!signatureFound.booleanValue()) {
                throw new SignatureVerificationException("No signatures found matching the expected signature for payload", sigHeader);
            }
            if (tolerance > 0L && timestamp < Util.getTimeNow() - tolerance) {
                throw new SignatureVerificationException("Timestamp outside the tolerance zone", sigHeader);
            }
            return true;
        }

        private static long getTimestamp(String sigHeader) {
            String[] items;
            for (String item : items = sigHeader.split(",")) {
                String[] itemParts = item.split("=", 2);
                if (!itemParts[0].equals("t")) continue;
                return Long.parseLong(itemParts[1]);
            }
            return -1L;
        }

        private static List<String> getSignatures(String sigHeader, String scheme) {
            String[] items;
            ArrayList<String> signatures = new ArrayList<String>();
            for (String item : items = sigHeader.split(",")) {
                String[] itemParts = item.split("=", 2);
                if (!itemParts[0].equals(scheme)) continue;
                signatures.add(itemParts[1]);
            }
            return signatures;
        }

        private static String computeSignature(String payload, String secret) throws UnsupportedEncodingException, NoSuchAlgorithmException, InvalidKeyException {
            return Util.computeHmacSHA256(secret, payload);
        }
    }
}

