/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.model;

import com.stripe.exception.APIConnectionException;
import com.stripe.exception.APIException;
import com.stripe.exception.AuthenticationException;
import com.stripe.exception.CardException;
import com.stripe.exception.InvalidRequestException;
import com.stripe.model.ExpandableField;
import com.stripe.model.HasId;
import com.stripe.model.Order;
import com.stripe.model.OrderItem;
import com.stripe.model.OrderReturnCollection;
import com.stripe.model.Refund;
import com.stripe.net.APIResource;
import com.stripe.net.RequestOptions;
import java.util.List;
import java.util.Map;

public class OrderReturn
extends APIResource
implements HasId {
    String id;
    String object;
    Long amount;
    Long created;
    String currency;
    List<OrderItem> items;
    Boolean livemode;
    ExpandableField<Order> order;
    ExpandableField<Refund> refund;

    @Override
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getObject() {
        return this.object;
    }

    public void setObject(String object) {
        this.object = object;
    }

    public Long getAmount() {
        return this.amount;
    }

    public void setAmount(Long amount) {
        this.amount = amount;
    }

    public Long getCreated() {
        return this.created;
    }

    public void setCreated(Long created) {
        this.created = created;
    }

    public String getCurrency() {
        return this.currency;
    }

    public void setCurrency(String currency) {
        this.currency = currency;
    }

    public List<OrderItem> getItems() {
        return this.items;
    }

    public void setItems(List<OrderItem> items) {
        this.items = items;
    }

    public Boolean getLivemode() {
        return this.livemode;
    }

    public void setLivemode(Boolean livemode) {
        this.livemode = livemode;
    }

    public String getOrder() {
        if (this.order == null) {
            return null;
        }
        return this.order.getId();
    }

    public void setOrder(String orderID) {
        this.order = OrderReturn.setExpandableFieldID(orderID, this.order);
    }

    public Order getOrderObject() {
        if (this.order == null) {
            return null;
        }
        return this.order.getExpanded();
    }

    public void setOrderObject(Order order) {
        this.order = new ExpandableField<Order>(order.getId(), order);
    }

    public String getRefund() {
        if (this.refund == null) {
            return null;
        }
        return this.refund.getId();
    }

    public void setRefund(String refundID) {
        this.refund = OrderReturn.setExpandableFieldID(refundID, this.refund);
    }

    public Refund getRefundObject() {
        if (this.refund == null) {
            return null;
        }
        return this.refund.getExpanded();
    }

    public void setRefundObject(Refund refund) {
        this.refund = new ExpandableField<Refund>(refund.getId(), refund);
    }

    public static OrderReturn retrieve(String id) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        return OrderReturn.retrieve(id, null);
    }

    public static OrderReturn retrieve(String id, RequestOptions options) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        return OrderReturn.request(APIResource.RequestMethod.GET, OrderReturn.instanceURL(OrderReturn.class, id), null, OrderReturn.class, options);
    }

    public static OrderReturnCollection list(Map<String, Object> params) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        return OrderReturn.list(params, null);
    }

    public static OrderReturnCollection list(Map<String, Object> params, RequestOptions options) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        return OrderReturn.requestCollection(OrderReturn.classURL(OrderReturn.class), params, OrderReturnCollection.class, options);
    }
}

