/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.model;

import com.google.gson.annotations.SerializedName;
import com.stripe.Stripe;
import com.stripe.exception.StripeException;
import com.stripe.model.Address;
import com.stripe.model.ExpandableField;
import com.stripe.model.File;
import com.stripe.model.HasId;
import com.stripe.model.MetadataStore;
import com.stripe.model.StripeObject;
import com.stripe.net.ApiResource;
import com.stripe.net.RequestOptions;
import com.stripe.param.PersonUpdateParams;
import java.math.BigDecimal;
import java.util.List;
import java.util.Map;
import lombok.Generated;

public class Person
extends ApiResource
implements HasId,
MetadataStore<Person> {
    @SerializedName(value="account")
    String account;
    @SerializedName(value="address")
    Address address;
    @SerializedName(value="address_kana")
    AddressKana addressKana;
    @SerializedName(value="address_kanji")
    AddressKanji addressKanji;
    @SerializedName(value="created")
    Long created;
    @SerializedName(value="deleted")
    Boolean deleted;
    @SerializedName(value="dob")
    Dob dob;
    @SerializedName(value="email")
    String email;
    @SerializedName(value="first_name")
    String firstName;
    @SerializedName(value="first_name_kana")
    String firstNameKana;
    @SerializedName(value="first_name_kanji")
    String firstNameKanji;
    @SerializedName(value="full_name_aliases")
    List<String> fullNameAliases;
    @SerializedName(value="future_requirements")
    FutureRequirements futureRequirements;
    @SerializedName(value="gender")
    String gender;
    @SerializedName(value="id")
    String id;
    @SerializedName(value="id_number_provided")
    Boolean idNumberProvided;
    @SerializedName(value="id_number_secondary_provided")
    Boolean idNumberSecondaryProvided;
    @SerializedName(value="last_name")
    String lastName;
    @SerializedName(value="last_name_kana")
    String lastNameKana;
    @SerializedName(value="last_name_kanji")
    String lastNameKanji;
    @SerializedName(value="maiden_name")
    String maidenName;
    @SerializedName(value="metadata")
    Map<String, String> metadata;
    @SerializedName(value="nationality")
    String nationality;
    @SerializedName(value="object")
    String object;
    @SerializedName(value="phone")
    String phone;
    @SerializedName(value="political_exposure")
    String politicalExposure;
    @SerializedName(value="registered_address")
    Address registeredAddress;
    @SerializedName(value="relationship")
    Relationship relationship;
    @SerializedName(value="requirements")
    Requirements requirements;
    @SerializedName(value="ssn_last_4_provided")
    Boolean ssnLast4Provided;
    @SerializedName(value="verification")
    Verification verification;

    public Person delete() throws StripeException {
        return this.delete(null, null);
    }

    public Person delete(RequestOptions options) throws StripeException {
        return this.delete(null, options);
    }

    public Person delete(Map<String, Object> params) throws StripeException {
        return this.delete(params, null);
    }

    public Person delete(Map<String, Object> params, RequestOptions options) throws StripeException {
        String url = ApiResource.fullUrl(Stripe.getApiBase(), options, String.format("/v1/accounts/%s/persons/%s", ApiResource.urlEncodeId(this.getAccount()), ApiResource.urlEncodeId(this.getId())));
        return ApiResource.request(ApiResource.RequestMethod.DELETE, url, params, Person.class, options);
    }

    public Person update(Map<String, Object> params) throws StripeException {
        return this.update((Map)params, (RequestOptions)null);
    }

    public Person update(Map<String, Object> params, RequestOptions options) throws StripeException {
        String url = ApiResource.fullUrl(Stripe.getApiBase(), options, String.format("/v1/accounts/%s/persons/%s", ApiResource.urlEncodeId(this.getAccount()), ApiResource.urlEncodeId(this.getId())));
        return ApiResource.request(ApiResource.RequestMethod.POST, url, params, Person.class, options);
    }

    public Person update(PersonUpdateParams params) throws StripeException {
        return this.update(params, (RequestOptions)null);
    }

    public Person update(PersonUpdateParams params, RequestOptions options) throws StripeException {
        String url = ApiResource.fullUrl(Stripe.getApiBase(), options, String.format("/v1/accounts/%s/persons/%s", ApiResource.urlEncodeId(this.getAccount()), ApiResource.urlEncodeId(this.getId())));
        return ApiResource.request(ApiResource.RequestMethod.POST, url, params, Person.class, options);
    }

    @Generated
    public String getAccount() {
        return this.account;
    }

    @Generated
    public Address getAddress() {
        return this.address;
    }

    @Generated
    public AddressKana getAddressKana() {
        return this.addressKana;
    }

    @Generated
    public AddressKanji getAddressKanji() {
        return this.addressKanji;
    }

    @Generated
    public Long getCreated() {
        return this.created;
    }

    @Generated
    public Boolean getDeleted() {
        return this.deleted;
    }

    @Generated
    public Dob getDob() {
        return this.dob;
    }

    @Generated
    public String getEmail() {
        return this.email;
    }

    @Generated
    public String getFirstName() {
        return this.firstName;
    }

    @Generated
    public String getFirstNameKana() {
        return this.firstNameKana;
    }

    @Generated
    public String getFirstNameKanji() {
        return this.firstNameKanji;
    }

    @Generated
    public List<String> getFullNameAliases() {
        return this.fullNameAliases;
    }

    @Generated
    public FutureRequirements getFutureRequirements() {
        return this.futureRequirements;
    }

    @Generated
    public String getGender() {
        return this.gender;
    }

    @Generated
    public Boolean getIdNumberProvided() {
        return this.idNumberProvided;
    }

    @Generated
    public Boolean getIdNumberSecondaryProvided() {
        return this.idNumberSecondaryProvided;
    }

    @Generated
    public String getLastName() {
        return this.lastName;
    }

    @Generated
    public String getLastNameKana() {
        return this.lastNameKana;
    }

    @Generated
    public String getLastNameKanji() {
        return this.lastNameKanji;
    }

    @Generated
    public String getMaidenName() {
        return this.maidenName;
    }

    @Generated
    public String getNationality() {
        return this.nationality;
    }

    @Generated
    public String getObject() {
        return this.object;
    }

    @Generated
    public String getPhone() {
        return this.phone;
    }

    @Generated
    public String getPoliticalExposure() {
        return this.politicalExposure;
    }

    @Generated
    public Address getRegisteredAddress() {
        return this.registeredAddress;
    }

    @Generated
    public Relationship getRelationship() {
        return this.relationship;
    }

    @Generated
    public Requirements getRequirements() {
        return this.requirements;
    }

    @Generated
    public Boolean getSsnLast4Provided() {
        return this.ssnLast4Provided;
    }

    @Generated
    public Verification getVerification() {
        return this.verification;
    }

    @Generated
    public void setAccount(String account) {
        this.account = account;
    }

    @Generated
    public void setAddress(Address address) {
        this.address = address;
    }

    @Generated
    public void setAddressKana(AddressKana addressKana) {
        this.addressKana = addressKana;
    }

    @Generated
    public void setAddressKanji(AddressKanji addressKanji) {
        this.addressKanji = addressKanji;
    }

    @Generated
    public void setCreated(Long created) {
        this.created = created;
    }

    @Generated
    public void setDeleted(Boolean deleted) {
        this.deleted = deleted;
    }

    @Generated
    public void setDob(Dob dob) {
        this.dob = dob;
    }

    @Generated
    public void setEmail(String email) {
        this.email = email;
    }

    @Generated
    public void setFirstName(String firstName) {
        this.firstName = firstName;
    }

    @Generated
    public void setFirstNameKana(String firstNameKana) {
        this.firstNameKana = firstNameKana;
    }

    @Generated
    public void setFirstNameKanji(String firstNameKanji) {
        this.firstNameKanji = firstNameKanji;
    }

    @Generated
    public void setFullNameAliases(List<String> fullNameAliases) {
        this.fullNameAliases = fullNameAliases;
    }

    @Generated
    public void setFutureRequirements(FutureRequirements futureRequirements) {
        this.futureRequirements = futureRequirements;
    }

    @Generated
    public void setGender(String gender) {
        this.gender = gender;
    }

    @Generated
    public void setId(String id) {
        this.id = id;
    }

    @Generated
    public void setIdNumberProvided(Boolean idNumberProvided) {
        this.idNumberProvided = idNumberProvided;
    }

    @Generated
    public void setIdNumberSecondaryProvided(Boolean idNumberSecondaryProvided) {
        this.idNumberSecondaryProvided = idNumberSecondaryProvided;
    }

    @Generated
    public void setLastName(String lastName) {
        this.lastName = lastName;
    }

    @Generated
    public void setLastNameKana(String lastNameKana) {
        this.lastNameKana = lastNameKana;
    }

    @Generated
    public void setLastNameKanji(String lastNameKanji) {
        this.lastNameKanji = lastNameKanji;
    }

    @Generated
    public void setMaidenName(String maidenName) {
        this.maidenName = maidenName;
    }

    @Generated
    public void setMetadata(Map<String, String> metadata) {
        this.metadata = metadata;
    }

    @Generated
    public void setNationality(String nationality) {
        this.nationality = nationality;
    }

    @Generated
    public void setObject(String object) {
        this.object = object;
    }

    @Generated
    public void setPhone(String phone) {
        this.phone = phone;
    }

    @Generated
    public void setPoliticalExposure(String politicalExposure) {
        this.politicalExposure = politicalExposure;
    }

    @Generated
    public void setRegisteredAddress(Address registeredAddress) {
        this.registeredAddress = registeredAddress;
    }

    @Generated
    public void setRelationship(Relationship relationship) {
        this.relationship = relationship;
    }

    @Generated
    public void setRequirements(Requirements requirements) {
        this.requirements = requirements;
    }

    @Generated
    public void setSsnLast4Provided(Boolean ssnLast4Provided) {
        this.ssnLast4Provided = ssnLast4Provided;
    }

    @Generated
    public void setVerification(Verification verification) {
        this.verification = verification;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Person)) {
            return false;
        }
        Person other = (Person)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Long this$created = this.getCreated();
        Long other$created = other.getCreated();
        if (this$created == null ? other$created != null : !((Object)this$created).equals(other$created)) {
            return false;
        }
        Boolean this$deleted = this.getDeleted();
        Boolean other$deleted = other.getDeleted();
        if (this$deleted == null ? other$deleted != null : !((Object)this$deleted).equals(other$deleted)) {
            return false;
        }
        Boolean this$idNumberProvided = this.getIdNumberProvided();
        Boolean other$idNumberProvided = other.getIdNumberProvided();
        if (this$idNumberProvided == null ? other$idNumberProvided != null : !((Object)this$idNumberProvided).equals(other$idNumberProvided)) {
            return false;
        }
        Boolean this$idNumberSecondaryProvided = this.getIdNumberSecondaryProvided();
        Boolean other$idNumberSecondaryProvided = other.getIdNumberSecondaryProvided();
        if (this$idNumberSecondaryProvided == null ? other$idNumberSecondaryProvided != null : !((Object)this$idNumberSecondaryProvided).equals(other$idNumberSecondaryProvided)) {
            return false;
        }
        Boolean this$ssnLast4Provided = this.getSsnLast4Provided();
        Boolean other$ssnLast4Provided = other.getSsnLast4Provided();
        if (this$ssnLast4Provided == null ? other$ssnLast4Provided != null : !((Object)this$ssnLast4Provided).equals(other$ssnLast4Provided)) {
            return false;
        }
        String this$account = this.getAccount();
        String other$account = other.getAccount();
        if (this$account == null ? other$account != null : !this$account.equals(other$account)) {
            return false;
        }
        Address this$address = this.getAddress();
        Address other$address = other.getAddress();
        if (this$address == null ? other$address != null : !((Object)this$address).equals(other$address)) {
            return false;
        }
        AddressKana this$addressKana = this.getAddressKana();
        AddressKana other$addressKana = other.getAddressKana();
        if (this$addressKana == null ? other$addressKana != null : !((Object)this$addressKana).equals(other$addressKana)) {
            return false;
        }
        AddressKanji this$addressKanji = this.getAddressKanji();
        AddressKanji other$addressKanji = other.getAddressKanji();
        if (this$addressKanji == null ? other$addressKanji != null : !((Object)this$addressKanji).equals(other$addressKanji)) {
            return false;
        }
        Dob this$dob = this.getDob();
        Dob other$dob = other.getDob();
        if (this$dob == null ? other$dob != null : !((Object)this$dob).equals(other$dob)) {
            return false;
        }
        String this$email = this.getEmail();
        String other$email = other.getEmail();
        if (this$email == null ? other$email != null : !this$email.equals(other$email)) {
            return false;
        }
        String this$firstName = this.getFirstName();
        String other$firstName = other.getFirstName();
        if (this$firstName == null ? other$firstName != null : !this$firstName.equals(other$firstName)) {
            return false;
        }
        String this$firstNameKana = this.getFirstNameKana();
        String other$firstNameKana = other.getFirstNameKana();
        if (this$firstNameKana == null ? other$firstNameKana != null : !this$firstNameKana.equals(other$firstNameKana)) {
            return false;
        }
        String this$firstNameKanji = this.getFirstNameKanji();
        String other$firstNameKanji = other.getFirstNameKanji();
        if (this$firstNameKanji == null ? other$firstNameKanji != null : !this$firstNameKanji.equals(other$firstNameKanji)) {
            return false;
        }
        List<String> this$fullNameAliases = this.getFullNameAliases();
        List<String> other$fullNameAliases = other.getFullNameAliases();
        if (this$fullNameAliases == null ? other$fullNameAliases != null : !((Object)this$fullNameAliases).equals(other$fullNameAliases)) {
            return false;
        }
        FutureRequirements this$futureRequirements = this.getFutureRequirements();
        FutureRequirements other$futureRequirements = other.getFutureRequirements();
        if (this$futureRequirements == null ? other$futureRequirements != null : !((Object)this$futureRequirements).equals(other$futureRequirements)) {
            return false;
        }
        String this$gender = this.getGender();
        String other$gender = other.getGender();
        if (this$gender == null ? other$gender != null : !this$gender.equals(other$gender)) {
            return false;
        }
        String this$id = this.getId();
        String other$id = other.getId();
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
            return false;
        }
        String this$lastName = this.getLastName();
        String other$lastName = other.getLastName();
        if (this$lastName == null ? other$lastName != null : !this$lastName.equals(other$lastName)) {
            return false;
        }
        String this$lastNameKana = this.getLastNameKana();
        String other$lastNameKana = other.getLastNameKana();
        if (this$lastNameKana == null ? other$lastNameKana != null : !this$lastNameKana.equals(other$lastNameKana)) {
            return false;
        }
        String this$lastNameKanji = this.getLastNameKanji();
        String other$lastNameKanji = other.getLastNameKanji();
        if (this$lastNameKanji == null ? other$lastNameKanji != null : !this$lastNameKanji.equals(other$lastNameKanji)) {
            return false;
        }
        String this$maidenName = this.getMaidenName();
        String other$maidenName = other.getMaidenName();
        if (this$maidenName == null ? other$maidenName != null : !this$maidenName.equals(other$maidenName)) {
            return false;
        }
        Map<String, String> this$metadata = this.getMetadata();
        Map<String, String> other$metadata = other.getMetadata();
        if (this$metadata == null ? other$metadata != null : !((Object)this$metadata).equals(other$metadata)) {
            return false;
        }
        String this$nationality = this.getNationality();
        String other$nationality = other.getNationality();
        if (this$nationality == null ? other$nationality != null : !this$nationality.equals(other$nationality)) {
            return false;
        }
        String this$object = this.getObject();
        String other$object = other.getObject();
        if (this$object == null ? other$object != null : !this$object.equals(other$object)) {
            return false;
        }
        String this$phone = this.getPhone();
        String other$phone = other.getPhone();
        if (this$phone == null ? other$phone != null : !this$phone.equals(other$phone)) {
            return false;
        }
        String this$politicalExposure = this.getPoliticalExposure();
        String other$politicalExposure = other.getPoliticalExposure();
        if (this$politicalExposure == null ? other$politicalExposure != null : !this$politicalExposure.equals(other$politicalExposure)) {
            return false;
        }
        Address this$registeredAddress = this.getRegisteredAddress();
        Address other$registeredAddress = other.getRegisteredAddress();
        if (this$registeredAddress == null ? other$registeredAddress != null : !((Object)this$registeredAddress).equals(other$registeredAddress)) {
            return false;
        }
        Relationship this$relationship = this.getRelationship();
        Relationship other$relationship = other.getRelationship();
        if (this$relationship == null ? other$relationship != null : !((Object)this$relationship).equals(other$relationship)) {
            return false;
        }
        Requirements this$requirements = this.getRequirements();
        Requirements other$requirements = other.getRequirements();
        if (this$requirements == null ? other$requirements != null : !((Object)this$requirements).equals(other$requirements)) {
            return false;
        }
        Verification this$verification = this.getVerification();
        Verification other$verification = other.getVerification();
        return !(this$verification == null ? other$verification != null : !((Object)this$verification).equals(other$verification));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof Person;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $created = this.getCreated();
        result = result * 59 + ($created == null ? 43 : ((Object)$created).hashCode());
        Boolean $deleted = this.getDeleted();
        result = result * 59 + ($deleted == null ? 43 : ((Object)$deleted).hashCode());
        Boolean $idNumberProvided = this.getIdNumberProvided();
        result = result * 59 + ($idNumberProvided == null ? 43 : ((Object)$idNumberProvided).hashCode());
        Boolean $idNumberSecondaryProvided = this.getIdNumberSecondaryProvided();
        result = result * 59 + ($idNumberSecondaryProvided == null ? 43 : ((Object)$idNumberSecondaryProvided).hashCode());
        Boolean $ssnLast4Provided = this.getSsnLast4Provided();
        result = result * 59 + ($ssnLast4Provided == null ? 43 : ((Object)$ssnLast4Provided).hashCode());
        String $account = this.getAccount();
        result = result * 59 + ($account == null ? 43 : $account.hashCode());
        Address $address = this.getAddress();
        result = result * 59 + ($address == null ? 43 : ((Object)$address).hashCode());
        AddressKana $addressKana = this.getAddressKana();
        result = result * 59 + ($addressKana == null ? 43 : ((Object)$addressKana).hashCode());
        AddressKanji $addressKanji = this.getAddressKanji();
        result = result * 59 + ($addressKanji == null ? 43 : ((Object)$addressKanji).hashCode());
        Dob $dob = this.getDob();
        result = result * 59 + ($dob == null ? 43 : ((Object)$dob).hashCode());
        String $email = this.getEmail();
        result = result * 59 + ($email == null ? 43 : $email.hashCode());
        String $firstName = this.getFirstName();
        result = result * 59 + ($firstName == null ? 43 : $firstName.hashCode());
        String $firstNameKana = this.getFirstNameKana();
        result = result * 59 + ($firstNameKana == null ? 43 : $firstNameKana.hashCode());
        String $firstNameKanji = this.getFirstNameKanji();
        result = result * 59 + ($firstNameKanji == null ? 43 : $firstNameKanji.hashCode());
        List<String> $fullNameAliases = this.getFullNameAliases();
        result = result * 59 + ($fullNameAliases == null ? 43 : ((Object)$fullNameAliases).hashCode());
        FutureRequirements $futureRequirements = this.getFutureRequirements();
        result = result * 59 + ($futureRequirements == null ? 43 : ((Object)$futureRequirements).hashCode());
        String $gender = this.getGender();
        result = result * 59 + ($gender == null ? 43 : $gender.hashCode());
        String $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        String $lastName = this.getLastName();
        result = result * 59 + ($lastName == null ? 43 : $lastName.hashCode());
        String $lastNameKana = this.getLastNameKana();
        result = result * 59 + ($lastNameKana == null ? 43 : $lastNameKana.hashCode());
        String $lastNameKanji = this.getLastNameKanji();
        result = result * 59 + ($lastNameKanji == null ? 43 : $lastNameKanji.hashCode());
        String $maidenName = this.getMaidenName();
        result = result * 59 + ($maidenName == null ? 43 : $maidenName.hashCode());
        Map<String, String> $metadata = this.getMetadata();
        result = result * 59 + ($metadata == null ? 43 : ((Object)$metadata).hashCode());
        String $nationality = this.getNationality();
        result = result * 59 + ($nationality == null ? 43 : $nationality.hashCode());
        String $object = this.getObject();
        result = result * 59 + ($object == null ? 43 : $object.hashCode());
        String $phone = this.getPhone();
        result = result * 59 + ($phone == null ? 43 : $phone.hashCode());
        String $politicalExposure = this.getPoliticalExposure();
        result = result * 59 + ($politicalExposure == null ? 43 : $politicalExposure.hashCode());
        Address $registeredAddress = this.getRegisteredAddress();
        result = result * 59 + ($registeredAddress == null ? 43 : ((Object)$registeredAddress).hashCode());
        Relationship $relationship = this.getRelationship();
        result = result * 59 + ($relationship == null ? 43 : ((Object)$relationship).hashCode());
        Requirements $requirements = this.getRequirements();
        result = result * 59 + ($requirements == null ? 43 : ((Object)$requirements).hashCode());
        Verification $verification = this.getVerification();
        result = result * 59 + ($verification == null ? 43 : ((Object)$verification).hashCode());
        return result;
    }

    @Override
    @Generated
    public String getId() {
        return this.id;
    }

    @Override
    @Generated
    public Map<String, String> getMetadata() {
        return this.metadata;
    }

    public static class AddressKana
    extends StripeObject {
        @SerializedName(value="city")
        String city;
        @SerializedName(value="country")
        String country;
        @SerializedName(value="line1")
        String line1;
        @SerializedName(value="line2")
        String line2;
        @SerializedName(value="postal_code")
        String postalCode;
        @SerializedName(value="state")
        String state;
        @SerializedName(value="town")
        String town;

        @Generated
        public String getCity() {
            return this.city;
        }

        @Generated
        public String getCountry() {
            return this.country;
        }

        @Generated
        public String getLine1() {
            return this.line1;
        }

        @Generated
        public String getLine2() {
            return this.line2;
        }

        @Generated
        public String getPostalCode() {
            return this.postalCode;
        }

        @Generated
        public String getState() {
            return this.state;
        }

        @Generated
        public String getTown() {
            return this.town;
        }

        @Generated
        public void setCity(String city) {
            this.city = city;
        }

        @Generated
        public void setCountry(String country) {
            this.country = country;
        }

        @Generated
        public void setLine1(String line1) {
            this.line1 = line1;
        }

        @Generated
        public void setLine2(String line2) {
            this.line2 = line2;
        }

        @Generated
        public void setPostalCode(String postalCode) {
            this.postalCode = postalCode;
        }

        @Generated
        public void setState(String state) {
            this.state = state;
        }

        @Generated
        public void setTown(String town) {
            this.town = town;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof AddressKana)) {
                return false;
            }
            AddressKana other = (AddressKana)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$city = this.getCity();
            String other$city = other.getCity();
            if (this$city == null ? other$city != null : !this$city.equals(other$city)) {
                return false;
            }
            String this$country = this.getCountry();
            String other$country = other.getCountry();
            if (this$country == null ? other$country != null : !this$country.equals(other$country)) {
                return false;
            }
            String this$line1 = this.getLine1();
            String other$line1 = other.getLine1();
            if (this$line1 == null ? other$line1 != null : !this$line1.equals(other$line1)) {
                return false;
            }
            String this$line2 = this.getLine2();
            String other$line2 = other.getLine2();
            if (this$line2 == null ? other$line2 != null : !this$line2.equals(other$line2)) {
                return false;
            }
            String this$postalCode = this.getPostalCode();
            String other$postalCode = other.getPostalCode();
            if (this$postalCode == null ? other$postalCode != null : !this$postalCode.equals(other$postalCode)) {
                return false;
            }
            String this$state = this.getState();
            String other$state = other.getState();
            if (this$state == null ? other$state != null : !this$state.equals(other$state)) {
                return false;
            }
            String this$town = this.getTown();
            String other$town = other.getTown();
            return !(this$town == null ? other$town != null : !this$town.equals(other$town));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof AddressKana;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $city = this.getCity();
            result = result * 59 + ($city == null ? 43 : $city.hashCode());
            String $country = this.getCountry();
            result = result * 59 + ($country == null ? 43 : $country.hashCode());
            String $line1 = this.getLine1();
            result = result * 59 + ($line1 == null ? 43 : $line1.hashCode());
            String $line2 = this.getLine2();
            result = result * 59 + ($line2 == null ? 43 : $line2.hashCode());
            String $postalCode = this.getPostalCode();
            result = result * 59 + ($postalCode == null ? 43 : $postalCode.hashCode());
            String $state = this.getState();
            result = result * 59 + ($state == null ? 43 : $state.hashCode());
            String $town = this.getTown();
            result = result * 59 + ($town == null ? 43 : $town.hashCode());
            return result;
        }
    }

    public static class AddressKanji
    extends StripeObject {
        @SerializedName(value="city")
        String city;
        @SerializedName(value="country")
        String country;
        @SerializedName(value="line1")
        String line1;
        @SerializedName(value="line2")
        String line2;
        @SerializedName(value="postal_code")
        String postalCode;
        @SerializedName(value="state")
        String state;
        @SerializedName(value="town")
        String town;

        @Generated
        public String getCity() {
            return this.city;
        }

        @Generated
        public String getCountry() {
            return this.country;
        }

        @Generated
        public String getLine1() {
            return this.line1;
        }

        @Generated
        public String getLine2() {
            return this.line2;
        }

        @Generated
        public String getPostalCode() {
            return this.postalCode;
        }

        @Generated
        public String getState() {
            return this.state;
        }

        @Generated
        public String getTown() {
            return this.town;
        }

        @Generated
        public void setCity(String city) {
            this.city = city;
        }

        @Generated
        public void setCountry(String country) {
            this.country = country;
        }

        @Generated
        public void setLine1(String line1) {
            this.line1 = line1;
        }

        @Generated
        public void setLine2(String line2) {
            this.line2 = line2;
        }

        @Generated
        public void setPostalCode(String postalCode) {
            this.postalCode = postalCode;
        }

        @Generated
        public void setState(String state) {
            this.state = state;
        }

        @Generated
        public void setTown(String town) {
            this.town = town;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof AddressKanji)) {
                return false;
            }
            AddressKanji other = (AddressKanji)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$city = this.getCity();
            String other$city = other.getCity();
            if (this$city == null ? other$city != null : !this$city.equals(other$city)) {
                return false;
            }
            String this$country = this.getCountry();
            String other$country = other.getCountry();
            if (this$country == null ? other$country != null : !this$country.equals(other$country)) {
                return false;
            }
            String this$line1 = this.getLine1();
            String other$line1 = other.getLine1();
            if (this$line1 == null ? other$line1 != null : !this$line1.equals(other$line1)) {
                return false;
            }
            String this$line2 = this.getLine2();
            String other$line2 = other.getLine2();
            if (this$line2 == null ? other$line2 != null : !this$line2.equals(other$line2)) {
                return false;
            }
            String this$postalCode = this.getPostalCode();
            String other$postalCode = other.getPostalCode();
            if (this$postalCode == null ? other$postalCode != null : !this$postalCode.equals(other$postalCode)) {
                return false;
            }
            String this$state = this.getState();
            String other$state = other.getState();
            if (this$state == null ? other$state != null : !this$state.equals(other$state)) {
                return false;
            }
            String this$town = this.getTown();
            String other$town = other.getTown();
            return !(this$town == null ? other$town != null : !this$town.equals(other$town));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof AddressKanji;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $city = this.getCity();
            result = result * 59 + ($city == null ? 43 : $city.hashCode());
            String $country = this.getCountry();
            result = result * 59 + ($country == null ? 43 : $country.hashCode());
            String $line1 = this.getLine1();
            result = result * 59 + ($line1 == null ? 43 : $line1.hashCode());
            String $line2 = this.getLine2();
            result = result * 59 + ($line2 == null ? 43 : $line2.hashCode());
            String $postalCode = this.getPostalCode();
            result = result * 59 + ($postalCode == null ? 43 : $postalCode.hashCode());
            String $state = this.getState();
            result = result * 59 + ($state == null ? 43 : $state.hashCode());
            String $town = this.getTown();
            result = result * 59 + ($town == null ? 43 : $town.hashCode());
            return result;
        }
    }

    public static class Dob
    extends StripeObject {
        @SerializedName(value="day")
        Long day;
        @SerializedName(value="month")
        Long month;
        @SerializedName(value="year")
        Long year;

        @Generated
        public Long getDay() {
            return this.day;
        }

        @Generated
        public Long getMonth() {
            return this.month;
        }

        @Generated
        public Long getYear() {
            return this.year;
        }

        @Generated
        public void setDay(Long day) {
            this.day = day;
        }

        @Generated
        public void setMonth(Long month) {
            this.month = month;
        }

        @Generated
        public void setYear(Long year) {
            this.year = year;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Dob)) {
                return false;
            }
            Dob other = (Dob)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Long this$day = this.getDay();
            Long other$day = other.getDay();
            if (this$day == null ? other$day != null : !((Object)this$day).equals(other$day)) {
                return false;
            }
            Long this$month = this.getMonth();
            Long other$month = other.getMonth();
            if (this$month == null ? other$month != null : !((Object)this$month).equals(other$month)) {
                return false;
            }
            Long this$year = this.getYear();
            Long other$year = other.getYear();
            return !(this$year == null ? other$year != null : !((Object)this$year).equals(other$year));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof Dob;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Long $day = this.getDay();
            result = result * 59 + ($day == null ? 43 : ((Object)$day).hashCode());
            Long $month = this.getMonth();
            result = result * 59 + ($month == null ? 43 : ((Object)$month).hashCode());
            Long $year = this.getYear();
            result = result * 59 + ($year == null ? 43 : ((Object)$year).hashCode());
            return result;
        }
    }

    public static class FutureRequirements
    extends StripeObject {
        @SerializedName(value="alternatives")
        List<Alternative> alternatives;
        @SerializedName(value="currently_due")
        List<String> currentlyDue;
        @SerializedName(value="errors")
        List<Errors> errors;
        @SerializedName(value="eventually_due")
        List<String> eventuallyDue;
        @SerializedName(value="past_due")
        List<String> pastDue;
        @SerializedName(value="pending_verification")
        List<String> pendingVerification;

        @Generated
        public List<Alternative> getAlternatives() {
            return this.alternatives;
        }

        @Generated
        public List<String> getCurrentlyDue() {
            return this.currentlyDue;
        }

        @Generated
        public List<Errors> getErrors() {
            return this.errors;
        }

        @Generated
        public List<String> getEventuallyDue() {
            return this.eventuallyDue;
        }

        @Generated
        public List<String> getPastDue() {
            return this.pastDue;
        }

        @Generated
        public List<String> getPendingVerification() {
            return this.pendingVerification;
        }

        @Generated
        public void setAlternatives(List<Alternative> alternatives) {
            this.alternatives = alternatives;
        }

        @Generated
        public void setCurrentlyDue(List<String> currentlyDue) {
            this.currentlyDue = currentlyDue;
        }

        @Generated
        public void setErrors(List<Errors> errors) {
            this.errors = errors;
        }

        @Generated
        public void setEventuallyDue(List<String> eventuallyDue) {
            this.eventuallyDue = eventuallyDue;
        }

        @Generated
        public void setPastDue(List<String> pastDue) {
            this.pastDue = pastDue;
        }

        @Generated
        public void setPendingVerification(List<String> pendingVerification) {
            this.pendingVerification = pendingVerification;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof FutureRequirements)) {
                return false;
            }
            FutureRequirements other = (FutureRequirements)o;
            if (!other.canEqual(this)) {
                return false;
            }
            List<Alternative> this$alternatives = this.getAlternatives();
            List<Alternative> other$alternatives = other.getAlternatives();
            if (this$alternatives == null ? other$alternatives != null : !((Object)this$alternatives).equals(other$alternatives)) {
                return false;
            }
            List<String> this$currentlyDue = this.getCurrentlyDue();
            List<String> other$currentlyDue = other.getCurrentlyDue();
            if (this$currentlyDue == null ? other$currentlyDue != null : !((Object)this$currentlyDue).equals(other$currentlyDue)) {
                return false;
            }
            List<Errors> this$errors = this.getErrors();
            List<Errors> other$errors = other.getErrors();
            if (this$errors == null ? other$errors != null : !((Object)this$errors).equals(other$errors)) {
                return false;
            }
            List<String> this$eventuallyDue = this.getEventuallyDue();
            List<String> other$eventuallyDue = other.getEventuallyDue();
            if (this$eventuallyDue == null ? other$eventuallyDue != null : !((Object)this$eventuallyDue).equals(other$eventuallyDue)) {
                return false;
            }
            List<String> this$pastDue = this.getPastDue();
            List<String> other$pastDue = other.getPastDue();
            if (this$pastDue == null ? other$pastDue != null : !((Object)this$pastDue).equals(other$pastDue)) {
                return false;
            }
            List<String> this$pendingVerification = this.getPendingVerification();
            List<String> other$pendingVerification = other.getPendingVerification();
            return !(this$pendingVerification == null ? other$pendingVerification != null : !((Object)this$pendingVerification).equals(other$pendingVerification));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof FutureRequirements;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            List<Alternative> $alternatives = this.getAlternatives();
            result = result * 59 + ($alternatives == null ? 43 : ((Object)$alternatives).hashCode());
            List<String> $currentlyDue = this.getCurrentlyDue();
            result = result * 59 + ($currentlyDue == null ? 43 : ((Object)$currentlyDue).hashCode());
            List<Errors> $errors = this.getErrors();
            result = result * 59 + ($errors == null ? 43 : ((Object)$errors).hashCode());
            List<String> $eventuallyDue = this.getEventuallyDue();
            result = result * 59 + ($eventuallyDue == null ? 43 : ((Object)$eventuallyDue).hashCode());
            List<String> $pastDue = this.getPastDue();
            result = result * 59 + ($pastDue == null ? 43 : ((Object)$pastDue).hashCode());
            List<String> $pendingVerification = this.getPendingVerification();
            result = result * 59 + ($pendingVerification == null ? 43 : ((Object)$pendingVerification).hashCode());
            return result;
        }

        public static class Errors
        extends StripeObject {
            @SerializedName(value="code")
            String code;
            @SerializedName(value="reason")
            String reason;
            @SerializedName(value="requirement")
            String requirement;

            @Generated
            public String getCode() {
                return this.code;
            }

            @Generated
            public String getReason() {
                return this.reason;
            }

            @Generated
            public String getRequirement() {
                return this.requirement;
            }

            @Generated
            public void setCode(String code) {
                this.code = code;
            }

            @Generated
            public void setReason(String reason) {
                this.reason = reason;
            }

            @Generated
            public void setRequirement(String requirement) {
                this.requirement = requirement;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Errors)) {
                    return false;
                }
                Errors other = (Errors)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                String this$code = this.getCode();
                String other$code = other.getCode();
                if (this$code == null ? other$code != null : !this$code.equals(other$code)) {
                    return false;
                }
                String this$reason = this.getReason();
                String other$reason = other.getReason();
                if (this$reason == null ? other$reason != null : !this$reason.equals(other$reason)) {
                    return false;
                }
                String this$requirement = this.getRequirement();
                String other$requirement = other.getRequirement();
                return !(this$requirement == null ? other$requirement != null : !this$requirement.equals(other$requirement));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof Errors;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                String $code = this.getCode();
                result = result * 59 + ($code == null ? 43 : $code.hashCode());
                String $reason = this.getReason();
                result = result * 59 + ($reason == null ? 43 : $reason.hashCode());
                String $requirement = this.getRequirement();
                result = result * 59 + ($requirement == null ? 43 : $requirement.hashCode());
                return result;
            }
        }

        public static class Alternative
        extends StripeObject {
            @SerializedName(value="alternative_fields_due")
            List<String> alternativeFieldsDue;
            @SerializedName(value="original_fields_due")
            List<String> originalFieldsDue;

            @Generated
            public List<String> getAlternativeFieldsDue() {
                return this.alternativeFieldsDue;
            }

            @Generated
            public List<String> getOriginalFieldsDue() {
                return this.originalFieldsDue;
            }

            @Generated
            public void setAlternativeFieldsDue(List<String> alternativeFieldsDue) {
                this.alternativeFieldsDue = alternativeFieldsDue;
            }

            @Generated
            public void setOriginalFieldsDue(List<String> originalFieldsDue) {
                this.originalFieldsDue = originalFieldsDue;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Alternative)) {
                    return false;
                }
                Alternative other = (Alternative)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                List<String> this$alternativeFieldsDue = this.getAlternativeFieldsDue();
                List<String> other$alternativeFieldsDue = other.getAlternativeFieldsDue();
                if (this$alternativeFieldsDue == null ? other$alternativeFieldsDue != null : !((Object)this$alternativeFieldsDue).equals(other$alternativeFieldsDue)) {
                    return false;
                }
                List<String> this$originalFieldsDue = this.getOriginalFieldsDue();
                List<String> other$originalFieldsDue = other.getOriginalFieldsDue();
                return !(this$originalFieldsDue == null ? other$originalFieldsDue != null : !((Object)this$originalFieldsDue).equals(other$originalFieldsDue));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof Alternative;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                List<String> $alternativeFieldsDue = this.getAlternativeFieldsDue();
                result = result * 59 + ($alternativeFieldsDue == null ? 43 : ((Object)$alternativeFieldsDue).hashCode());
                List<String> $originalFieldsDue = this.getOriginalFieldsDue();
                result = result * 59 + ($originalFieldsDue == null ? 43 : ((Object)$originalFieldsDue).hashCode());
                return result;
            }
        }
    }

    public static class Relationship
    extends StripeObject {
        @SerializedName(value="director")
        Boolean director;
        @SerializedName(value="executive")
        Boolean executive;
        @SerializedName(value="owner")
        Boolean owner;
        @SerializedName(value="percent_ownership")
        BigDecimal percentOwnership;
        @SerializedName(value="representative")
        Boolean representative;
        @SerializedName(value="title")
        String title;

        @Generated
        public Boolean getDirector() {
            return this.director;
        }

        @Generated
        public Boolean getExecutive() {
            return this.executive;
        }

        @Generated
        public Boolean getOwner() {
            return this.owner;
        }

        @Generated
        public BigDecimal getPercentOwnership() {
            return this.percentOwnership;
        }

        @Generated
        public Boolean getRepresentative() {
            return this.representative;
        }

        @Generated
        public String getTitle() {
            return this.title;
        }

        @Generated
        public void setDirector(Boolean director) {
            this.director = director;
        }

        @Generated
        public void setExecutive(Boolean executive) {
            this.executive = executive;
        }

        @Generated
        public void setOwner(Boolean owner) {
            this.owner = owner;
        }

        @Generated
        public void setPercentOwnership(BigDecimal percentOwnership) {
            this.percentOwnership = percentOwnership;
        }

        @Generated
        public void setRepresentative(Boolean representative) {
            this.representative = representative;
        }

        @Generated
        public void setTitle(String title) {
            this.title = title;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Relationship)) {
                return false;
            }
            Relationship other = (Relationship)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Boolean this$director = this.getDirector();
            Boolean other$director = other.getDirector();
            if (this$director == null ? other$director != null : !((Object)this$director).equals(other$director)) {
                return false;
            }
            Boolean this$executive = this.getExecutive();
            Boolean other$executive = other.getExecutive();
            if (this$executive == null ? other$executive != null : !((Object)this$executive).equals(other$executive)) {
                return false;
            }
            Boolean this$owner = this.getOwner();
            Boolean other$owner = other.getOwner();
            if (this$owner == null ? other$owner != null : !((Object)this$owner).equals(other$owner)) {
                return false;
            }
            Boolean this$representative = this.getRepresentative();
            Boolean other$representative = other.getRepresentative();
            if (this$representative == null ? other$representative != null : !((Object)this$representative).equals(other$representative)) {
                return false;
            }
            BigDecimal this$percentOwnership = this.getPercentOwnership();
            BigDecimal other$percentOwnership = other.getPercentOwnership();
            if (this$percentOwnership == null ? other$percentOwnership != null : !((Object)this$percentOwnership).equals(other$percentOwnership)) {
                return false;
            }
            String this$title = this.getTitle();
            String other$title = other.getTitle();
            return !(this$title == null ? other$title != null : !this$title.equals(other$title));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof Relationship;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Boolean $director = this.getDirector();
            result = result * 59 + ($director == null ? 43 : ((Object)$director).hashCode());
            Boolean $executive = this.getExecutive();
            result = result * 59 + ($executive == null ? 43 : ((Object)$executive).hashCode());
            Boolean $owner = this.getOwner();
            result = result * 59 + ($owner == null ? 43 : ((Object)$owner).hashCode());
            Boolean $representative = this.getRepresentative();
            result = result * 59 + ($representative == null ? 43 : ((Object)$representative).hashCode());
            BigDecimal $percentOwnership = this.getPercentOwnership();
            result = result * 59 + ($percentOwnership == null ? 43 : ((Object)$percentOwnership).hashCode());
            String $title = this.getTitle();
            result = result * 59 + ($title == null ? 43 : $title.hashCode());
            return result;
        }
    }

    public static class Requirements
    extends StripeObject {
        @SerializedName(value="alternatives")
        List<Alternative> alternatives;
        @SerializedName(value="currently_due")
        List<String> currentlyDue;
        @SerializedName(value="errors")
        List<Errors> errors;
        @SerializedName(value="eventually_due")
        List<String> eventuallyDue;
        @SerializedName(value="past_due")
        List<String> pastDue;
        @SerializedName(value="pending_verification")
        List<String> pendingVerification;

        @Generated
        public List<Alternative> getAlternatives() {
            return this.alternatives;
        }

        @Generated
        public List<String> getCurrentlyDue() {
            return this.currentlyDue;
        }

        @Generated
        public List<Errors> getErrors() {
            return this.errors;
        }

        @Generated
        public List<String> getEventuallyDue() {
            return this.eventuallyDue;
        }

        @Generated
        public List<String> getPastDue() {
            return this.pastDue;
        }

        @Generated
        public List<String> getPendingVerification() {
            return this.pendingVerification;
        }

        @Generated
        public void setAlternatives(List<Alternative> alternatives) {
            this.alternatives = alternatives;
        }

        @Generated
        public void setCurrentlyDue(List<String> currentlyDue) {
            this.currentlyDue = currentlyDue;
        }

        @Generated
        public void setErrors(List<Errors> errors) {
            this.errors = errors;
        }

        @Generated
        public void setEventuallyDue(List<String> eventuallyDue) {
            this.eventuallyDue = eventuallyDue;
        }

        @Generated
        public void setPastDue(List<String> pastDue) {
            this.pastDue = pastDue;
        }

        @Generated
        public void setPendingVerification(List<String> pendingVerification) {
            this.pendingVerification = pendingVerification;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Requirements)) {
                return false;
            }
            Requirements other = (Requirements)o;
            if (!other.canEqual(this)) {
                return false;
            }
            List<Alternative> this$alternatives = this.getAlternatives();
            List<Alternative> other$alternatives = other.getAlternatives();
            if (this$alternatives == null ? other$alternatives != null : !((Object)this$alternatives).equals(other$alternatives)) {
                return false;
            }
            List<String> this$currentlyDue = this.getCurrentlyDue();
            List<String> other$currentlyDue = other.getCurrentlyDue();
            if (this$currentlyDue == null ? other$currentlyDue != null : !((Object)this$currentlyDue).equals(other$currentlyDue)) {
                return false;
            }
            List<Errors> this$errors = this.getErrors();
            List<Errors> other$errors = other.getErrors();
            if (this$errors == null ? other$errors != null : !((Object)this$errors).equals(other$errors)) {
                return false;
            }
            List<String> this$eventuallyDue = this.getEventuallyDue();
            List<String> other$eventuallyDue = other.getEventuallyDue();
            if (this$eventuallyDue == null ? other$eventuallyDue != null : !((Object)this$eventuallyDue).equals(other$eventuallyDue)) {
                return false;
            }
            List<String> this$pastDue = this.getPastDue();
            List<String> other$pastDue = other.getPastDue();
            if (this$pastDue == null ? other$pastDue != null : !((Object)this$pastDue).equals(other$pastDue)) {
                return false;
            }
            List<String> this$pendingVerification = this.getPendingVerification();
            List<String> other$pendingVerification = other.getPendingVerification();
            return !(this$pendingVerification == null ? other$pendingVerification != null : !((Object)this$pendingVerification).equals(other$pendingVerification));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof Requirements;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            List<Alternative> $alternatives = this.getAlternatives();
            result = result * 59 + ($alternatives == null ? 43 : ((Object)$alternatives).hashCode());
            List<String> $currentlyDue = this.getCurrentlyDue();
            result = result * 59 + ($currentlyDue == null ? 43 : ((Object)$currentlyDue).hashCode());
            List<Errors> $errors = this.getErrors();
            result = result * 59 + ($errors == null ? 43 : ((Object)$errors).hashCode());
            List<String> $eventuallyDue = this.getEventuallyDue();
            result = result * 59 + ($eventuallyDue == null ? 43 : ((Object)$eventuallyDue).hashCode());
            List<String> $pastDue = this.getPastDue();
            result = result * 59 + ($pastDue == null ? 43 : ((Object)$pastDue).hashCode());
            List<String> $pendingVerification = this.getPendingVerification();
            result = result * 59 + ($pendingVerification == null ? 43 : ((Object)$pendingVerification).hashCode());
            return result;
        }

        public static class Errors
        extends StripeObject {
            @SerializedName(value="code")
            String code;
            @SerializedName(value="reason")
            String reason;
            @SerializedName(value="requirement")
            String requirement;

            @Generated
            public String getCode() {
                return this.code;
            }

            @Generated
            public String getReason() {
                return this.reason;
            }

            @Generated
            public String getRequirement() {
                return this.requirement;
            }

            @Generated
            public void setCode(String code) {
                this.code = code;
            }

            @Generated
            public void setReason(String reason) {
                this.reason = reason;
            }

            @Generated
            public void setRequirement(String requirement) {
                this.requirement = requirement;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Errors)) {
                    return false;
                }
                Errors other = (Errors)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                String this$code = this.getCode();
                String other$code = other.getCode();
                if (this$code == null ? other$code != null : !this$code.equals(other$code)) {
                    return false;
                }
                String this$reason = this.getReason();
                String other$reason = other.getReason();
                if (this$reason == null ? other$reason != null : !this$reason.equals(other$reason)) {
                    return false;
                }
                String this$requirement = this.getRequirement();
                String other$requirement = other.getRequirement();
                return !(this$requirement == null ? other$requirement != null : !this$requirement.equals(other$requirement));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof Errors;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                String $code = this.getCode();
                result = result * 59 + ($code == null ? 43 : $code.hashCode());
                String $reason = this.getReason();
                result = result * 59 + ($reason == null ? 43 : $reason.hashCode());
                String $requirement = this.getRequirement();
                result = result * 59 + ($requirement == null ? 43 : $requirement.hashCode());
                return result;
            }
        }

        public static class Alternative
        extends StripeObject {
            @SerializedName(value="alternative_fields_due")
            List<String> alternativeFieldsDue;
            @SerializedName(value="original_fields_due")
            List<String> originalFieldsDue;

            @Generated
            public List<String> getAlternativeFieldsDue() {
                return this.alternativeFieldsDue;
            }

            @Generated
            public List<String> getOriginalFieldsDue() {
                return this.originalFieldsDue;
            }

            @Generated
            public void setAlternativeFieldsDue(List<String> alternativeFieldsDue) {
                this.alternativeFieldsDue = alternativeFieldsDue;
            }

            @Generated
            public void setOriginalFieldsDue(List<String> originalFieldsDue) {
                this.originalFieldsDue = originalFieldsDue;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Alternative)) {
                    return false;
                }
                Alternative other = (Alternative)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                List<String> this$alternativeFieldsDue = this.getAlternativeFieldsDue();
                List<String> other$alternativeFieldsDue = other.getAlternativeFieldsDue();
                if (this$alternativeFieldsDue == null ? other$alternativeFieldsDue != null : !((Object)this$alternativeFieldsDue).equals(other$alternativeFieldsDue)) {
                    return false;
                }
                List<String> this$originalFieldsDue = this.getOriginalFieldsDue();
                List<String> other$originalFieldsDue = other.getOriginalFieldsDue();
                return !(this$originalFieldsDue == null ? other$originalFieldsDue != null : !((Object)this$originalFieldsDue).equals(other$originalFieldsDue));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof Alternative;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                List<String> $alternativeFieldsDue = this.getAlternativeFieldsDue();
                result = result * 59 + ($alternativeFieldsDue == null ? 43 : ((Object)$alternativeFieldsDue).hashCode());
                List<String> $originalFieldsDue = this.getOriginalFieldsDue();
                result = result * 59 + ($originalFieldsDue == null ? 43 : ((Object)$originalFieldsDue).hashCode());
                return result;
            }
        }
    }

    public static class Verification
    extends StripeObject {
        @SerializedName(value="additional_document")
        AdditionalDocument additionalDocument;
        @SerializedName(value="details")
        String details;
        @SerializedName(value="details_code")
        String detailsCode;
        @SerializedName(value="document")
        Document document;
        @SerializedName(value="status")
        String status;

        @Generated
        public AdditionalDocument getAdditionalDocument() {
            return this.additionalDocument;
        }

        @Generated
        public String getDetails() {
            return this.details;
        }

        @Generated
        public String getDetailsCode() {
            return this.detailsCode;
        }

        @Generated
        public Document getDocument() {
            return this.document;
        }

        @Generated
        public String getStatus() {
            return this.status;
        }

        @Generated
        public void setAdditionalDocument(AdditionalDocument additionalDocument) {
            this.additionalDocument = additionalDocument;
        }

        @Generated
        public void setDetails(String details) {
            this.details = details;
        }

        @Generated
        public void setDetailsCode(String detailsCode) {
            this.detailsCode = detailsCode;
        }

        @Generated
        public void setDocument(Document document) {
            this.document = document;
        }

        @Generated
        public void setStatus(String status) {
            this.status = status;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Verification)) {
                return false;
            }
            Verification other = (Verification)o;
            if (!other.canEqual(this)) {
                return false;
            }
            AdditionalDocument this$additionalDocument = this.getAdditionalDocument();
            AdditionalDocument other$additionalDocument = other.getAdditionalDocument();
            if (this$additionalDocument == null ? other$additionalDocument != null : !((Object)this$additionalDocument).equals(other$additionalDocument)) {
                return false;
            }
            String this$details = this.getDetails();
            String other$details = other.getDetails();
            if (this$details == null ? other$details != null : !this$details.equals(other$details)) {
                return false;
            }
            String this$detailsCode = this.getDetailsCode();
            String other$detailsCode = other.getDetailsCode();
            if (this$detailsCode == null ? other$detailsCode != null : !this$detailsCode.equals(other$detailsCode)) {
                return false;
            }
            Document this$document = this.getDocument();
            Document other$document = other.getDocument();
            if (this$document == null ? other$document != null : !((Object)this$document).equals(other$document)) {
                return false;
            }
            String this$status = this.getStatus();
            String other$status = other.getStatus();
            return !(this$status == null ? other$status != null : !this$status.equals(other$status));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof Verification;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            AdditionalDocument $additionalDocument = this.getAdditionalDocument();
            result = result * 59 + ($additionalDocument == null ? 43 : ((Object)$additionalDocument).hashCode());
            String $details = this.getDetails();
            result = result * 59 + ($details == null ? 43 : $details.hashCode());
            String $detailsCode = this.getDetailsCode();
            result = result * 59 + ($detailsCode == null ? 43 : $detailsCode.hashCode());
            Document $document = this.getDocument();
            result = result * 59 + ($document == null ? 43 : ((Object)$document).hashCode());
            String $status = this.getStatus();
            result = result * 59 + ($status == null ? 43 : $status.hashCode());
            return result;
        }

        public static class AdditionalDocument
        extends StripeObject {
            @SerializedName(value="back")
            ExpandableField<File> back;
            @SerializedName(value="details")
            String details;
            @SerializedName(value="details_code")
            String detailsCode;
            @SerializedName(value="front")
            ExpandableField<File> front;

            public String getBack() {
                return this.back != null ? this.back.getId() : null;
            }

            public void setBack(String id) {
                this.back = ApiResource.setExpandableFieldId(id, this.back);
            }

            public File getBackObject() {
                return this.back != null ? this.back.getExpanded() : null;
            }

            public void setBackObject(File expandableObject) {
                this.back = new ExpandableField<File>(expandableObject.getId(), expandableObject);
            }

            public String getFront() {
                return this.front != null ? this.front.getId() : null;
            }

            public void setFront(String id) {
                this.front = ApiResource.setExpandableFieldId(id, this.front);
            }

            public File getFrontObject() {
                return this.front != null ? this.front.getExpanded() : null;
            }

            public void setFrontObject(File expandableObject) {
                this.front = new ExpandableField<File>(expandableObject.getId(), expandableObject);
            }

            @Generated
            public String getDetails() {
                return this.details;
            }

            @Generated
            public String getDetailsCode() {
                return this.detailsCode;
            }

            @Generated
            public void setDetails(String details) {
                this.details = details;
            }

            @Generated
            public void setDetailsCode(String detailsCode) {
                this.detailsCode = detailsCode;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof AdditionalDocument)) {
                    return false;
                }
                AdditionalDocument other = (AdditionalDocument)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                String this$back = this.getBack();
                String other$back = other.getBack();
                if (this$back == null ? other$back != null : !this$back.equals(other$back)) {
                    return false;
                }
                String this$details = this.getDetails();
                String other$details = other.getDetails();
                if (this$details == null ? other$details != null : !this$details.equals(other$details)) {
                    return false;
                }
                String this$detailsCode = this.getDetailsCode();
                String other$detailsCode = other.getDetailsCode();
                if (this$detailsCode == null ? other$detailsCode != null : !this$detailsCode.equals(other$detailsCode)) {
                    return false;
                }
                String this$front = this.getFront();
                String other$front = other.getFront();
                return !(this$front == null ? other$front != null : !this$front.equals(other$front));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof AdditionalDocument;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                String $back = this.getBack();
                result = result * 59 + ($back == null ? 43 : $back.hashCode());
                String $details = this.getDetails();
                result = result * 59 + ($details == null ? 43 : $details.hashCode());
                String $detailsCode = this.getDetailsCode();
                result = result * 59 + ($detailsCode == null ? 43 : $detailsCode.hashCode());
                String $front = this.getFront();
                result = result * 59 + ($front == null ? 43 : $front.hashCode());
                return result;
            }
        }

        public static class Document
        extends StripeObject {
            @SerializedName(value="back")
            ExpandableField<File> back;
            @SerializedName(value="details")
            String details;
            @SerializedName(value="details_code")
            String detailsCode;
            @SerializedName(value="front")
            ExpandableField<File> front;

            public String getBack() {
                return this.back != null ? this.back.getId() : null;
            }

            public void setBack(String id) {
                this.back = ApiResource.setExpandableFieldId(id, this.back);
            }

            public File getBackObject() {
                return this.back != null ? this.back.getExpanded() : null;
            }

            public void setBackObject(File expandableObject) {
                this.back = new ExpandableField<File>(expandableObject.getId(), expandableObject);
            }

            public String getFront() {
                return this.front != null ? this.front.getId() : null;
            }

            public void setFront(String id) {
                this.front = ApiResource.setExpandableFieldId(id, this.front);
            }

            public File getFrontObject() {
                return this.front != null ? this.front.getExpanded() : null;
            }

            public void setFrontObject(File expandableObject) {
                this.front = new ExpandableField<File>(expandableObject.getId(), expandableObject);
            }

            @Generated
            public String getDetails() {
                return this.details;
            }

            @Generated
            public String getDetailsCode() {
                return this.detailsCode;
            }

            @Generated
            public void setDetails(String details) {
                this.details = details;
            }

            @Generated
            public void setDetailsCode(String detailsCode) {
                this.detailsCode = detailsCode;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Document)) {
                    return false;
                }
                Document other = (Document)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                String this$back = this.getBack();
                String other$back = other.getBack();
                if (this$back == null ? other$back != null : !this$back.equals(other$back)) {
                    return false;
                }
                String this$details = this.getDetails();
                String other$details = other.getDetails();
                if (this$details == null ? other$details != null : !this$details.equals(other$details)) {
                    return false;
                }
                String this$detailsCode = this.getDetailsCode();
                String other$detailsCode = other.getDetailsCode();
                if (this$detailsCode == null ? other$detailsCode != null : !this$detailsCode.equals(other$detailsCode)) {
                    return false;
                }
                String this$front = this.getFront();
                String other$front = other.getFront();
                return !(this$front == null ? other$front != null : !this$front.equals(other$front));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof Document;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                String $back = this.getBack();
                result = result * 59 + ($back == null ? 43 : $back.hashCode());
                String $details = this.getDetails();
                result = result * 59 + ($details == null ? 43 : $details.hashCode());
                String $detailsCode = this.getDetailsCode();
                result = result * 59 + ($detailsCode == null ? 43 : $detailsCode.hashCode());
                String $front = this.getFront();
                result = result * 59 + ($front == null ? 43 : $front.hashCode());
                return result;
            }
        }
    }
}

