/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.android.stripe3ds2.security;

import com.stripe.android.stripe3ds2.exceptions.SDKRuntimeException;
import com.stripe.android.stripe3ds2.observability.ErrorReporter;
import java.security.KeyFactory;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.interfaces.ECPrivateKey;
import java.security.interfaces.ECPublicKey;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nJ\u000e\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\nR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/stripe/android/stripe3ds2/security/EcKeyFactory;", "", "errorReporter", "Lcom/stripe/android/stripe3ds2/observability/ErrorReporter;", "(Lcom/stripe/android/stripe3ds2/observability/ErrorReporter;)V", "keyFactory", "Ljava/security/KeyFactory;", "createPrivate", "Ljava/security/interfaces/ECPrivateKey;", "privateKeyEncoded", "", "createPublic", "Ljava/security/interfaces/ECPublicKey;", "publicKeyEncoded", "3ds2sdk_release"})
public final class EcKeyFactory {
    @NotNull
    private final ErrorReporter errorReporter;
    @NotNull
    private final KeyFactory keyFactory;

    /*
     * WARNING - void declaration
     */
    public EcKeyFactory(@NotNull ErrorReporter errorReporter2) {
        Object object;
        Object $this$keyFactory_u24lambda_u2d02;
        Intrinsics.checkNotNullParameter((Object)errorReporter2, (String)"errorReporter");
        this.errorReporter = errorReporter2;
        Object object2 = this;
        EcKeyFactory ecKeyFactory = this;
        try {
            $this$keyFactory_u24lambda_u2d02 = object2;
            boolean bl = false;
            object = Result.constructor-impl((Object)KeyFactory.getInstance("EC"));
        }
        catch (Throwable $this$keyFactory_u24lambda_u2d02) {
            object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)$this$keyFactory_u24lambda_u2d02));
        }
        EcKeyFactory ecKeyFactory2 = ecKeyFactory;
        object2 = object;
        Throwable throwable = Result.exceptionOrNull-impl((Object)object2);
        if (throwable != null) {
            void it;
            Throwable throwable2 = throwable;
            ecKeyFactory = ecKeyFactory2;
            boolean bl = false;
            this.errorReporter.reportError((Throwable)it);
            ecKeyFactory2 = ecKeyFactory;
        }
        Throwable throwable3 = Result.exceptionOrNull-impl((Object)object2);
        if (throwable3 != null) {
            void error;
            $this$keyFactory_u24lambda_u2d02 = throwable3;
            boolean bl = false;
            throw new SDKRuntimeException((Throwable)error);
        }
        Object object3 = object2;
        Intrinsics.checkNotNullExpressionValue((Object)object3, (String)"runCatching {\n          \u2026xception(error)\n        }");
        ecKeyFactory2.keyFactory = (KeyFactory)object3;
    }

    @NotNull
    public final ECPublicKey createPublic(@NotNull byte[] publicKeyEncoded) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)publicKeyEncoded, (String)"publicKeyEncoded");
        Object object2 = this;
        try {
            EcKeyFactory $this$createPublic_u24lambda_u2d3 = object2;
            boolean bl = false;
            PublicKey publicKey = $this$createPublic_u24lambda_u2d3.keyFactory.generatePublic(new X509EncodedKeySpec(publicKeyEncoded));
            if (publicKey == null) {
                throw new NullPointerException("null cannot be cast to non-null type java.security.interfaces.ECPublicKey");
            }
            object = Result.constructor-impl((Object)((ECPublicKey)publicKey));
        }
        catch (Throwable $this$createPublic_u24lambda_u2d3) {
            object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)$this$createPublic_u24lambda_u2d3));
        }
        object2 = object;
        Throwable throwable = Result.exceptionOrNull-impl((Object)object2);
        if (throwable != null) {
            Throwable it = throwable;
            boolean bl = false;
            this.errorReporter.reportError(it);
        }
        Throwable throwable2 = Result.exceptionOrNull-impl((Object)object2);
        if (throwable2 != null) {
            Throwable it = throwable2;
            boolean bl = false;
            throw new SDKRuntimeException(it);
        }
        return (ECPublicKey)object2;
    }

    @NotNull
    public final ECPrivateKey createPrivate(@NotNull byte[] privateKeyEncoded) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)privateKeyEncoded, (String)"privateKeyEncoded");
        Object object2 = this;
        try {
            EcKeyFactory $this$createPrivate_u24lambda_u2d6 = object2;
            boolean bl = false;
            PrivateKey privateKey = $this$createPrivate_u24lambda_u2d6.keyFactory.generatePrivate(new PKCS8EncodedKeySpec(privateKeyEncoded));
            if (privateKey == null) {
                throw new NullPointerException("null cannot be cast to non-null type java.security.interfaces.ECPrivateKey");
            }
            object = Result.constructor-impl((Object)((ECPrivateKey)privateKey));
        }
        catch (Throwable $this$createPrivate_u24lambda_u2d6) {
            object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)$this$createPrivate_u24lambda_u2d6));
        }
        object2 = object;
        Throwable throwable = Result.exceptionOrNull-impl((Object)object2);
        if (throwable != null) {
            Throwable it = throwable;
            boolean bl = false;
            throw new SDKRuntimeException(it);
        }
        return (ECPrivateKey)object2;
    }
}

