/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.android.stripe3ds2.init.ui;

import android.os.Parcel;
import android.os.Parcelable;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.stripe.android.stripe3ds2.exceptions.InvalidInputException;
import com.stripe.android.stripe3ds2.init.ui.BaseCustomization;
import com.stripe.android.stripe3ds2.init.ui.TextBoxCustomization;
import com.stripe.android.stripe3ds2.utils.CustomizeUtils;
import com.stripe.android.stripe3ds2.utils.ObjectUtils;

public final class StripeTextBoxCustomization
extends BaseCustomization
implements TextBoxCustomization,
Parcelable {
    public static final Parcelable.Creator<StripeTextBoxCustomization> CREATOR = new Parcelable.Creator<StripeTextBoxCustomization>(){

        public StripeTextBoxCustomization createFromParcel(@NonNull Parcel in) {
            return new StripeTextBoxCustomization(in);
        }

        public StripeTextBoxCustomization[] newArray(int size) {
            return new StripeTextBoxCustomization[size];
        }
    };
    private int mBorderWidth;
    @Nullable
    private String mBorderColor;
    private int mCornerRadius;
    @Nullable
    private String mHintTextColor;

    public StripeTextBoxCustomization() {
    }

    private StripeTextBoxCustomization(@NonNull Parcel in) {
        super(in);
        this.mBorderWidth = in.readInt();
        this.mBorderColor = in.readString();
        this.mCornerRadius = in.readInt();
        this.mHintTextColor = in.readString();
    }

    @Override
    public void setBorderWidth(int borderWidth) throws InvalidInputException {
        this.mBorderWidth = CustomizeUtils.requireValidDimension(borderWidth);
    }

    @Override
    public int getBorderWidth() {
        return this.mBorderWidth;
    }

    @Override
    public void setBorderColor(@NonNull String borderColor) throws InvalidInputException {
        this.mBorderColor = CustomizeUtils.requireValidColor(borderColor);
    }

    @Override
    @Nullable
    public String getBorderColor() {
        return this.mBorderColor;
    }

    @Override
    public void setCornerRadius(int cornerRadius) throws InvalidInputException {
        this.mCornerRadius = CustomizeUtils.requireValidDimension(cornerRadius);
    }

    @Override
    public int getCornerRadius() {
        return this.mCornerRadius;
    }

    @Override
    public void setHintTextColor(@NonNull String hintTextColor) throws InvalidInputException {
        this.mHintTextColor = CustomizeUtils.requireValidColor(hintTextColor);
    }

    @Override
    @Nullable
    public String getHintTextColor() {
        return this.mHintTextColor;
    }

    public boolean equals(@Nullable Object obj) {
        return this == obj || obj instanceof StripeTextBoxCustomization && this.typedEquals((StripeTextBoxCustomization)obj);
    }

    private boolean typedEquals(@NonNull StripeTextBoxCustomization textBoxCustomization) {
        return this.mBorderWidth == textBoxCustomization.mBorderWidth && ObjectUtils.equals(this.mBorderColor, textBoxCustomization.mBorderColor) && this.mCornerRadius == textBoxCustomization.mCornerRadius && ObjectUtils.equals(this.mHintTextColor, textBoxCustomization.mHintTextColor);
    }

    public int hashCode() {
        return ObjectUtils.hash(this.mBorderWidth, this.mBorderColor, this.mCornerRadius, this.mHintTextColor);
    }

    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(@NonNull Parcel dest, int flags) {
        super.writeToParcel(dest, flags);
        dest.writeInt(this.mBorderWidth);
        dest.writeString(this.mBorderColor);
        dest.writeInt(this.mCornerRadius);
        dest.writeString(this.mHintTextColor);
    }
}

