﻿
StiJsViewer.prototype.DashboardElement = function (elementAttributes) {
    var element = document.createElement("div");
    element.style.display = "inline-block";
    element.style.position = "absolute";
    element.style.top = elementAttributes.top + "px";
    element.style.left = elementAttributes.left + "px";
    element.style.width = elementAttributes.width;
    element.style.height = elementAttributes.height;
    element.style.margin = elementAttributes.margin.split(",").join("px ") + "px";
    element.buttons = {};
    element.innerHTML = elementAttributes.content;

    var buttonsPanel = document.createElement("div");
    buttonsPanel.className = "stiJsViewerDashboardElementButtonsPanel";
    buttonsPanel.element = element;
    element.buttonsPanel = buttonsPanel;
    element.appendChild(buttonsPanel);

    buttonsPanel.checkVisibleState = function () {
        this.style.opacity = this.element.isMouseOver ? 0.9 : 0;
    }

    var buttonsTable = this.CreateHTMLTable();
    buttonsPanel.appendChild(buttonsTable);
    buttonsTable.className = "stiJsViewerToolBarTable";
    buttonsTable.style.border = 0;
    buttonsTable.style.margin = 0;
    buttonsTable.style.background = "transparent";
    buttonsTable.style.boxSizing = "border-box";

    // FullScreen element button
    var buttonFullScreen = this.SmallButton(null, null, "OpenFullScreen.png");
    buttonFullScreen.jsObject = this;
    buttonFullScreen.buttonsPanel = buttonsPanel;
    buttonFullScreen.elementName = elementAttributes.name;
    buttonFullScreen.action = function () {
        this.jsObject.reportParams.elementName = this.jsObject.reportParams.elementName == this.elementName ? null : this.elementName;
        this.jsObject.postAction("GetPages");
    };
    buttonFullScreen.setSelectedBase = buttonFullScreen.setSelected;
    buttonFullScreen.setSelected = function (state) {
        buttonFullScreen.setSelectedBase(state);
        this.image.src = this.jsObject.collections.images[(this.isSelected ? "Close" : "Open") + "FullScreen.png"];
        this.onmouseoutAction();
    };
    buttonFullScreen.setSelected(this.reportParams.elementName == elementAttributes.name);
    buttonsTable.addCell(buttonFullScreen);
    element.buttons.fullScreen = buttonFullScreen;

    // Export element menu button
    var buttonExport = this.SmallButton(null, null, "Menu.png");
    buttonExport.jsObject = this;
    buttonExport.buttonsPanel = buttonsPanel;
    buttonExport.elementName = elementAttributes.name;
    buttonExport.action = function () {
        this.jsObject.controls.menus.saveDashboardMenu.changeVisibleState(true, this);
    };
    buttonExport.setSelectedBase = buttonExport.setSelected;
    buttonExport.setSelected = function (state) {
        buttonExport.setSelectedBase(state);
        this.buttonsPanel.checkVisibleState();
    };
    buttonsTable.addCell(buttonExport);
    element.buttons.export = buttonExport;

    // Events

    element.onmouseover = function () {
        this.isMouseOver = true;
        this.buttonsPanel.checkVisibleState();
    }

    element.onmouseout = function () {
        this.isMouseOver = false;
        if (!this.buttons.export.isSelected) this.buttonsPanel.checkVisibleState();
    }

    return element;
}
