
StiMobileDesigner.prototype.CreatePage = function (pageObject, isDashboard) {
    var page = this.CreateSvgElement("svg");    
    page.jsObject = this;
    page.typeComponent = "StiPage";
    page.style.margin = this.options.paintPanelPadding + "px";
    page.style.display = "none";
    page.style.border = "1px solid " + (!isDashboard ? "#c6c6c6" : "transparent");
    page.style.overflow = "hidden";
    page.isDashboard = isDashboard;    

    //Set Properties
    page.properties = {};
    page.properties.name = pageObject.name;
    page.properties.pageIndex = pageObject.pageIndex;
    page.properties.largeHeightAutoFactor = "1";
    this.WriteAllProperties(page, pageObject.properties);    

    //Create Controls
    page.controls = {};
    this.CreatePageBackgroundGradient(page);
    this.CreatePageBackgroundHatch(page);
    this.CreatePageWaterMark(page);
    this.CreatePageWaterMarkGradient(page);
    this.CreatePageWaterMarkImage(page);
    this.CreatePageBorders(page);

    if (this.options.report && this.options.report.info.showGrid)
        this.CreatePageGridLines(page);

    if ((!this.options.jsMode || this.options.nodeJsMode) && this.options.productVersion == this.options.productVersion.trim())
        this.CreatePageWaterMarkChars(page);

    this.options.infoPanel.checkState();
    //Create Methods
    this.CreatePageEvents(page);

    var jsObject = this;
    page.repaint = function (rebuildGrigLines) { jsObject.RepaintPage(this, rebuildGrigLines); }
    page.remove = function () { jsObject.RemovePage(this); }
    page.rebuild = function (componentsProps) { jsObject.RebuildPage(this, componentsProps); }
    page.setSelected = function () { jsObject.SetSelectedObject(this); }
    page.rename = function (newName) { jsObject.RenamePage(this, newName); }
    page.addComponents = function () { jsObject.AddComponents(this); }
    page.removeComponents = function () { jsObject.RemoveComponents(this); }
    page.updateComponentsLevels = function () { jsObject.UpdateComponentsLevels(this); }
    page.repaintAllComponents = function () { jsObject.RepaintAllComponentsOnPage(this); }

    return page;
}

//GridLines
StiMobileDesigner.prototype.CreatePageGridLines = function (page) {
    var jsObject = this;
    var gridSize = page.isDashboard ? page.properties.gridSize : this.options.report.gridSize;
    var pageWidth = this.ConvertUnitToPixel(this.StrToDouble(page.properties.unitWidth), page.isDashboard);
    var pageHeight = this.ConvertUnitToPixel(this.StrToDouble(page.properties.unitHeight), page.isDashboard);
    var marginsStr = page.properties.unitMargins.split("!");
    var verticalMarginsPx = parseInt(this.ConvertUnitToPixel(this.StrToDouble(marginsStr[1]) + this.StrToDouble(marginsStr[3]), page.isDashboard));
    var horizontalMarginsPx = parseInt(this.ConvertUnitToPixel(this.StrToDouble(marginsStr[0]) + this.StrToDouble(marginsStr[2]), page.isDashboard));
    var segmentPerHeight = this.StrToDouble(page.properties.segmentPerHeight);
    var segmentPerWidth = this.StrToDouble(page.properties.segmentPerWidth);
    if (segmentPerWidth > 1) pageWidth = ((pageWidth - horizontalMarginsPx) * segmentPerWidth) + horizontalMarginsPx;
    if (segmentPerHeight > 1) pageHeight = ((pageHeight - verticalMarginsPx) * segmentPerHeight) + verticalMarginsPx;
    var largeHeightFactor = page.properties.largeHeight ? this.StrToInt(page.properties.largeHeightFactor) : this.StrToDouble(page.properties.largeHeightAutoFactor);

    if (page.controls.gridLines) {
        for (i = 0; i < page.controls.gridLines.length; i++)
            page.removeChild(page.controls.gridLines[i]);
    }

    var margins = page.properties.unitMargins.split("!");
    var marginsPx = [];
    for (i = 0; i < 4; i++) {
        marginsPx[i] = this.ConvertUnitToPixel(this.StrToDouble(margins[i]), page.isDashboard);
    }

    var startXPos = marginsPx[0];
    var endXPos = pageWidth - marginsPx[2];
    var startYPos = marginsPx[1];
    var endYPos = largeHeightFactor > 1 ? (pageHeight - marginsPx[3] - marginsPx[1]) * largeHeightFactor + marginsPx[1] : pageHeight - marginsPx[3];

    var createGridLine = function (x1, y1, x2, y2) {
        var line = jsObject.CreateSvgElement("line");
        line.style.stroke = "#dcdcdc";
        line.positions = { x1: x1, y1: y1, x2: x2, y2: y2 };
        page.controls.gridLines.push(line);
        page.insertBefore(line, page.controls.borders[0]);

        line.repaint = function () {
            var XOffset = jsObject.options.xOffset;
            var YOffset = jsObject.options.yOffset;
            line.setAttribute("x1", line.positions.x1 * jsObject.options.report.zoom + XOffset);
            line.setAttribute("y1", line.positions.y1 * jsObject.options.report.zoom + YOffset);
            line.setAttribute("x2", line.positions.x2 * jsObject.options.report.zoom + XOffset);
            line.setAttribute("y2", line.positions.y2 * jsObject.options.report.zoom + YOffset);
            line.style.strokeDasharray = jsObject.options.report.info.gridMode == "Lines" ? "1" : ("1," + (gridSize * jsObject.options.report.zoom - 1));
        }

        return line;
    }

    page.controls.gridLines = [];

    var x = startXPos;
    var i = 0;
    while (x <= endXPos) {
        if (!(page.isDashboard && (x == startXPos || x + gridSize > endXPos || i % 2 != 0))) {
            var line = createGridLine(x, startYPos, x, endYPos);
            if (i % 2 == 0) line.style.stroke = page.isDashboard ? "#dcdcdc" : "#bebebe";
        }
        x += gridSize;
        i++;
    }

    if (jsObject.options.report.info.gridMode == "Lines") {
        var y = startYPos;
        i = 0;
        while (y <= endYPos) {
            if (!(page.isDashboard && (y == startYPos || y + gridSize > endYPos || i % 2 != 0))) {
                var line = createGridLine(startXPos, y, endXPos, y);
                if (i % 2 == 0) line.style.stroke = page.isDashboard ? "#dcdcdc" : "#bebebe";
            }
            y += gridSize;
            i++;
        }
    }
}

// Borders
StiMobileDesigner.prototype.CreatePageBorders = function (page) {
    page.controls.borders = [];
    for (i = 0; i < 8; i ++) {
        page.controls.borders[i] = this.CreateSvgElement("line");
        page.appendChild(page.controls.borders[i]);
    }
}

// Watermark
StiMobileDesigner.prototype.CreatePageWaterMark = function (page) {
    page.controls.waterMarkParent = this.CreateSvgElement("g");
    page.appendChild(page.controls.waterMarkParent);
    page.controls.waterMarkChild = this.CreateSvgElement("g");
    page.controls.waterMarkParent.appendChild(page.controls.waterMarkChild);
    page.controls.waterMarkText = this.CreateSvgElement("text");
    page.controls.waterMarkChild.appendChild(page.controls.waterMarkText);
}

// Watermark Chars
StiMobileDesigner.prototype.CreatePageWaterMarkChars = function (page) {
    page.controls.waterMarkCharsParent = this.CreateSvgElement("g");
    page.appendChild(page.controls.waterMarkCharsParent);        
    page.controls.waterMarkCharsChild = this.CreateSvgElement("g");
    page.controls.waterMarkCharsParent.appendChild(page.controls.waterMarkCharsChild);
    page.controls.waterMarkCharsText = this.CreateSvgElement("text");
    page.controls.waterMarkCharsChild.appendChild(page.controls.waterMarkCharsText);
}

// Watermark Image
StiMobileDesigner.prototype.CreatePageWaterMarkImage = function (page) {
    page.controls.waterMarkImage = this.CreateSvgElement("image");
    page.appendChild(page.controls.waterMarkImage);
}

// Background Gradient
StiMobileDesigner.prototype.CreatePageBackgroundGradient = function (page) {
    page.controls.gradient = this.CreateSvgElement("linearGradient");
    page.appendChild(page.controls.gradient);
    var gradientId = "gradient" + this.newGuid().replace(/-/g, '');
    page.controls.gradient.setAttribute("id", gradientId);
    page.controls.gradient.setAttribute("x1", "0%");
    page.controls.gradient.setAttribute("y1", "0%");
    page.controls.gradient.setAttribute("x2", "100%");
    page.controls.gradient.setAttribute("y2", "0%");
    page.controls.gradient.stop1 = this.CreateSvgElement("stop");
    page.controls.gradient.appendChild(page.controls.gradient.stop1);
    page.controls.gradient.stop2 = this.CreateSvgElement("stop");
    page.controls.gradient.stop3 = this.CreateSvgElement("stop");
    page.controls.gradient.appendChild(page.controls.gradient.stop3);
    page.controls.gradient.stop1.setAttribute("offset", "0");
    page.controls.gradient.stop2.setAttribute("offset", "50%");
    page.controls.gradient.stop3.setAttribute("offset", "100%");
    page.controls.gradient.rect = this.CreateSvgElement("rect");
    page.controls.gradient.rect.setAttribute("x", "0");
    page.controls.gradient.rect.setAttribute("y", "0");
    page.controls.gradient.rect.setAttribute("width", "100%");
    page.controls.gradient.rect.setAttribute("height", "100%");
    page.controls.gradient.rect.setAttribute("fill", "url(#" + gradientId + ")");
    page.controls.gradient.rect.style.display = "none";
    page.appendChild(page.controls.gradient.rect);
}

// WaterMark Gradient
StiMobileDesigner.prototype.CreatePageWaterMarkGradient = function (page) {
    page.controls.waterMarkGradient = this.CreateSvgElement("linearGradient");
    page.appendChild(page.controls.waterMarkGradient);
    page.controls.waterMarkGradient.setAttribute("id", "waterMarkGradient" + this.newGuid().replace(/-/g, ''));
    page.controls.waterMarkGradient.setAttribute("x1", "0%");
    page.controls.waterMarkGradient.setAttribute("y1", "0%");
    page.controls.waterMarkGradient.setAttribute("x2", "100%");
    page.controls.waterMarkGradient.setAttribute("y2", "0%");
    page.controls.waterMarkGradient.stop1 = this.CreateSvgElement("stop");
    page.controls.waterMarkGradient.appendChild(page.controls.waterMarkGradient.stop1);
    page.controls.waterMarkGradient.stop2 = this.CreateSvgElement("stop");
    page.controls.waterMarkGradient.appendChild(page.controls.waterMarkGradient.stop2);
    page.controls.waterMarkGradient.stop3 = this.CreateSvgElement("stop");
    page.controls.waterMarkGradient.appendChild(page.controls.waterMarkGradient.stop3);
    page.controls.waterMarkGradient.stop1.setAttribute("offset", "0");
    page.controls.waterMarkGradient.stop2.setAttribute("offset", "50%");
    page.controls.waterMarkGradient.stop3.setAttribute("offset", "100%");
}

// Background Hatch
StiMobileDesigner.prototype.CreatePageBackgroundHatch = function (page) {
    var svgHatchBrush = this.CreateSvgElement("svg");
    page.controls.svgHatchBrush = svgHatchBrush;
    page.appendChild(svgHatchBrush);
}